/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.managelog;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.TreasuryOperationLog;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialInstitutionController;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.fenixframework.DomainObject;
import pt.ist.fenixframework.FenixFramework;

@BennuSpringController(value=FinantialInstitutionController.class)
@RequestMapping(value={"/treasury/administration/base/managetreasuryoperationlog/treasuryoperationlog"})
public class TreasuryOperationLogController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/managetreasuryoperationlog/treasuryoperationlog";
    public static final long SEARCH_LIMIT_SIZE = 75L;
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/managetreasuryoperationlog/treasuryoperationlog/read/";

    private List<TreasuryOperationLog> getTreasuryOperationLogSet(Model model) {
        return (List)model.asMap().get("treasuryOperationLogSet");
    }

    private void setTreasuryOperationLogSet(List<TreasuryOperationLog> treasuryOperationLogSet, Model model) {
        model.addAttribute("treasuryOperationLogSet", treasuryOperationLogSet);
    }

    private DomainObject getDomainObject(Model model) {
        return (DomainObject)model.asMap().get("domainObject");
    }

    private void setDomainObject(DomainObject domainObject, Model model) {
        model.addAttribute("domainObject", (Object)domainObject);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") DomainObject domainObject, @RequestParam(value="logdatefrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate logDateFrom, @RequestParam(value="logdateto", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate logDateTo, Model model, RedirectAttributes redirectAttributes) {
        if (!FenixFramework.isDomainObjectValid((DomainObject)domainObject)) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.read.object.oid.not.valid", (String[])new String[0]), model);
        } else {
            this.setDomainObject(domainObject, model);
            this.setTreasuryOperationLogSet(this.filterSearch(domainObject.getExternalId(), null, logDateFrom, logDateTo), model);
        }
        return "treasury/administration/base/managetreasuryoperationlog/treasuryoperationlog/read";
    }

    private Stream<TreasuryOperationLog> getSearchUniverse() {
        return TreasuryOperationLog.findAll();
    }

    private List<TreasuryOperationLog> filterSearch(String oid, String type, LocalDate from, LocalDate to) {
        return this.getSearchUniverse().filter(log -> oid == null || log.getDomainOid().equals(oid)).filter(log -> type == null || log.getType().equals(type)).filter(log -> from == null || log.getVersioningCreationDate().toLocalDate().isAfter((ReadablePartial)from) || log.getVersioningCreationDate().toLocalDate().isEqual((ReadablePartial)from)).filter(log -> to == null || log.getVersioningCreationDate().toLocalDate().isBefore((ReadablePartial)to) || log.getVersioningCreationDate().toLocalDate().isEqual((ReadablePartial)to)).sorted(TreasuryOperationLog.COMPARATOR_BY_CREATION_DATE).limit(75L).collect(Collectors.toList());
    }
}

