/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.managecustomertype;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.CustomerType;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.base.managecustomertype.CustomerTypeController$callable$createCustomerType;
import org.fenixedu.treasury.ui.administration.base.managecustomertype.CustomerTypeController$callable$deleteCustomerType;
import org.fenixedu.treasury.ui.administration.base.managecustomertype.CustomerTypeController$callable$updateCustomerType;
import org.fenixedu.treasury.util.Constants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.base.manageCustomerType", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/base/managecustomertype/customertype"})
public class CustomerTypeController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/managecustomertype/customertype";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/base/managecustomertype/customertype/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/base/managecustomertype/customertype/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/base/managecustomertype/customertype/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/managecustomertype/customertype/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/base/managecustomertype/customertype/delete/";
    public static final Advice advice$deleteCustomerType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createCustomerType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateCustomerType = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/base/managecustomertype/customertype/";
    }

    private CustomerType getCustomerType(Model m) {
        return (CustomerType)((Object)m.asMap().get("customerType"));
    }

    private void setCustomerType(CustomerType customerType, Model m) {
        m.addAttribute("customerType", (Object)customerType);
    }

    public void deleteCustomerType(CustomerType customerType) {
        Object object = advice$deleteCustomerType.perform((Callable)new CustomerTypeController$callable$deleteCustomerType(this, customerType));
    }

    static /* synthetic */ void advised$deleteCustomerType(CustomerTypeController this_, CustomerType customerType) {
        customerType.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model) {
        List<CustomerType> searchcustomertypeResultsDataSet = this.filterSearchCustomerType(code, name);
        model.addAttribute("searchcustomertypeResultsDataSet", searchcustomertypeResultsDataSet);
        return "treasury/administration/base/managecustomertype/customertype/search";
    }

    private List<CustomerType> getSearchUniverseSearchCustomerTypeDataSet() {
        return CustomerType.findAll().collect(Collectors.toList());
    }

    private List<CustomerType> filterSearchCustomerType(String code, LocalizedString name) {
        return this.getSearchUniverseSearchCustomerTypeDataSet().stream().filter(customerType -> code == null || code.length() == 0 || customerType.getCode() != null && customerType.getCode().length() > 0 && customerType.getCode().toLowerCase().contains(code.toLowerCase())).filter(customerType -> name == null || name.isEmpty() || name.getLocales().stream().allMatch(locale -> customerType.getName().getContent(locale) != null && customerType.getName().getContent(locale).toLowerCase().contains(name.getContent(locale).toLowerCase()))).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") CustomerType customerType, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + customerType.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") CustomerType customerType, Model model) {
        this.setCustomerType(customerType, model);
        return "treasury/administration/base/managecustomertype/customertype/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") CustomerType customerType, Model model, RedirectAttributes redirectAttributes) {
        this.setCustomerType(customerType, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.deleteCustomerType(customerType);
            this.addInfoMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (DomainException ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getCustomerType(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return "treasury/administration/base/managecustomertype/customertype/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsBackOfficeMember(model);
            CustomerType customerType = this.createCustomerType(code, name);
            model.addAttribute("customerType", (Object)customerType);
            return this.redirect(READ_URL + this.getCustomerType(model).getExternalId(), model, redirectAttributes);
        }
        catch (DomainException tde) {
            this.addErrorMessage(tde.getLocalizedMessage(), model);
            return this.create(model);
        }
        catch (Exception tde) {
            this.addErrorMessage(tde.getLocalizedMessage(), model);
            return this.create(model);
        }
    }

    public CustomerType createCustomerType(String string, LocalizedString localizedString) {
        return (CustomerType)((Object)advice$createCustomerType.perform((Callable)new CustomerTypeController$callable$createCustomerType(this, string, localizedString)));
    }

    static /* synthetic */ CustomerType advised$createCustomerType(CustomerTypeController this_, String code, LocalizedString name) {
        CustomerType customerType = CustomerType.create(code, name);
        return customerType;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") CustomerType customerType, Model model) {
        this.setCustomerType(customerType, model);
        return "treasury/administration/base/managecustomertype/customertype/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") CustomerType customerType, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        this.setCustomerType(customerType, model);
        try {
            this.assertUserIsBackOfficeMember(model);
            this.updateCustomerType(code, name, model);
            return this.redirect(READ_URL + this.getCustomerType(model).getExternalId(), model, redirectAttributes);
        }
        catch (DomainException de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
            return this.update(customerType, model);
        }
        catch (Exception de) {
            this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
            return this.update(customerType, model);
        }
    }

    public void updateCustomerType(String string, LocalizedString localizedString, Model model) {
        Object object = advice$updateCustomerType.perform((Callable)new CustomerTypeController$callable$updateCustomerType(this, string, localizedString, model));
    }

    static /* synthetic */ void advised$updateCustomerType(CustomerTypeController this_, String code, LocalizedString name, Model m) {
        this_.getCustomerType(m).edit(code, name);
    }
}

