/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui;

import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.FenixEDUBaseController;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.accesscontrol.TreasuryAccessControl;
import org.fenixedu.treasury.util.Constants;
import org.springframework.ui.Model;

public class TreasuryBaseController
extends FenixEDUBaseController {
    protected void assertUserIsManager(Model model) {
        if (TreasuryAccessControl.getInstance().isManager(Authenticate.getUser())) {
            return;
        }
        this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.manager", (String[])new String[0]), model);
        throw new SecurityException(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.manager", (String[])new String[0]));
    }

    protected void assertUserIsBackOfficeMember(Model model) {
        if (TreasuryAccessControl.getInstance().isBackOfficeMember(Authenticate.getUser())) {
            return;
        }
        this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.backoffice", (String[])new String[0]), model);
        throw new SecurityException(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.backoffice", (String[])new String[0]));
    }

    protected void assertUserIsFrontOfficeMember(Model model) {
        if (TreasuryAccessControl.getInstance().isFrontOfficeMember(Authenticate.getUser())) {
            return;
        }
        this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.frontoffice", (String[])new String[0]), model);
        throw new SecurityException(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.frontoffice", (String[])new String[0]));
    }

    protected void assertUserIsBackOfficeMember(FinantialInstitution finantialInstitution, Model model) {
        if (TreasuryAccessControl.getInstance().isBackOfficeMember(Authenticate.getUser(), finantialInstitution)) {
            return;
        }
        this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.backoffice", (String[])new String[0]), model);
        throw new SecurityException(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.backoffice", (String[])new String[0]));
    }

    protected void assertUserIsAllowToModifySettlements(FinantialInstitution finantialInstitution, Model model) {
        if (TreasuryAccessControl.getInstance().isAllowToModifySettlements(Authenticate.getUser(), finantialInstitution)) {
            return;
        }
        this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.allow.to.modify.settlements", (String[])new String[0]), model);
        throw new SecurityException(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.allow.to.modify.settlements", (String[])new String[0]));
    }

    protected void assertUserIsAllowToModifyInvoices(FinantialInstitution finantialInstitution, Model model) {
        if (TreasuryAccessControl.getInstance().isAllowToModifyInvoices(Authenticate.getUser(), finantialInstitution)) {
            return;
        }
        this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.allow.to.modify.invoices", (String[])new String[0]), model);
        throw new SecurityException(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.allow.to.modify.invoices", (String[])new String[0]));
    }

    protected void assertUserIsFrontOfficeMember(FinantialInstitution finantialInstitution, Model model) {
        if (TreasuryAccessControl.getInstance().isFrontOfficeMember(Authenticate.getUser(), finantialInstitution)) {
            return;
        }
        this.addErrorMessage(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.frontoffice", (String[])new String[0]), model);
        throw new SecurityException(BundleUtil.getString((String)Constants.BUNDLE, (String)"error.authorization.not.frontoffice", (String[])new String[0]));
    }
}

