/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.payments.paymentscodegenerator;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.PaymentCodeGenerator;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.SequentialPaymentCodeGenerator$callable$generateNewCodeFor;
import org.fenixedu.treasury.services.payments.paymentscodegenerator.SequentialPaymentCodeGenerator$callable$generateNewCodeFor$1;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SequentialPaymentCodeGenerator
extends PaymentCodeGenerator {
    private final PaymentCodePool referenceCodePool;
    private static final String CODE_FILLER = "0";
    private static final int NUM_CONTROL_DIGITS = 2;
    private static final int NUM_SEQUENTIAL_NUMBERS = 7;
    public static final Advice advice$generateNewCodeFor = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$generateNewCodeFor$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public SequentialPaymentCodeGenerator(PaymentCodePool pool) {
        this.referenceCodePool = pool;
    }

    protected Set<PaymentReferenceCode> allPaymentCodes() {
        return this.referenceCodePool.getPaymentReferenceCodesSet();
    }

    @Override
    public PaymentReferenceCode generateNewCodeFor(BigDecimal bigDecimal, LocalDate localDate, LocalDate localDate2, boolean bl) {
        return (PaymentReferenceCode)((Object)advice$generateNewCodeFor.perform((Callable)new SequentialPaymentCodeGenerator$callable$generateNewCodeFor(this, bigDecimal, localDate, localDate2, bl)));
    }

    static /* synthetic */ PaymentReferenceCode advised$generateNewCodeFor(SequentialPaymentCodeGenerator this_, BigDecimal amount, LocalDate validFrom, LocalDate validTo, boolean useFixedAmount) {
        return this_.generateNewCodeFor(amount, validFrom, validTo, useFixedAmount, false);
    }

    @Override
    public PaymentReferenceCode generateNewCodeFor(BigDecimal bigDecimal, LocalDate localDate, LocalDate localDate2, boolean bl, boolean bl2) {
        return (PaymentReferenceCode)((Object)advice$generateNewCodeFor$1.perform((Callable)new SequentialPaymentCodeGenerator$callable$generateNewCodeFor$1(this, bigDecimal, localDate, localDate2, bl, bl2)));
    }

    static /* synthetic */ PaymentReferenceCode advised$generateNewCodeFor(SequentialPaymentCodeGenerator this_, BigDecimal amount, LocalDate validFrom, LocalDate validTo, boolean useFixedAmount, boolean forceGeneration) {
        if (!forceGeneration) {
            for (PaymentReferenceCode paymentReferenceCode : this_.referenceCodePool.getPaymentReferenceCodesSet()) {
                if (!paymentReferenceCode.isNew() || Constants.isGreaterThan(amount, paymentReferenceCode.getMaxAmount()) || Constants.isLessThan(amount, paymentReferenceCode.getMinAmount()) || paymentReferenceCode.getTargetPayment() != null || validTo != null && !paymentReferenceCode.getValidInterval().contains((ReadableInstant)validTo.toDateTimeAtStartOfDay()) || !paymentReferenceCode.getValidInterval().contains((ReadableInstant)new DateTime()) || validFrom != null && !paymentReferenceCode.getValidInterval().contains((ReadableInstant)validFrom.toDateTimeAtStartOfDay()) || !paymentReferenceCode.getValidInterval().contains((ReadableInstant)new DateTime())) continue;
                paymentReferenceCode.setPayableAmount(amount);
                return paymentReferenceCode;
            }
        }
        if (!this_.canGenerateNewCode(forceGeneration)) {
            throw new RuntimeException("Cannot generate new payment codes");
        }
        Long nextSequentialNumber = this_.referenceCodePool.getAndIncrementNextReferenceCode();
        String sequentialNumberPadded = StringUtils.leftPad((String)String.valueOf(nextSequentialNumber), (int)7, (String)CODE_FILLER);
        String controDigitsPadded = StringUtils.leftPad((String)String.valueOf(new Random().nextInt(99)), (int)2, (String)CODE_FILLER);
        String referenceCodeString = sequentialNumberPadded + controDigitsPadded;
        BigDecimal minAmount = this_.referenceCodePool.getMinAmount();
        BigDecimal maxAmount = this_.referenceCodePool.getMaxAmount();
        if (useFixedAmount) {
            minAmount = amount;
            maxAmount = amount;
        } else if (Constants.isGreaterThan(amount, maxAmount)) {
            maxAmount = amount;
        }
        PaymentReferenceCode newPaymentReference = PaymentReferenceCode.create(referenceCodeString, validFrom, validTo, PaymentReferenceCodeStateType.UNUSED, this_.referenceCodePool, minAmount, maxAmount);
        newPaymentReference.setPayableAmount(amount);
        return newPaymentReference;
    }

    @Override
    public boolean isCodeMadeByThisFactory(PaymentReferenceCode paymentCode) {
        return paymentCode.getPaymentCodePool().equals(this);
    }

    @Override
    public PaymentCodePool getReferenceCodePool() {
        return this.referenceCodePool;
    }
}

