/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation;

import com.qubit.solution.fenixedu.bennu.webservices.services.client.BennuWebServiceClient;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.UnaryOperator;
import javax.xml.ws.BindingProvider;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.integration.IntegrationOperationLogBean;
import org.fenixedu.treasury.generated.sources.saft.singap.siag.AuditFile;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.ReimbursementStateBean;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.SINGAPExternalService$callable$createStaticInitializer;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.SOAPLoggingHandler;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import org.fenixedu.treasury.services.integration.erp.IERPImporter;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentStatusWS;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationInput;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationOutput;
import org.fenixedu.treasury.services.integration.erp.singap.ArrayOfResposta;
import org.fenixedu.treasury.services.integration.erp.singap.Resposta;
import org.fenixedu.treasury.services.integration.erp.singap.Service;
import org.fenixedu.treasury.services.integration.erp.singap.ServiceSoap;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagExporter;
import org.fenixedu.treasury.services.integration.erp.singap.siag.SingapSiagImporter;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SINGAPExternalService
extends BennuWebServiceClient<ServiceSoap>
implements IERPExternalService {
    public static final Advice advice$createStaticInitializer = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private static void createStaticInitializer() {
        Object object = advice$createStaticInitializer.perform((Callable)new SINGAPExternalService$callable$createStaticInitializer());
    }

    static /* synthetic */ void advised$createStaticInitializer() {
        new SINGAPExternalService();
    }

    public ServiceSoap getClient() {
        ServiceSoap client = (ServiceSoap)super.getClient();
        return client;
    }

    @Override
    public DocumentsInformationOutput sendInfoOnline(FinantialInstitution finantialInstutition, DocumentsInformationInput documentsInformation) {
        DocumentsInformationOutput output = new DocumentsInformationOutput();
        output.setDocumentStatus(new ArrayList<DocumentStatusWS>());
        ServiceSoap client = this.getClient();
        SOAPLoggingHandler loggingHandler = SOAPLoggingHandler.createLoggingHandler((BindingProvider)client);
        Map requestContext = ((BindingProvider)client).getRequestContext();
        requestContext.put("com.sun.xml.ws.request.timeout", 15000);
        requestContext.put("com.sun.xml.ws.connect.timeout", 2000);
        ArrayOfResposta carregarSAFTON = client.carregarSAFTON(documentsInformation.getData());
        output.setSoapInboundMessage("");
        output.setSoapOutboundMessage("");
        for (Resposta resposta : carregarSAFTON.getResposta()) {
            output.setRequestId(resposta.getChavePrimaria());
            DocumentStatusWS status = new DocumentStatusWS();
            status.setDocumentNumber(resposta.getChavePrimaria());
            status.setErrorDescription(String.format("[STATUS: %s] - %s", resposta.getStatus(), resposta.getMensagem()));
            status.setIntegrationStatus(this.covertToStatusType(resposta.getStatus()));
            output.getDocumentStatus().add(status);
        }
        return output;
    }

    @Override
    public String sendInfoOffline(DocumentsInformationInput documentsInformation) {
        Resposta carregarSAFT = this.getClient().carregarSAFTOFF(documentsInformation.getDataURI());
        return carregarSAFT.getChavePrimaria();
    }

    @Override
    public List<DocumentStatusWS> getIntegrationStatusFor(String finantialInstitution, List<String> documentsInformation) {
        ArrayList<DocumentStatusWS> statusList = new ArrayList<DocumentStatusWS>();
        for (String docId : documentsInformation) {
            Resposta verificaEstado = this.getClient().verificaEstado(docId);
            DocumentStatusWS docStatus = new DocumentStatusWS();
            docStatus.setDocumentNumber(docId);
            docStatus.setErrorDescription(verificaEstado.getMensagem());
            docStatus.setIntegrationStatus(this.covertToStatusType(verificaEstado.getStatus()));
            statusList.add(docStatus);
        }
        return statusList;
    }

    private DocumentStatusWS.StatusType covertToStatusType(String status) {
        if ("OK".equals(status)) {
            return DocumentStatusWS.StatusType.SUCCESS;
        }
        return DocumentStatusWS.StatusType.ERROR;
    }

    protected BindingProvider getService() {
        BindingProvider prov = (BindingProvider)new Service().getServiceSoap();
        return prov;
    }

    public UnaryOperator<AuditFile> getAuditFilePreProcessOperator() {
        return x -> x;
    }

    @Override
    public IERPExporter getERPExporter() {
        return new SingapSiagExporter();
    }

    @Override
    public IERPImporter getERPImporter(InputStream inputStream) {
        return new SingapSiagImporter(inputStream);
    }

    @Override
    public byte[] downloadCertifiedDocumentPrint(String finantialInstitution, String finantialDocumentNumber, String erpIdProcess) {
        throw new RuntimeException("not implemented");
    }

    @Override
    public ReimbursementStateBean checkReimbursementState(SettlementNote reimbursementNote, IntegrationOperationLogBean logBean) {
        throw new RuntimeException("not implemented");
    }

    static {
        SINGAPExternalService.createStaticInitializer();
    }
}

