/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation;

import com.google.common.base.Strings;
import com.qubit.solution.fenixedu.bennu.webservices.services.client.BennuWebServiceClient;
import com.sun.xml.ws.fault.ServerSOAPFaultException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.ws.BindingProvider;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStatusType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.domain.integration.IntegrationOperationLogBean;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.ReimbursementStateBean;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.SOAPLoggingHandler;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import org.fenixedu.treasury.services.integration.erp.IERPImporter;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentStatusWS;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationInput;
import org.fenixedu.treasury.services.integration.erp.dto.DocumentsInformationOutput;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.services.integration.erp.sap.SAPImporter;
import org.fenixedu.treasury.services.integration.erp.sap.ZULWSFATURACAOCLIENTESBLK;
import org.fenixedu.treasury.services.integration.erp.sap.ZULWSFATURACAOCLIENTESBLK_Service;
import org.fenixedu.treasury.services.integration.erp.sap.ZulfwscustomersReturn1S;
import org.fenixedu.treasury.services.integration.erp.sap.ZulwsDocumentosInput;
import org.fenixedu.treasury.services.integration.erp.sap.ZulwsDocumentosOutput;
import org.fenixedu.treasury.services.integration.erp.sap.ZulwsReembolsosInput;
import org.fenixedu.treasury.services.integration.erp.sap.ZulwsReembolsosOutput;
import org.fenixedu.treasury.services.integration.erp.sap.ZulwsdocumentStatusWs1;
import org.fenixedu.treasury.services.integration.erp.sap.ZulwsfaturacaoClientesIn;
import org.fenixedu.treasury.services.integration.erp.sap.ZulwsfaturacaoClientesOut;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;

public class SAPExternalService
extends BennuWebServiceClient<ZULWSFATURACAOCLIENTESBLK>
implements IERPExternalService {
    private static final String S_KEY = "S";

    @Override
    public DocumentsInformationOutput sendInfoOnline(FinantialInstitution finantialInstitution, DocumentsInformationInput documentsInformation) {
        DocumentsInformationOutput output = new DocumentsInformationOutput();
        output.setDocumentStatus(new ArrayList<DocumentStatusWS>());
        ZULWSFATURACAOCLIENTESBLK client = (ZULWSFATURACAOCLIENTESBLK)this.getClient();
        SOAPLoggingHandler loggingHandler = SOAPLoggingHandler.createLoggingHandler((BindingProvider)client);
        Map requestContext = ((BindingProvider)client).getRequestContext();
        requestContext.put("com.sun.xml.ws.request.timeout", 15000);
        requestContext.put("com.sun.xml.ws.connect.timeout", 2000);
        ZulwsfaturacaoClientesIn auditFile = new ZulwsfaturacaoClientesIn();
        auditFile.setFinantialInstitution(documentsInformation.getFinantialInstitution());
        auditFile.setData(documentsInformation.getData());
        ZulwsfaturacaoClientesOut zulwsfaturacaoClientesOut = client.zulfmwsFaturacaoClientes(auditFile);
        output.setRequestId(zulwsfaturacaoClientesOut.getRequestId());
        boolean hasSettlementFailed = this.hasSettlementFailed(finantialInstitution, zulwsfaturacaoClientesOut);
        boolean isSomeDocAssociatedWithReimbursementFailed = this.isSomeDocAssociatedWithReimbursementFailed(finantialInstitution, zulwsfaturacaoClientesOut);
        for (ZulwsdocumentStatusWs1 zulwsdocumentStatusWs1 : zulwsfaturacaoClientesOut.getDocumentStatus().getItem()) {
            DocumentStatusWrapper itemWrapper = new DocumentStatusWrapper(finantialInstitution, zulwsdocumentStatusWs1);
            DocumentStatusWS status = new DocumentStatusWS();
            status.setDocumentNumber(itemWrapper.getDocumentNumber());
            status.setErrorDescription(String.format("[STATUS: %s] - %s", itemWrapper.getIntegrationStatus(), itemWrapper.getErrorDescription()));
            status.setIntegrationStatus(this.convertToStatusType(itemWrapper, hasSettlementFailed, isSomeDocAssociatedWithReimbursementFailed));
            status.setSapDocumentNumber(itemWrapper.getSapDocumentNumber());
            output.getDocumentStatus().add(status);
        }
        for (ZulfwscustomersReturn1S zulfwscustomersReturn1S : zulwsfaturacaoClientesOut.getCustomers().getItem()) {
            String erpCustomerId = zulfwscustomersReturn1S.getCustomerIdSap();
            String integrationStatus = zulfwscustomersReturn1S.getIntegrationStatus();
            String returnMsg = zulfwscustomersReturn1S.getReturnMsg();
            String fenixCustomerId = zulfwscustomersReturn1S.getCustomerId();
            String otherMessage = String.format("%s (SAP n\u00ba %s): [%s] %s", Constants.bundle("label.SAPExternalService.customer.integration.result", new String[0]), !Strings.isNullOrEmpty((String)erpCustomerId) ? erpCustomerId : "", integrationStatus, returnMsg);
            output.getOtherMessages().add(otherMessage);
            if (!S_KEY.equals(integrationStatus)) continue;
            this.saveErpCustomerId(output, erpCustomerId, fenixCustomerId);
        }
        output.setSoapInboundMessage(loggingHandler.getInboundMessage());
        output.setSoapOutboundMessage(loggingHandler.getOutboundMessage());
        return output;
    }

    private void saveErpCustomerId(DocumentsInformationOutput output, String erpCustomerId, String fenixCustomerId) {
        if (Strings.isNullOrEmpty((String)fenixCustomerId)) {
            String message = String.format("%s %s", Constants.bundle("label.SAPExternalService.customer.integration.result", new String[0]), Constants.bundle("label.SAPExternalService.warning.customer.id.empty", new String[0]));
            output.getOtherMessages().add(message);
            return;
        }
        if (Strings.isNullOrEmpty((String)erpCustomerId) || Strings.isNullOrEmpty((String)erpCustomerId.trim())) {
            String message = String.format("%s %s", Constants.bundle("label.SAPExternalService.customer.integration.result", new String[0]), Constants.bundle("label.SAPExternalService.warning.erp.customer.id.empty", new String[0]));
            output.getOtherMessages().add(message);
            return;
        }
        Optional<? extends Customer> customerOptional = Customer.findByCode(fenixCustomerId).findAny();
        if (!customerOptional.isPresent()) {
            String message = String.format("%s %s", Constants.bundle("label.SAPExternalService.customer.integration.result", new String[0]), Constants.bundle("label.SAPExternalService.warning.customer.with.code.not.found", fenixCustomerId));
            output.getOtherMessages().add(message);
            return;
        }
        Customer customer = customerOptional.get();
        if (customer.getErpCustomerId() != null && customer.getErpCustomerId().equals(erpCustomerId)) {
            String message = String.format("%s %s", Constants.bundle("label.SAPExternalService.customer.integration.result", new String[0]), Constants.bundle("label.SAPExternalService.info.customer.with.erp.id.already.set", customer.getCode(), erpCustomerId));
            output.getOtherMessages().add(message);
            return;
        }
        if (customer.getErpCustomerId() != null && !customer.getErpCustomerId().equals(erpCustomerId)) {
            String message = String.format("%s %s", Constants.bundle("label.SAPExternalService.customer.integration.result", new String[0]), Constants.bundle("label.SAPExternalService.warning.erp.customer.id.not.equal", customer.getCode(), erpCustomerId, customer.getErpCustomerId()));
            output.getOtherMessages().add(message);
            return;
        }
        if (customer.getErpCustomerId() == null) {
            String message = String.format("%s %s", Constants.bundle("label.SAPExternalService.customer.integration.result", new String[0]), Constants.bundle("label.SAPExternalService.info.customer.with.erp.id.set", customer.getCode(), erpCustomerId));
            output.getOtherMessages().add(message);
            customer.setErpCustomerId(erpCustomerId);
        }
    }

    private boolean isSomeDocAssociatedWithReimbursementFailed(FinantialInstitution finantialInstitution, ZulwsfaturacaoClientesOut zulwsfaturacaoClientesOut) {
        boolean isSomeDocAssociatedWithReimbursementFailed = false;
        for (ZulwsdocumentStatusWs1 item : zulwsfaturacaoClientesOut.getDocumentStatus().getItem()) {
            DocumentStatusWrapper itemWrapper = new DocumentStatusWrapper(finantialInstitution, item);
            if (itemWrapper.isSettlementNote()) continue;
            isSomeDocAssociatedWithReimbursementFailed |= itemWrapper.integrationStatus() != DocumentStatusWS.StatusType.SUCCESS;
        }
        return isSomeDocAssociatedWithReimbursementFailed;
    }

    private boolean hasSettlementFailed(FinantialInstitution finantialInstitution, ZulwsfaturacaoClientesOut zulwsfaturacaoClientesOut) {
        boolean hasSettlementFailed = false;
        for (ZulwsdocumentStatusWs1 item : zulwsfaturacaoClientesOut.getDocumentStatus().getItem()) {
            DocumentStatusWrapper itemWrapper = new DocumentStatusWrapper(finantialInstitution, item);
            if (!itemWrapper.isSettlementNote()) continue;
            hasSettlementFailed |= itemWrapper.integrationStatus() != DocumentStatusWS.StatusType.SUCCESS;
        }
        return hasSettlementFailed;
    }

    private DocumentStatusWS.StatusType convertToStatusType(DocumentStatusWrapper itemWrapper, boolean hasSettlementFailed, boolean isSomeDocAssociatedWithReimbursementFailed) {
        String status = itemWrapper.getIntegrationStatus();
        String sapDocumentNumber = itemWrapper.getSapDocumentNumber();
        if (itemWrapper.isReimbursement()) {
            return !isSomeDocAssociatedWithReimbursementFailed && S_KEY.equals(status) ? DocumentStatusWS.StatusType.SUCCESS : DocumentStatusWS.StatusType.ERROR;
        }
        if (!Strings.isNullOrEmpty((String)sapDocumentNumber) && S_KEY.equals(status) && !hasSettlementFailed) {
            return DocumentStatusWS.StatusType.SUCCESS;
        }
        return DocumentStatusWS.StatusType.ERROR;
    }

    @Override
    public String sendInfoOffline(DocumentsInformationInput documentsInformation) {
        throw new RuntimeException("not.implemented");
    }

    @Override
    public List<DocumentStatusWS> getIntegrationStatusFor(String finantialInstiution, List<String> documentInformaton) {
        throw new RuntimeException("not.implemented");
    }

    @Override
    public byte[] downloadCertifiedDocumentPrint(String finantialInstitution, String finantialDocumentNumber, String erpIdProcess) {
        ZULWSFATURACAOCLIENTESBLK client = (ZULWSFATURACAOCLIENTESBLK)this.getClient();
        Map requestContext = ((BindingProvider)client).getRequestContext();
        requestContext.put("com.sun.xml.ws.request.timeout", 15000);
        requestContext.put("com.sun.xml.ws.connect.timeout", 2000);
        ZulwsDocumentosInput input = new ZulwsDocumentosInput();
        input.setTaxRegistrationNumber(finantialInstitution);
        input.setFinantialDocumentNumber(finantialDocumentNumber);
        input.setIdProcesso(erpIdProcess);
        try {
            DocumentStatusWS.StatusType status;
            ZulwsDocumentosOutput zulwsDocumentos = client.zulwsDocumentos(input);
            DocumentStatusWS.StatusType statusType = status = S_KEY.equals(zulwsDocumentos.getStatus()) ? DocumentStatusWS.StatusType.SUCCESS : DocumentStatusWS.StatusType.ERROR;
            if (status != DocumentStatusWS.StatusType.SUCCESS) {
                throw new TreasuryDomainException("error.IERPExternalService.getCertifiedDocumentPrinted.unable.to.retrieve.document", zulwsDocumentos.getErrorDescription());
            }
            return zulwsDocumentos.getBinary();
        }
        catch (ServerSOAPFaultException e) {
            e.printStackTrace();
            throw new TreasuryDomainException((Throwable)e, "error.IERPExternalService.getCertifiedDocumentPrinted.unable.to.retrieve.document", e.getMessage());
        }
    }

    @Override
    public ReimbursementStateBean checkReimbursementState(SettlementNote reimbursementNote, IntegrationOperationLogBean logBean) {
        ERPConfiguration erpConfiguration = reimbursementNote.getDebtAccount().getFinantialInstitution().getErpIntegrationConfiguration();
        ZULWSFATURACAOCLIENTESBLK client = (ZULWSFATURACAOCLIENTESBLK)this.getClient();
        SOAPLoggingHandler loggingHandler = SOAPLoggingHandler.createLoggingHandler((BindingProvider)client);
        Map requestContext = ((BindingProvider)client).getRequestContext();
        requestContext.put("com.sun.xml.ws.request.timeout", 15000);
        requestContext.put("com.sun.xml.ws.connect.timeout", 2000);
        CreditNote creditNote = (CreditNote)((Object)reimbursementNote.getSettlemetEntries().findFirst().get().getInvoiceEntry().getFinantialDocument());
        ZulwsReembolsosInput input = new ZulwsReembolsosInput();
        input.setFinantialDocumentNumber(creditNote.getUiDocumentNumber());
        input.setIdProcesso(erpConfiguration.getErpIdProcess());
        input.setTaxRegistrationNumber(reimbursementNote.getDebtAccount().getFinantialInstitution().getFiscalNumber());
        ZulwsReembolsosOutput zulwsReembolsos = client.zulwsReembolsos(input);
        logBean.defineSoapInboundMessage(loggingHandler.getInboundMessage());
        logBean.defineSoapOutboundMessage(loggingHandler.getOutboundMessage());
        Optional<ReimbursementProcessStatusType> reimbursementStatus = ReimbursementProcessStatusType.findUniqueByCode(zulwsReembolsos.getReimbursementStatusCode());
        boolean success = true;
        if (!reimbursementStatus.isPresent()) {
            success = false;
            logBean.appendErrorLog(String.format("Erro na leitura do estado do reembolso: '%s'", zulwsReembolsos.getReimbursementStatusCode()));
        }
        DateTime reimbursementStatusDate = null;
        try {
            reimbursementStatusDate = new DateTime((Object)zulwsReembolsos.getReimbursementStatusDate()).toLocalDate().toDateTimeAtStartOfDay();
        }
        catch (IllegalArgumentException e) {
            success = false;
            logBean.appendErrorLog("Erro na leitura da data: " + zulwsReembolsos.getReimbursementStatusDate());
        }
        if (Strings.isNullOrEmpty((String)zulwsReembolsos.getExerciseYear())) {
            success = false;
            logBean.appendErrorLog("Erro na leitura do ano de exercicio: " + zulwsReembolsos.getExerciseYear());
        }
        ReimbursementStateBean stateBean = new ReimbursementStateBean(reimbursementNote, reimbursementStatus.orElse(null), zulwsReembolsos.getExerciseYear(), reimbursementStatusDate, success);
        return stateBean;
    }

    @Override
    public IERPExporter getERPExporter() {
        return new SAPExporter();
    }

    @Override
    public IERPImporter getERPImporter(InputStream inputStream) {
        return new SAPImporter(inputStream);
    }

    protected BindingProvider getService() {
        BindingProvider prov = (BindingProvider)new ZULWSFATURACAOCLIENTESBLK_Service().getZULWSFATURACAOCLIENTESBLK();
        return prov;
    }

    private class DocumentStatusWrapper {
        private FinantialInstitution finantialInstitution;
        private ZulwsdocumentStatusWs1 itemStatus;

        private DocumentStatusWrapper(FinantialInstitution finantialInstitution, ZulwsdocumentStatusWs1 itemStatus) {
            this.finantialInstitution = finantialInstitution;
            this.itemStatus = itemStatus;
        }

        private String getIntegrationStatus() {
            return this.itemStatus.getIntegrationStatus();
        }

        private String getErrorDescription() {
            return this.itemStatus.getErrorDescription();
        }

        private String getDocumentNumber() {
            return this.itemStatus.getDocumentNumber();
        }

        private String getSapDocumentNumber() {
            return this.itemStatus.getSapDocumentNumber();
        }

        private boolean isSettlementNote() {
            FinantialDocument fd = FinantialDocument.findByUiDocumentNumber(this.finantialInstitution, this.itemStatus.getDocumentNumber());
            if (fd == null) {
                return false;
            }
            return fd.isSettlementNote();
        }

        private boolean isReimbursement() {
            FinantialDocument fd = FinantialDocument.findByUiDocumentNumber(this.finantialInstitution, this.itemStatus.getDocumentNumber());
            if (fd == null) {
                return false;
            }
            return fd.isSettlementNote() && ((SettlementNote)((Object)fd)).isReimbursement();
        }

        private DocumentStatusWS.StatusType integrationStatus() {
            return SAPExternalService.this.convertToStatusType(this, false, false);
        }
    }
}

