/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.TaskRunner;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.ERPCustomerFieldsBean;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStateLog;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager$2$callable$run;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager$callable$exportFinantialDocumentToXML;
import org.fenixedu.treasury.services.integration.erp.ERPExternalServiceImplementation.ReimbursementStateBean;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.services.integration.erp.tasks.ERPExportSingleDocumentsTask;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ERPExporterManager {
    private static final int WAIT_TRANSACTION_TO_FINISH_MS = 500;
    public static final Comparator<FinantialDocument> COMPARE_BY_DOCUMENT_TYPE;
    private static final int LIMIT = 200;
    public static final Advice advice$exportFinantialDocumentToXML;

    public static String saftEncoding(FinantialInstitution finantialInstitution) {
        IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        return erpExporter.saftEncoding();
    }

    public static String exportFinantialDocumentToXML(FinantialDocument finantialDocument) {
        return (String)advice$exportFinantialDocumentToXML.perform((Callable)new ERPExporterManager$callable$exportFinantialDocumentToXML(finantialDocument));
    }

    static /* synthetic */ String advised$exportFinantialDocumentToXML(FinantialDocument finantialDocument) {
        FinantialInstitution finantialInstitution = finantialDocument.getDebtAccount().getFinantialInstitution();
        IERPExporter erpExporter = finantialDocument.getDebtAccount().getFinantialInstitution().getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        return erpExporter.exportFinantialDocumentToXML(finantialInstitution, Lists.newArrayList((Object[])new FinantialDocument[]{finantialDocument}));
    }

    public static List<ERPExportOperation> exportPendingDocumentsForFinantialInstitution(FinantialInstitution finantialInstitution) {
        IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        if (!finantialInstitution.getErpIntegrationConfiguration().getActive()) {
            return Lists.newArrayList();
        }
        List<FinantialDocument> sortedDocuments = ERPExporterManager.filterDocumentsToExport(finantialInstitution.getFinantialDocumentsPendingForExportationSet().stream());
        if (sortedDocuments.isEmpty()) {
            return Lists.newArrayList();
        }
        if (finantialInstitution.getErpIntegrationConfiguration().getExportOnlyRelatedDocumentsPerExport()) {
            ArrayList result = Lists.newArrayList();
            while (!sortedDocuments.isEmpty()) {
                FinantialDocument doc = sortedDocuments.iterator().next();
                sortedDocuments.remove((Object)doc);
                Customer customer = doc.getDebtAccount().getCustomer();
                ArrayList errorMessages = Lists.newArrayList();
                if (!ERPCustomerFieldsBean.validateAddress(customer, errorMessages) && !doc.getErpExportOperationsSet().isEmpty()) continue;
                result.add(erpExporter.exportFinantialDocumentToIntegration(finantialInstitution, Collections.singletonList(doc)));
            }
            return result;
        }
        return Lists.newArrayList();
    }

    public static List<ERPExportOperation> exportPendingDocumentsForDebtAccount(DebtAccount debtAccount) {
        FinantialInstitution finantialInstitution = debtAccount.getFinantialInstitution();
        List<FinantialDocument> sortedDocuments = ERPExporterManager.filterDocumentsToExport(debtAccount.getFinantialDocumentsSet().stream());
        if (sortedDocuments.isEmpty()) {
            return Lists.newArrayList();
        }
        IERPExporter erpExporter = debtAccount.getFinantialInstitution().getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        if (finantialInstitution.getErpIntegrationConfiguration().getExportOnlyRelatedDocumentsPerExport()) {
            ArrayList result = Lists.newArrayList();
            int i = 0;
            while (!sortedDocuments.isEmpty()) {
                FinantialDocument doc = sortedDocuments.iterator().next();
                sortedDocuments.remove((Object)doc);
                result.add(erpExporter.exportFinantialDocumentToIntegration(finantialInstitution, Collections.singletonList(doc)));
                if (++i < 200) continue;
                System.out.println("ERPExporterManager: Limit 200 finantial documents.");
                break;
            }
            return result;
        }
        return Lists.newArrayList();
    }

    public static void scheduleSingleDocument(FinantialDocument finantialDocument) {
        List<FinantialDocument> documentsToExport = ERPExporterManager.filterDocumentsToExport(Collections.singletonList(finantialDocument).stream());
        if (documentsToExport.isEmpty()) {
            return;
        }
        final String externalId = documentsToExport.iterator().next().getExternalId();
        new Thread(){
            public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

            @Override
            public void run() {
                Object object = advice$run.perform((Callable)new ERPExporterManager$2$callable$run(this));
            }

            static /* synthetic */ void advised$run(2 this_) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SchedulerSystem.queue((TaskRunner)new TaskRunner((CronTask)new ERPExportSingleDocumentsTask(this_.externalId)));
            }
        }.start();
    }

    public static ERPExportOperation exportSingleDocument(FinantialDocument finantialDocument) {
        List<FinantialDocument> documentsToExport = ERPExporterManager.filterDocumentsToExport(Collections.singletonList(finantialDocument).stream());
        if (documentsToExport.isEmpty()) {
            return null;
        }
        FinantialInstitution finantialInstitution = finantialDocument.getDebtAccount().getFinantialInstitution();
        ERPConfiguration erpIntegrationConfiguration = finantialInstitution.getErpIntegrationConfiguration();
        IERPExporter erpExporter = erpIntegrationConfiguration.getERPExternalServiceImplementation().getERPExporter();
        return erpExporter.exportFinantialDocumentToIntegration(finantialInstitution, documentsToExport);
    }

    public static ERPExportOperation exportSettlementNote(SettlementNote settlementNote) {
        List<FinantialDocument> documentsToExport = ERPExporterManager.filterDocumentsToExport(Collections.singletonList(settlementNote).stream());
        if (documentsToExport.isEmpty()) {
            return null;
        }
        for (SettlementEntry settlementEntry : settlementNote.getSettlemetEntriesSet()) {
            if (!settlementEntry.getInvoiceEntry().isDebitNoteEntry()) continue;
            documentsToExport.add(settlementEntry.getInvoiceEntry().getFinantialDocument());
        }
        documentsToExport = ERPExporterManager.filterDocumentsToExport(documentsToExport.stream());
        FinantialInstitution finantialInstitution = settlementNote.getDebtAccount().getFinantialInstitution();
        ERPConfiguration erpIntegrationConfiguration = finantialInstitution.getErpIntegrationConfiguration();
        IERPExporter erpExporter = erpIntegrationConfiguration.getERPExternalServiceImplementation().getERPExporter();
        if (finantialInstitution.getErpIntegrationConfiguration().getExportOnlyRelatedDocumentsPerExport()) {
            ERPExportOperation settlementExportOperation = null;
            while (!documentsToExport.isEmpty()) {
                FinantialDocument doc = documentsToExport.iterator().next();
                documentsToExport.remove((Object)doc);
                ERPExportOperation exportOperation = erpExporter.exportFinantialDocumentToIntegration(finantialInstitution, Collections.singletonList(doc));
                if (settlementNote != doc) continue;
                settlementExportOperation = exportOperation;
            }
            return settlementExportOperation;
        }
        return null;
    }

    public static void requestPendingDocumentStatus(FinantialInstitution finantialInstitution) {
        IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        erpExporter.requestPendingDocumentStatus(finantialInstitution);
    }

    public static ERPExportOperation retryExportToIntegration(ERPExportOperation eRPExportOperation) {
        List<FinantialDocument> documentsToExport = ERPExporterManager.filterDocumentsToExport(eRPExportOperation.getFinantialDocumentsSet().stream());
        return ERPExporterManager.exportSingleDocument(documentsToExport.iterator().next());
    }

    public static byte[] downloadCertifiedDocumentPrint(FinantialDocument finantialDocument) {
        FinantialInstitution finantialInstitution = finantialDocument.getDebtAccount().getFinantialInstitution();
        IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        if (!finantialInstitution.getErpIntegrationConfiguration().getActive()) {
            throw new TreasuryDomainException("error.ERPExporterManager.integration.not.active", new String[0]);
        }
        return erpExporter.downloadCertifiedDocumentPrint(finantialDocument);
    }

    public static void updateReimbursementState(SettlementNote reimbursementNote) {
        FinantialInstitution finantialInstitution = reimbursementNote.getDebtAccount().getFinantialInstitution();
        IERPExporter erpExporter = finantialInstitution.getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
        if (!finantialInstitution.getErpIntegrationConfiguration().getActive()) {
            throw new TreasuryDomainException("error.ERPExporterManager.integration.not.active", new String[0]);
        }
        if (!reimbursementNote.isReimbursement()) {
            throw new RuntimeException("error");
        }
        ReimbursementStateBean reimbursementStateBean = erpExporter.checkReimbursementState(reimbursementNote);
        if (reimbursementStateBean == null) {
            throw new TreasuryDomainException("error.ERPExporterManager.reimbursementStatusBean.null", new String[0]);
        }
        if (reimbursementStateBean.getReimbursementProcessStatus() == null) {
            throw new TreasuryDomainException("error.ERPExporterManager.reimbursementStatus.unknown", new String[0]);
        }
        ReimbursementProcessStateLog.create(reimbursementNote, reimbursementStateBean.getReimbursementProcessStatus(), UUID.randomUUID().toString(), reimbursementStateBean.getReimbursementStateDate(), reimbursementStateBean.getExerciseYear());
        reimbursementNote.processReimbursementStateChange(reimbursementStateBean.getReimbursementProcessStatus(), reimbursementStateBean.getExerciseYear(), reimbursementStateBean.getReimbursementStateDate());
    }

    public static List<FinantialDocument> filterDocumentsToExport(Stream<? extends FinantialDocument> finantialDocumentsStream) {
        List tempList = finantialDocumentsStream.filter(d -> d.isDocumentToExport()).filter(d -> !d.isCreditNote()).filter(d -> d.isAnnulled() || d.isClosed()).filter(d -> d.isDocumentSeriesNumberSet()).filter(x -> x.getCloseDate() != null).filter(x -> x.isDebitNote() || x.isSettlementNote() && !x.getCloseDate().isBefore((ReadableInstant)SAPExporter.ERP_INTEGRATION_START_DATE)).collect(Collectors.toList());
        ArrayList result = Lists.newArrayList();
        result.addAll(tempList.stream().filter(d -> d.isDebitNote()).collect(Collectors.toList()));
        result.addAll(tempList.stream().filter(d -> d.isSettlementNote()).collect(Collectors.toList()));
        if (tempList.size() != result.size()) {
            throw new RuntimeException("error");
        }
        return result;
    }

    static {
        advice$exportFinantialDocumentToXML = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_DOCUMENT_TYPE = new Comparator<FinantialDocument>(){

            @Override
            public int compare(FinantialDocument o1, FinantialDocument o2) {
                if (o1.getFinantialDocumentType().equals((Object)o2.getFinantialDocumentType())) {
                    return o1.getUiDocumentNumber().compareTo(o2.getUiDocumentNumber());
                }
                if (o1.isDebitNote()) {
                    return -2;
                }
                if (o1.isCreditNote()) {
                    return -1;
                }
                if (o1.isSettlementNote()) {
                    return 1;
                }
                return 0;
            }
        };
    }
}

