/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.groups;

import com.google.common.base.Objects;
import java.util.Set;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.groups.CustomGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.treasury.domain.accesscontrol.PersistentTreasuryFrontOfficeGroup;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;

@GroupOperator(value="treasuryFrontOffice")
public class TreasuryFrontOfficeGroup
extends CustomGroup {
    private static final long serialVersionUID = 1L;
    private static final TreasuryFrontOfficeGroup INSTANCE = new TreasuryFrontOfficeGroup();

    private TreasuryFrontOfficeGroup() {
    }

    public static TreasuryFrontOfficeGroup get() {
        return INSTANCE;
    }

    public Set<User> getMembers() {
        return TreasuryAccessControlAPI.getFrontOfficeMembers();
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public String getPresentationName() {
        return BundleUtil.getString((String)Constants.BUNDLE, (String)"label.TreasuryFrontOfficeGroup.description", (String[])new String[0]);
    }

    public boolean isMember(User user) {
        return this.getMembers().contains(user);
    }

    public boolean isMember(User user, DateTime when) {
        return this.getMembers().contains(user);
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentTreasuryFrontOfficeGroup.getInstance();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{TreasuryFrontOfficeGroup.class});
    }

    public boolean equals(Object obj) {
        return obj instanceof TreasuryFrontOfficeGroup;
    }
}

