/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.groups;

import com.google.common.base.Objects;
import java.util.Set;
import org.fenixedu.bennu.core.annotation.GroupOperator;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.domain.groups.PersistentGroup;
import org.fenixedu.bennu.core.groups.CustomGroup;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.treasury.domain.accesscontrol.PersistentTreasuryBackOfficeGroup;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;

@GroupOperator(value="treasuryBackOffice")
public class TreasuryBackOfficeGroup
extends CustomGroup {
    private static final long serialVersionUID = -933441447959188208L;
    private static final TreasuryBackOfficeGroup INSTANCE = new TreasuryBackOfficeGroup();

    private TreasuryBackOfficeGroup() {
    }

    public static TreasuryBackOfficeGroup get() {
        return INSTANCE;
    }

    public String getPresentationName() {
        return BundleUtil.getString((String)Constants.BUNDLE, (String)"label.TreasuryBackOfficeGroup.description", (String[])new String[0]);
    }

    public Set<User> getMembers() {
        return TreasuryAccessControlAPI.getBackOfficeMembers();
    }

    public boolean isMember(User user) {
        return this.getMembers().contains(user);
    }

    public Set<User> getMembers(DateTime when) {
        return this.getMembers();
    }

    public boolean isMember(User user, DateTime when) {
        return this.isMember(user);
    }

    public boolean equals(Object object) {
        return object instanceof TreasuryBackOfficeGroup;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{TreasuryBackOfficeGroup.class});
    }

    public PersistentGroup toPersistentGroup() {
        return PersistentTreasuryBackOfficeGroup.getInstance();
    }
}

