/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto.document.managepayments;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.LocalDate;

public class PaymentReferenceCodeBean
implements IBean {
    private DebitNote debitNote;
    private PaymentCodePool paymentCodePool;
    private List<TupleDataSourceBean> paymentCodePoolDataSource;
    private String referenceCode;
    private LocalDate beginDate;
    private LocalDate endDate;
    private BigDecimal maxAmount;
    private BigDecimal minAmount;
    private BigDecimal paymentAmount;
    private BigDecimal paymentAmountWithInterst;
    private boolean isPoolWithFixedAmount;
    private boolean isPoolVariableTimeWindow;
    private boolean useCustomPaymentAmount;
    private boolean usePaymentAmountWithInterests;
    private DebtAccount debtAccount;
    private List<DebitEntry> selectedDebitEntries;

    public PaymentReferenceCodeBean() {
        this.usePaymentAmountWithInterests = false;
        this.useCustomPaymentAmount = false;
    }

    public PaymentReferenceCodeBean(DebtAccount debtAccount) {
        this.debtAccount = debtAccount;
        List<PaymentCodePool> activePools = debtAccount.getFinantialInstitution().getPaymentCodePoolsSet().stream().filter(x -> Boolean.TRUE.equals(x.getActive())).collect(Collectors.toList());
        this.setPaymentCodePoolDataSource(activePools);
    }

    public void updateAmountOnSelectedDebitEntries() {
        this.paymentAmount = this.selectedDebitEntries.stream().map(e -> e.getOpenAmount()).reduce((a, c) -> a.add((BigDecimal)c)).orElse(BigDecimal.ZERO);
    }

    public List<DebitEntry> getOpenDebitEntries() {
        return DebitEntry.find(this.debtAccount).filter(x -> !x.isAnnulled() && Constants.isPositive(x.getOpenAmount())).sorted(DebitEntry.COMPARE_BY_EXTERNAL_ID).collect(Collectors.toList());
    }

    public PaymentCodePool getPaymentCodePool() {
        return this.paymentCodePool;
    }

    public void setPaymentCodePool(PaymentCodePool value) {
        this.paymentCodePool = value;
    }

    public List<TupleDataSourceBean> getPaymentCodePoolDataSource() {
        return this.paymentCodePoolDataSource;
    }

    public void setPaymentCodePoolDataSource(List<PaymentCodePool> value) {
        this.paymentCodePoolDataSource = value.stream().map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText("[" + x.getEntityReferenceCode() + "] - " + x.getName());
            return tuple;
        }).collect(Collectors.toList());
    }

    public String getReferenceCode() {
        return this.referenceCode;
    }

    public void setReferenceCode(String value) {
        this.referenceCode = value;
    }

    public LocalDate getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(LocalDate value) {
        this.beginDate = value;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate value) {
        this.endDate = value;
    }

    public BigDecimal getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(BigDecimal value) {
        this.maxAmount = value;
    }

    public BigDecimal getMinAmount() {
        return this.minAmount;
    }

    public void setMinAmount(BigDecimal value) {
        this.minAmount = value;
    }

    public DebitNote getDebitNote() {
        return this.debitNote;
    }

    public void setDebitNote(DebitNote debitNote) {
        this.debitNote = debitNote;
    }

    public BigDecimal getPaymentAmount() {
        return this.paymentAmount;
    }

    public void setPaymentAmount(BigDecimal paymentAmount) {
        this.paymentAmount = paymentAmount;
    }

    public boolean isUsePaymentAmountWithInterests() {
        return this.usePaymentAmountWithInterests;
    }

    public void setUsePaymentAmountWithInterests(boolean usePaymentAmountWithInterests) {
        this.usePaymentAmountWithInterests = usePaymentAmountWithInterests;
    }

    public BigDecimal getPaymentAmountWithInterst() {
        return this.paymentAmountWithInterst;
    }

    public void setPaymentAmountWithInterst(BigDecimal paymentAmountWithInterst) {
        this.paymentAmountWithInterst = paymentAmountWithInterst;
    }

    public boolean isPoolWithFixedAmount() {
        return this.isPoolWithFixedAmount;
    }

    public void setPoolWithFixedAmount(boolean poolWithFixedAmount) {
        this.isPoolWithFixedAmount = poolWithFixedAmount;
    }

    public boolean isPoolVariableTimeWindow() {
        return this.isPoolVariableTimeWindow;
    }

    public void setPoolVariableTimeWindow(boolean isPoolVariableTimeWindow) {
        this.isPoolVariableTimeWindow = isPoolVariableTimeWindow;
    }

    public boolean isUseCustomPaymentAmount() {
        return this.useCustomPaymentAmount;
    }

    public void setUseCustomPaymentAmount(boolean useCustomPaymentAmount) {
        this.useCustomPaymentAmount = useCustomPaymentAmount;
    }

    public List<DebitEntry> getSelectedDebitEntries() {
        return this.selectedDebitEntries;
    }

    public void setSelectedDebitEntries(List<DebitEntry> selectedDebitEntries) {
        this.selectedDebitEntries = selectedDebitEntries;
    }
}

