/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;

public class TreasuryExemptionBean
implements IBean,
Serializable {
    private static final long serialVersionUID = 1L;
    private TreasuryEvent treasuryEvent;
    private List<TupleDataSourceBean> treasuryExemptionTypes;
    private List<TupleDataSourceBean> products;
    private List<TupleDataSourceBean> debitEntries;
    private TreasuryExemptionType treasuryExemptionType;
    private DebitEntry debitEntry;
    private BigDecimal valuetoexempt;
    private String reason;

    public TreasuryExemptionBean() {
        this.setTreasuryExemptionTypes(TreasuryExemptionType.findAll().sorted(TreasuryExemptionType.COMPARE_BY_NAME).collect(Collectors.toList()));
    }

    public TreasuryExemptionBean(TreasuryEvent treasuryEvent) {
        this();
        this.treasuryEvent = treasuryEvent;
        this.setDebitEntries(DebitEntry.findActive(treasuryEvent).map(l -> new TupleDataSourceBean(l.getExternalId(), this.debitEntryDescription((DebitEntry)((Object)l)))).sorted(TupleDataSourceBean.COMPARE_BY_TEXT).collect(Collectors.toList()));
    }

    private String debitEntryDescription(DebitEntry debitEntry) {
        if (debitEntry.getFinantialDocument() == null) {
            return debitEntry.getDescription();
        }
        return String.format("%s [%s]", debitEntry.getDescription(), debitEntry.getFinantialDocument().getUiDocumentNumber());
    }

    public List<TupleDataSourceBean> getTreasuryExemptionTypes() {
        return this.treasuryExemptionTypes;
    }

    public TreasuryEvent getTreasuryEvent() {
        return this.treasuryEvent;
    }

    public void setTreasuryEvent(TreasuryEvent treasuryEvent) {
        this.treasuryEvent = treasuryEvent;
    }

    public void setTreasuryExemptionTypes(List<TreasuryExemptionType> treasuryExemptionTypes) {
        this.treasuryExemptionTypes = treasuryExemptionTypes.stream().map(treasuryExemptionType -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setText(treasuryExemptionType.getName().getContent());
            tuple.setId(treasuryExemptionType.getExternalId());
            return tuple;
        }).collect(Collectors.toList());
    }

    public List<TupleDataSourceBean> getProducts() {
        return this.products;
    }

    public void setProducts(List<Product> products) {
        this.products = products.stream().map(product -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setText(product.getName().getContent());
            tuple.setId(product.getExternalId());
            return tuple;
        }).collect(Collectors.toList());
    }

    public TreasuryExemptionType getTreasuryExemptionType() {
        return this.treasuryExemptionType;
    }

    public void setTreasuryExemptionType(TreasuryExemptionType treasuryExemptionType) {
        this.treasuryExemptionType = treasuryExemptionType;
    }

    public List<TupleDataSourceBean> getDebitEntries() {
        return this.debitEntries;
    }

    public void setDebitEntries(List<TupleDataSourceBean> debitEntries) {
        this.debitEntries = debitEntries;
    }

    public BigDecimal getValuetoexempt() {
        return this.valuetoexempt;
    }

    public void setValuetoexempt(BigDecimal valuetoexempt) {
        this.valuetoexempt = valuetoexempt;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public DebitEntry getDebitEntry() {
        return this.debitEntry;
    }

    public void setDebitEntry(DebitEntry debitEntry) {
        this.debitEntry = debitEntry;
    }
}

