/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.tariff.InterestType;

public class FixedTariffInterestRateBean
implements IBean {
    private InterestType interestType;
    private List<TupleDataSourceBean> interestTypeDataSource = new ArrayList<TupleDataSourceBean>();
    private int numberOfDaysAfterDueDate;
    private boolean applyInFirstWorkday;
    private int maximumDaysToApplyPenalty;
    private int maximumMonthsToApplyPenalty;
    private BigDecimal interestFixedAmount;
    private BigDecimal rate;

    public InterestType getInterestType() {
        return this.interestType;
    }

    public void setInterestType(InterestType value) {
        this.interestType = value;
    }

    public List<TupleDataSourceBean> getInterestTypeDataSource() {
        return this.interestTypeDataSource;
    }

    public void setInterestTypeDataSource(List<InterestType> value) {
        this.interestTypeDataSource = value.stream().map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.toString());
            tuple.setText(x.getDescriptionI18N().getContent());
            return tuple;
        }).collect(Collectors.toList());
    }

    public int getNumberOfDaysAfterDueDate() {
        return this.numberOfDaysAfterDueDate;
    }

    public void setNumberOfDaysAfterDueDate(int value) {
        this.numberOfDaysAfterDueDate = value;
    }

    public boolean getApplyInFirstWorkday() {
        return this.applyInFirstWorkday;
    }

    public void setApplyInFirstWorkday(boolean value) {
        this.applyInFirstWorkday = value;
    }

    public int getMaximumDaysToApplyPenalty() {
        return this.maximumDaysToApplyPenalty;
    }

    public void setMaximumDaysToApplyPenalty(int value) {
        this.maximumDaysToApplyPenalty = value;
    }

    public int getMaximumMonthsToApplyPenalty() {
        return this.maximumMonthsToApplyPenalty;
    }

    public void setMaximumMonthsToApplyPenalty(int value) {
        this.maximumMonthsToApplyPenalty = value;
    }

    public BigDecimal getInterestFixedAmount() {
        return this.interestFixedAmount;
    }

    public void setInterestFixedAmount(BigDecimal value) {
        this.interestFixedAmount = value;
    }

    public BigDecimal getRate() {
        return this.rate;
    }

    public void setRate(BigDecimal value) {
        this.rate = value;
    }

    public FixedTariffInterestRateBean() {
        for (InterestType type : InterestType.findAll()) {
            TupleDataSourceBean typeBean = new TupleDataSourceBean();
            typeBean.setId(type.toString());
            typeBean.setText(type.getDescriptionI18N().getContent());
            this.interestTypeDataSource.add(typeBean);
        }
    }

    public FixedTariffInterestRateBean(InterestRate interestRate) {
        this();
        this.setInterestType(interestRate.getInterestType());
        this.setNumberOfDaysAfterDueDate(interestRate.getNumberOfDaysAfterDueDate());
        this.setApplyInFirstWorkday(interestRate.getApplyInFirstWorkday());
        this.setMaximumDaysToApplyPenalty(interestRate.getMaximumDaysToApplyPenalty());
        this.setMaximumMonthsToApplyPenalty(interestRate.getMaximumMonthsToApplyPenalty());
        this.setInterestFixedAmount(interestRate.getInterestFixedAmount());
        this.setRate(interestRate.getRate());
    }
}

