/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.tariff.DueDateCalculationType;
import org.fenixedu.treasury.domain.tariff.FixedTariff;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.dto.FixedTariffInterestRateBean;
import org.joda.time.LocalDate;

public class FixedTariffBean
implements IBean {
    private FinantialInstitution finantialInstitution;
    private Product product;
    private List<TupleDataSourceBean> productDataSource;
    private VatType vatType;
    private List<TupleDataSourceBean> vatTypeDataSource;
    private FinantialEntity finantialEntity;
    private List<TupleDataSourceBean> finantialEntityDataSource;
    private BigDecimal amount;
    private LocalDate beginDate;
    private LocalDate endDate;
    private DueDateCalculationType dueDateCalculationType;
    private List<TupleDataSourceBean> dueDateCalculationTypeDataSource;
    private LocalDate fixedDueDate;
    private int numberOfDaysAfterCreationForDueDate;
    private boolean applyInterests;
    private FixedTariffInterestRateBean interestRate = new FixedTariffInterestRateBean();

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product value) {
        this.product = value;
    }

    public List<TupleDataSourceBean> getProductDataSource() {
        return this.productDataSource;
    }

    public void setProductDataSource(List<Product> value) {
        this.productDataSource = value.stream().map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.getName().getContent());
            return tuple;
        }).collect(Collectors.toList());
    }

    public FixedTariffInterestRateBean getInterestRate() {
        return this.interestRate;
    }

    public void setInterestRate(InterestRate value) {
        this.interestRate = new FixedTariffInterestRateBean(value);
    }

    public FinantialEntity getFinantialEntity() {
        return this.finantialEntity;
    }

    public void setFinantialEntity(FinantialEntity value) {
        this.finantialEntity = value;
    }

    public List<TupleDataSourceBean> getFinantialEntityDataSource() {
        return this.finantialEntityDataSource;
    }

    public void setFinantialEntityDataSource(List<FinantialEntity> value) {
        this.finantialEntityDataSource = value.stream().map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.getName().getContent());
            return tuple;
        }).collect(Collectors.toList());
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    public LocalDate getBeginDate() {
        return this.beginDate;
    }

    public void setBeginDate(LocalDate value) {
        this.beginDate = value;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate value) {
        this.endDate = value;
    }

    public DueDateCalculationType getDueDateCalculationType() {
        return this.dueDateCalculationType;
    }

    public void setDueDateCalculationType(DueDateCalculationType value) {
        this.dueDateCalculationType = value;
    }

    public LocalDate getFixedDueDate() {
        return this.fixedDueDate;
    }

    public void setFixedDueDate(LocalDate value) {
        this.fixedDueDate = value != null ? value : new LocalDate();
    }

    public int getNumberOfDaysAfterCreationForDueDate() {
        return this.numberOfDaysAfterCreationForDueDate;
    }

    public void setNumberOfDaysAfterCreationForDueDate(int value) {
        this.numberOfDaysAfterCreationForDueDate = value;
    }

    public boolean getApplyInterests() {
        return this.applyInterests;
    }

    public void setApplyInterests(boolean value) {
        this.applyInterests = value;
    }

    public List<TupleDataSourceBean> getDueDateCalculationTypeDataSource() {
        return this.dueDateCalculationTypeDataSource;
    }

    public void setDueDateCalculationTypeDataSource(List<DueDateCalculationType> value) {
        this.dueDateCalculationTypeDataSource = value.stream().map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.toString());
            tuple.setText(x.getDescriptionI18N().getContent());
            return tuple;
        }).collect(Collectors.toList());
    }

    public FixedTariffBean() {
        this.setApplyInterests(false);
        this.setDueDateCalculationType(DueDateCalculationType.NO_DUE_DATE);
        ArrayList<DueDateCalculationType> dueDates = new ArrayList<DueDateCalculationType>();
        for (DueDateCalculationType dueDate : DueDateCalculationType.values()) {
            dueDates.add(dueDate);
        }
        this.setDueDateCalculationTypeDataSource(dueDates);
        this.setFixedDueDate(new LocalDate());
    }

    public FixedTariffBean(FixedTariff fixedTariff) {
        this();
        this.setProduct(fixedTariff.getProduct());
        this.setApplyInterests(fixedTariff.getApplyInterests());
        if (fixedTariff.getInterestRate() != null) {
            this.setInterestRate(fixedTariff.getInterestRate());
            this.setApplyInterests(true);
        } else {
            this.setApplyInterests(false);
        }
        this.setFinantialEntity(fixedTariff.getFinantialEntity());
        this.setAmount(fixedTariff.getAmount());
        this.setBeginDate(fixedTariff.getBeginDate().toLocalDate());
        this.setEndDate(fixedTariff.getEndDate().toLocalDate());
        this.setDueDateCalculationType(fixedTariff.getDueDateCalculationType());
        this.setFixedDueDate(fixedTariff.getFixedDueDate());
        this.setNumberOfDaysAfterCreationForDueDate(fixedTariff.getNumberOfDaysAfterCreationForDueDate());
        this.setFinantialEntityDataSource(fixedTariff.getFinantialEntity().getFinantialInstitution().getFinantialEntitiesSet().stream().collect(Collectors.toList()));
        ArrayList<DueDateCalculationType> dueDates = new ArrayList<DueDateCalculationType>();
        for (DueDateCalculationType dueDate : DueDateCalculationType.values()) {
            dueDates.add(dueDate);
        }
        this.setDueDateCalculationTypeDataSource(dueDates);
        this.setFinantialInstitution(fixedTariff.getFinantialEntity().getFinantialInstitution());
    }

    public FinantialInstitution getFinantialInstitution() {
        return this.finantialInstitution;
    }

    public void setFinantialInstitution(FinantialInstitution finantialInstitution) {
        this.finantialInstitution = finantialInstitution;
    }
}

