/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.dto;

import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.bennu.IBean;
import org.fenixedu.bennu.TupleDataSourceBean;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.dto.FixedTariffInterestRateBean;
import org.fenixedu.treasury.util.Constants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;

public class DebitEntryBean
implements IBean {
    private DebitEntry debitEntry;
    private TreasuryEvent treasuryEvent;
    private List<TupleDataSourceBean> treasuryEventDataSource;
    private Vat vat;
    private List<TupleDataSourceBean> vatDataSource;
    private Product product;
    private List<TupleDataSourceBean> productDataSource;
    private DebtAccount debtAccount;
    private List<TupleDataSourceBean> debtAccountDataSource;
    private Currency currency;
    private List<TupleDataSourceBean> currencyDataSource;
    private DebitNote finantialDocument;
    private boolean eventAnnuled;
    private DateTime entryDate;
    private LocalDate dueDate;
    private String description;
    private BigDecimal amount;
    private BigDecimal quantity;
    private boolean applyInterests;
    private FixedTariffInterestRateBean interestRate;
    private boolean academicalActBlockingSuspension;
    boolean blockAcademicActsOnDebt;
    private boolean showLegacyProducts = false;

    public Boolean isAmountValuesEditable() {
        return false;
    }

    public TreasuryEvent getTreasuryEvent() {
        return this.treasuryEvent;
    }

    public void setTreasuryEvent(TreasuryEvent value) {
        this.treasuryEvent = value;
    }

    public List<TupleDataSourceBean> getTreasuryEventDataSource() {
        return this.treasuryEventDataSource;
    }

    public Vat getVat() {
        return this.vat;
    }

    public void setVat(Vat value) {
        this.vat = value;
    }

    public List<TupleDataSourceBean> getVatDataSource() {
        return this.vatDataSource;
    }

    public void setVatDataSource(List<Vat> value) {
        this.vatDataSource = value.stream().map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.toString());
            return tuple;
        }).collect(Collectors.toList());
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product value) {
        this.product = value;
    }

    public List<TupleDataSourceBean> getProductDataSource() {
        return this.productDataSource;
    }

    public void setProductDataSource(List<Product> value) {
        String inactiveDescription = " " + Constants.bundle("label.DebitEntryBean.inactive.description", new String[0]);
        this.productDataSource = value.stream().sorted((x, y) -> x.getName().getContent().compareToIgnoreCase(y.getName().getContent())).map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(String.format("%s", x.getName().getContent().replace("\"", "").replace("'", "")) + (!x.isActive() ? inactiveDescription : ""));
            return tuple;
        }).collect(Collectors.toList());
    }

    public DebtAccount getDebtAccount() {
        return this.debtAccount;
    }

    public void setDebtAccount(DebtAccount value) {
        this.debtAccount = value;
    }

    public List<TupleDataSourceBean> getDebtAccountDataSource() {
        return this.debtAccountDataSource;
    }

    public void setDebtAccountDataSource(List<DebtAccount> value) {
        this.debtAccountDataSource = value.stream().map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.toString());
            return tuple;
        }).collect(Collectors.toList());
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency value) {
        this.currency = value;
    }

    public List<TupleDataSourceBean> getCurrencyDataSource() {
        return this.currencyDataSource;
    }

    public void setCurrencyDataSource(List<Currency> value) {
        this.currencyDataSource = value.stream().map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            tuple.setText(x.toString());
            return tuple;
        }).collect(Collectors.toList());
    }

    public DebitNote getFinantialDocument() {
        return this.finantialDocument;
    }

    public void setFinantialDocument(DebitNote value) {
        this.finantialDocument = value;
    }

    public boolean getEventAnnuled() {
        return this.eventAnnuled;
    }

    public void setEventAnnuled(boolean value) {
        this.eventAnnuled = value;
    }

    public LocalDate getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(LocalDate value) {
        this.dueDate = value;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal value) {
        this.amount = value;
    }

    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal value) {
        this.quantity = value;
    }

    public DebitEntryBean() {
        this.setEntryDate(new DateTime());
        this.setDueDate(new LocalDate());
        this.setQuantity(BigDecimal.ONE);
        this.setAmount(BigDecimal.ZERO);
        this.setInterestRate(new FixedTariffInterestRateBean());
        this.setAcademicalActBlockingSuspension(false);
        this.setBlockAcademicActsOnDebt(false);
    }

    public DebitEntryBean(DebitEntry debitEntry) {
        this();
        this.setDebitEntry(debitEntry);
        this.setTreasuryEvent(debitEntry.getTreasuryEvent());
        this.setVat(debitEntry.getVat());
        this.setProduct(debitEntry.getProduct());
        this.setDebtAccount(debitEntry.getDebtAccount());
        this.setCurrency(debitEntry.getCurrency());
        this.setFinantialDocument((DebitNote)((Object)debitEntry.getFinantialDocument()));
        this.setEventAnnuled(debitEntry.getEventAnnuled());
        this.setDueDate(debitEntry.getDueDate());
        this.setDescription(debitEntry.getDescription());
        this.setEntryDate(debitEntry.getEntryDateTime());
        this.setDueDate(debitEntry.getDueDate());
        this.setDescription(debitEntry.getDescription());
        this.setAmount(debitEntry.getAmount());
        this.setQuantity(debitEntry.getQuantity());
        if (debitEntry.getInterestRate() == null) {
            this.applyInterests = false;
            this.setInterestRate(new FixedTariffInterestRateBean());
        } else {
            this.applyInterests = true;
            this.setInterestRate(new FixedTariffInterestRateBean(debitEntry.getInterestRate()));
        }
        this.setTreasuryEventDataSource(TreasuryEvent.find(debitEntry.getDebtAccount().getCustomer()).collect(Collectors.toList()));
        this.setAcademicalActBlockingSuspension(!debitEntry.isAcademicalActBlockingSuspension());
        this.setBlockAcademicActsOnDebt(debitEntry.isBlockAcademicActsOnDebt());
    }

    public boolean isApplyInterests() {
        return this.applyInterests;
    }

    public void setApplyInterests(boolean applyInterests) {
        this.applyInterests = applyInterests;
    }

    public FixedTariffInterestRateBean getInterestRate() {
        return this.interestRate;
    }

    public void setInterestRate(FixedTariffInterestRateBean interestRate) {
        this.interestRate = interestRate;
    }

    public DateTime getEntryDate() {
        return this.entryDate;
    }

    public void setEntryDate(DateTime entryDate) {
        this.entryDate = entryDate;
    }

    public DebitEntry getDebitEntry() {
        return this.debitEntry;
    }

    public void setDebitEntry(DebitEntry debitEntry) {
        this.debitEntry = debitEntry;
    }

    public boolean isAcademicalActBlockingSuspension() {
        return this.academicalActBlockingSuspension;
    }

    public void setAcademicalActBlockingSuspension(boolean academicalActBlockingSuspension) {
        this.academicalActBlockingSuspension = academicalActBlockingSuspension;
    }

    public boolean isBlockAcademicActsOnDebt() {
        return this.blockAcademicActsOnDebt;
    }

    public void setBlockAcademicActsOnDebt(boolean blockAcademicActsOnDebt) {
        this.blockAcademicActsOnDebt = blockAcademicActsOnDebt;
    }

    public boolean isShowLegacyProducts() {
        return this.showLegacyProducts;
    }

    public void setShowLegacyProducts(boolean showLegacyProducts) {
        this.showLegacyProducts = showLegacyProducts;
    }

    public void setTreasuryEventDataSource(List<TreasuryEvent> treasuryEventDataSource) {
        this.treasuryEventDataSource = treasuryEventDataSource.stream().map(x -> {
            TupleDataSourceBean tuple = new TupleDataSourceBean();
            tuple.setId(x.getExternalId());
            String text = "";
            text = x.getTreasuryEventDate() != null ? text + "[" + x.getTreasuryEventDate().toString("YYYY-MM-dd") + "] " : text + "[YYYY-MM-dd] ";
            text = x.getDescription() != null ? text + x.getDescription().getContent() : text + "---";
            tuple.setText(text);
            return tuple;
        }).collect(Collectors.toList());
    }

    public void refreshProductsDataSource() {
        this.setProductDataSource(this.isShowLegacyProducts() ? Product.findAllLegacy().collect(Collectors.toList()) : Product.findAllActive().collect(Collectors.toList()));
    }
}

