/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.tariff;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate$callable$create;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate$callable$delete;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate$callable$edit;
import org.fenixedu.treasury.domain.tariff.GlobalInterestRate_Base;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class GlobalInterestRate
extends GlobalInterestRate_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected GlobalInterestRate() {
        this.setBennu(Bennu.getInstance());
    }

    protected void init(int year, LocalizedString description, BigDecimal rate, boolean applyPaymentMonth, boolean applyInFirstWorkday) {
        this.setYear(year);
        this.setDescription(description);
        this.setRate(rate);
        this.setApplyPaymentMonth(applyPaymentMonth);
        this.setApplyInFirstWorkday(applyInFirstWorkday);
        this.checkRules();
    }

    private void checkRules() {
        if (GlobalInterestRate.findByYear(this.getYear()).count() > 1L) {
            throw new TreasuryDomainException("error.GlobalInterestRate.year.duplicated", new String[0]);
        }
    }

    public void edit(int n, LocalizedString localizedString, BigDecimal bigDecimal, boolean bl, boolean bl2) {
        Object object = advice$edit.perform((Callable)new GlobalInterestRate$callable$edit(this, n, localizedString, bigDecimal, bl, bl2));
    }

    static /* synthetic */ void advised$edit(GlobalInterestRate this_, int year, LocalizedString description, BigDecimal rate, boolean applyPaymentMonth, boolean applyInFirstWorkday) {
        this_.setYear(year);
        this_.setDescription(description);
        this_.setRate(rate);
        this_.setApplyPaymentMonth(applyPaymentMonth);
        this_.setApplyInFirstWorkday(applyInFirstWorkday);
        this_.checkRules();
    }

    public boolean isApplyPaymentMonth() {
        return super.getApplyPaymentMonth();
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new GlobalInterestRate$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(GlobalInterestRate this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.GlobalInterestRate.cannot.delete", new String[0]);
        }
        this_.setBennu(null);
        this_.deleteDomainObject();
    }

    public static GlobalInterestRate create(int n, LocalizedString localizedString, BigDecimal bigDecimal, boolean bl, boolean bl2) {
        return (GlobalInterestRate)((Object)advice$create.perform((Callable)new GlobalInterestRate$callable$create(n, localizedString, bigDecimal, bl, bl2)));
    }

    static /* synthetic */ GlobalInterestRate advised$create(int year, LocalizedString description, BigDecimal rate, boolean applyPaymentMonth, boolean applyInFirstWorkday) {
        GlobalInterestRate globalInterestRate = new GlobalInterestRate();
        globalInterestRate.init(year, description, rate, applyPaymentMonth, applyInFirstWorkday);
        return globalInterestRate;
    }

    public static Stream<GlobalInterestRate> findAll() {
        return Bennu.getInstance().getGlobalInterestRatesSet().stream();
    }

    public static Stream<GlobalInterestRate> findByYear(int year) {
        return GlobalInterestRate.findAll().filter(i -> year == i.getYear());
    }

    public static Optional<GlobalInterestRate> findUniqueByYear(int year) {
        return GlobalInterestRate.findByYear(year).findFirst();
    }

    public static Stream<GlobalInterestRate> findByDescription(LocalizedString description) {
        return GlobalInterestRate.findAll().filter(i -> description.equals((Object)i.getDescription()));
    }

    public static Stream<GlobalInterestRate> findByRate(BigDecimal rate) {
        return GlobalInterestRate.findAll().filter(i -> rate.equals(i.getRate()));
    }
}

