/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile$CalculatePaymentCodes$callable$run;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile$CalculatePaymentCodes$callable$txDo;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.SibsOutputFile_Base;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.services.payments.sibs.outgoing.SibsOutgoingPaymentFile;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsOutputFile
extends SibsOutputFile_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    public static SibsOutputFile create(FinantialInstitution finantialInstitution, DateTime lastSuccessfulSentDateTime) {
        SibsOutputFile file = new SibsOutputFile();
        try {
            StringBuilder errorsBuilder = new StringBuilder();
            byte[] paymentFileContents = file.createPaymentFile(finantialInstitution, lastSuccessfulSentDateTime, errorsBuilder).getBytes("ASCII");
            file.init(file.outgoingFilename(), file.outgoingFilename(), paymentFileContents);
            file.setFinantialInstitution(finantialInstitution);
            file.setLastSuccessfulExportation(lastSuccessfulSentDateTime);
            file.setErrorLog(errorsBuilder.toString());
        }
        catch (Exception e) {
            StringBuilder builder = new StringBuilder();
            builder.append(e.getLocalizedMessage()).append("\n");
            for (StackTraceElement el : e.getStackTrace()) {
                builder.append(el.toString()).append("\n");
            }
            file.init(file.outgoingFilename(), file.outgoingFilename(), new byte[0]);
            file.setFinantialInstitution(finantialInstitution);
            file.setLastSuccessfulExportation(lastSuccessfulSentDateTime);
            file.setErrorLog(builder.toString());
        }
        return file;
    }

    protected String createPaymentFile(FinantialInstitution finantialInstiution, DateTime lastSuccessfulSentDateTime, StringBuilder errorsBuilder) {
        SibsOutgoingPaymentFile sibsOutgoingPaymentFile = new SibsOutgoingPaymentFile(finantialInstiution.getSibsConfiguration().getSourceInstitutionId(), finantialInstiution.getSibsConfiguration().getDestinationInstitutionId(), finantialInstiution.getSibsConfiguration().getEntityReferenceCode(), lastSuccessfulSentDateTime);
        for (PaymentReferenceCode referenceCode : this.getNotPayedReferenceCodes(finantialInstiution, errorsBuilder)) {
            this.addCalculatedPaymentCodesFromEvent(sibsOutgoingPaymentFile, referenceCode, errorsBuilder);
        }
        this.setPrintedPaymentCodes(sibsOutgoingPaymentFile.getAssociatedPaymentCodes().exportAsString());
        this.invalidateOldPaymentCodes(sibsOutgoingPaymentFile, finantialInstiution, errorsBuilder);
        return sibsOutgoingPaymentFile.render();
    }

    private Set<PaymentReferenceCode> getNotPayedReferenceCodes(FinantialInstitution finantialInstitution, StringBuilder errorsBuilder) {
        HashSet<PaymentReferenceCode> result = new HashSet<PaymentReferenceCode>();
        for (PaymentCodePool pool : finantialInstitution.getPaymentCodePoolsSet()) {
            List<PaymentReferenceCode> paymentCodesToExport = pool.getPaymentCodesToExport(new LocalDate());
            result.addAll(paymentCodesToExport);
        }
        return result;
    }

    private void invalidateOldPaymentCodes(SibsOutgoingPaymentFile sibsOutgoingPaymentFile, FinantialInstitution finantialInstitution, StringBuilder errorsBuilder) {
        HashSet<PaymentReferenceCode> result = new HashSet<PaymentReferenceCode>();
        for (PaymentCodePool pool : finantialInstitution.getPaymentCodePoolsSet()) {
            List<PaymentReferenceCode> paymentCodesToExport = pool.getAnnulledPaymentCodesToExport(new LocalDate());
            result.addAll(paymentCodesToExport);
        }
        for (PaymentReferenceCode oldCode : result) {
            sibsOutgoingPaymentFile.addLine(oldCode.getReferenceCode(), BigDecimal.valueOf(0.01), BigDecimal.valueOf(0.01), new DateTime().minusDays(5).toLocalDate(), new DateTime().minusDays(5).toLocalDate());
        }
    }

    protected void addPaymentCode(SibsOutgoingPaymentFile file, PaymentReferenceCode paymentCode, StringBuilder errorsBuilder) {
        try {
            file.addAssociatedPaymentCode(paymentCode);
            file.addLine(paymentCode.getReferenceCode(), paymentCode.getMinAmount(), paymentCode.getMaxAmount(), paymentCode.getBeginDate(), paymentCode.getEndDate());
        }
        catch (Throwable e) {
            this.appendToErrors(errorsBuilder, paymentCode.getExternalId(), e);
        }
    }

    private void appendToErrors(StringBuilder errorsBuilder, String externalId, Throwable e) {
        errorsBuilder.append("Error in : " + externalId + "-" + e.getLocalizedMessage()).append("\n");
        this.setErrorLog(errorsBuilder.toString());
    }

    protected void addCalculatedPaymentCodesFromEvent(SibsOutgoingPaymentFile file, PaymentReferenceCode referenceCode, StringBuilder errorsBuilder) {
        try {
            CalculatePaymentCodes thread = new CalculatePaymentCodes(referenceCode.getExternalId(), errorsBuilder, file);
            thread.start();
            thread.join();
        }
        catch (Throwable e) {
            this.appendToErrors(errorsBuilder, referenceCode.getExternalId(), e);
        }
    }

    private String outgoingFilename() {
        return String.format("SIBS-%s.txt", new DateTime().toString("dd-MM-yyyy_H_m_s"));
    }

    public boolean isAccessible(User arg0) {
        return true;
    }

    protected void init(FinantialInstitution finantialInstitution, String errorLog, String infoLog, String printedPaymentCodes) {
        this.setFinantialInstitution(finantialInstitution);
        this.setErrorLog(errorLog);
        this.setInfoLog(infoLog);
        this.setPrintedPaymentCodes(printedPaymentCodes);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.SibsOutputFile.finantialInstitution.required", new String[0]);
        }
    }

    public void edit(FinantialInstitution finantialInstitution, String string, String string2, String string3) {
        Object object = advice$edit.perform((Callable)new SibsOutputFile$callable$edit(this, finantialInstitution, string, string2, string3));
    }

    static /* synthetic */ void advised$edit(SibsOutputFile this_, FinantialInstitution finantialInstitution, String errorLog, String infoLog, String printedPaymentCodes) {
        this_.setFinantialInstitution(finantialInstitution);
        this_.setErrorLog(errorLog);
        this_.setInfoLog(infoLog);
        this_.setPrintedPaymentCodes(printedPaymentCodes);
        this_.checkRules();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsOutputFile$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsOutputFile this_) {
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.setFinantialInstitution(null);
        super.delete();
    }

    public static SibsOutputFile create(FinantialInstitution finantialInstitution, String string, String string2, String string3) {
        return (SibsOutputFile)((Object)advice$create.perform((Callable)new SibsOutputFile$callable$create(finantialInstitution, string, string2, string3)));
    }

    static /* synthetic */ SibsOutputFile advised$create(FinantialInstitution finantialInstitution, String errorLog, String infoLog, String printedPaymentCodes) {
        SibsOutputFile sibsOutputFile = new SibsOutputFile();
        sibsOutputFile.init(finantialInstitution, errorLog, infoLog, printedPaymentCodes);
        return sibsOutputFile;
    }

    public static Stream<SibsOutputFile> findAll() {
        HashSet result = new HashSet();
        for (FinantialInstitution finantialInstitution : FinantialInstitution.findAll().collect(Collectors.toList())) {
            result.addAll(finantialInstitution.getSibsOutputFilesSet());
        }
        return result.stream();
    }

    public static Stream<SibsOutputFile> findByFinantialInstitution(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getSibsOutputFilesSet().stream();
    }

    public static Stream<SibsOutputFile> findByErrorLog(String errorLog) {
        return SibsOutputFile.findAll().filter(i -> errorLog.equalsIgnoreCase(i.getErrorLog()));
    }

    public static Stream<SibsOutputFile> findByInfoLog(String infoLog) {
        return SibsOutputFile.findAll().filter(i -> infoLog.equalsIgnoreCase(i.getInfoLog()));
    }

    public static Stream<SibsOutputFile> findByPrintedPaymentCodes(String printedPaymentCodes) {
        return SibsOutputFile.findAll().filter(i -> printedPaymentCodes.equalsIgnoreCase(i.getPrintedPaymentCodes()));
    }

    private class CalculatePaymentCodes
    extends Thread {
        private final String paymentReferenceCodeId;
        private final StringBuilder errorsBuilder;
        private final SibsOutgoingPaymentFile sibsFile;
        public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.READ, true));
        public static final Advice advice$txDo = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

        public CalculatePaymentCodes(String paymentReferenceCodeId, StringBuilder errorsBuilder, SibsOutgoingPaymentFile sibsFile) {
            this.paymentReferenceCodeId = paymentReferenceCodeId;
            this.errorsBuilder = errorsBuilder;
            this.sibsFile = sibsFile;
        }

        @Override
        public void run() {
            Object object = advice$run.perform((Callable)new SibsOutputFile$CalculatePaymentCodes$callable$run(this));
        }

        static /* synthetic */ void advised$run(CalculatePaymentCodes this_) {
            try {
                this_.txDo();
            }
            catch (Throwable e) {
                this_.SibsOutputFile.this.appendToErrors(this_.errorsBuilder, this_.paymentReferenceCodeId, e);
            }
        }

        private void txDo() {
            Object object = advice$txDo.perform((Callable)new SibsOutputFile$CalculatePaymentCodes$callable$txDo(this));
        }

        static /* synthetic */ void advised$txDo(CalculatePaymentCodes this_) {
            PaymentReferenceCode referenceCode = (PaymentReferenceCode)FenixFramework.getDomainObject((String)this_.paymentReferenceCodeId);
            this_.sibsFile.addAssociatedPaymentCode(referenceCode);
            this_.sibsFile.addLine(referenceCode.getReferenceCode(), referenceCode.getMinAmount(), referenceCode.getMaxAmount(), referenceCode.getBeginDate(), referenceCode.getEndDate());
        }
    }
}

