/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsConfiguration$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.SibsConfiguration$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.SibsConfiguration$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.SibsConfiguration_Base;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class SibsConfiguration
extends SibsConfiguration_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected SibsConfiguration() {
        this.setBennu(Bennu.getInstance());
    }

    protected void init(FinantialInstitution finantialInstitution, String entityReferenceCode, String sourceInstitutionId, String destinationInstitutionId) {
        this.setFinantialInstitution(finantialInstitution);
        this.setEntityReferenceCode(entityReferenceCode);
        this.setSourceInstitutionId(sourceInstitutionId);
        this.setDestinationInstitutionId(destinationInstitutionId);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.SibsConfiguration.finantialInstitution.required", new String[0]);
        }
    }

    public void edit(String string, String string2, String string3, String string4, String string5) {
        Object object = advice$edit.perform((Callable)new SibsConfiguration$callable$edit(this, string, string2, string3, string4, string5));
    }

    static /* synthetic */ void advised$edit(SibsConfiguration this_, String entityReferenceCode, String sourceInstitutionId, String destinationInstitutionId, String sibsPaymentsBrokerUrl, String sibsPaymentsBrokerSharedKey) {
        this_.setEntityReferenceCode(entityReferenceCode);
        this_.setSourceInstitutionId(sourceInstitutionId);
        this_.setDestinationInstitutionId(destinationInstitutionId);
        this_.setSibsPaymentsBrokerUrl(sibsPaymentsBrokerUrl);
        this_.setSibsPaymentsBrokerSharedKey(sibsPaymentsBrokerSharedKey);
        this_.checkRules();
    }

    public boolean isPaymentsBrokerActive() {
        return !Strings.isNullOrEmpty((String)this.getSibsPaymentsBrokerUrl()) && !Strings.isNullOrEmpty((String)this.getSibsPaymentsBrokerSharedKey());
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new SibsConfiguration$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(SibsConfiguration this_) {
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        this_.setBennu(null);
        this_.setFinantialInstitution(null);
        this_.deleteDomainObject();
    }

    public static SibsConfiguration create(FinantialInstitution finantialInstitution, String string, String string2, String string3) {
        return (SibsConfiguration)((Object)advice$create.perform((Callable)new SibsConfiguration$callable$create(finantialInstitution, string, string2, string3)));
    }

    static /* synthetic */ SibsConfiguration advised$create(FinantialInstitution finantialInstitution, String entityReferenceCode, String sourceInstitutionId, String destinationInstitutionId) {
        SibsConfiguration sibsConfiguration = new SibsConfiguration();
        sibsConfiguration.init(finantialInstitution, entityReferenceCode, sourceInstitutionId, destinationInstitutionId);
        return sibsConfiguration;
    }

    public boolean isValid() {
        return !Strings.isNullOrEmpty((String)this.getDestinationInstitutionId()) && !Strings.isNullOrEmpty((String)this.getSourceInstitutionId()) && !Strings.isNullOrEmpty((String)this.getEntityReferenceCode());
    }
}

