/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.paymentcodes;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.FinantialDocumentPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.MultipleEntriesPaymentCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentCodeTarget;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$anullPaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$bruteForceSetReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$create;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$createPaymentTargetTo;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$createPaymentTargetTo$1;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$delete;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$edit;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$processPayment;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode$callable$setState;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode_Base;
import org.fenixedu.treasury.domain.paymentcodes.SibsReportFile;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaymentReferenceCode
extends PaymentReferenceCode_Base {
    private static final int LENGTH_REFERENCE_CODE = 9;
    private static final BigDecimal SIBS_IGNORE_MAX_AMOUNT;
    public static final String TREASURY_OPERATION_LOG_TYPE = "TREASURY_OPERATION_LOG_TYPE";
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;
    public static final Advice advice$bruteForceSetReferenceCode;
    public static final Advice advice$setState;
    public static final Advice advice$processPayment;
    public static final Advice advice$createPaymentTargetTo;
    public static final Advice advice$createPaymentTargetTo$1;
    public static final Advice advice$anullPaymentReferenceCode;

    protected void init(String referenceCode, LocalDate beginDate, LocalDate endDate, PaymentReferenceCodeStateType state, PaymentCodePool pool, BigDecimal minAmount, BigDecimal maxAmount) {
        this.setReferenceCode(Strings.padStart((String)referenceCode, (int)9, (char)'0'));
        this.setBeginDate(beginDate);
        this.setEndDate(endDate);
        this.setState(state);
        this.setPaymentCodePool(pool);
        this.setMinAmount(minAmount);
        this.setMaxAmount(maxAmount);
        this.checkRules();
    }

    public Interval getValidInterval() {
        return new Interval((ReadableInstant)this.getBeginDate().toDateTimeAtStartOfDay(), (ReadableInstant)this.getEndDate().plusDays(1).toDateTimeAtStartOfDay().minusSeconds(1));
    }

    private void checkRules() {
        if (this.getMinAmount() == null) {
            this.setMinAmount(BigDecimal.ZERO);
        }
        if (this.getMaxAmount() == null) {
            this.setMaxAmount(BigDecimal.ZERO);
        }
        if (PaymentReferenceCode.findByReferenceCode(this.getPaymentCodePool().getEntityReferenceCode(), this.getReferenceCode(), this.getPaymentCodePool().getFinantialInstitution()).count() > 1L) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.referenceCode.duplicated", new String[0]);
        }
    }

    public void edit(String string, LocalDate localDate, LocalDate localDate2, PaymentReferenceCodeStateType paymentReferenceCodeStateType) {
        Object object = advice$edit.perform((Callable)new PaymentReferenceCode$callable$edit(this, string, localDate, localDate2, paymentReferenceCodeStateType));
    }

    static /* synthetic */ void advised$edit(PaymentReferenceCode this_, String referenceCode, LocalDate beginDate, LocalDate endDate, PaymentReferenceCodeStateType state) {
        this_.setReferenceCode(referenceCode);
        this_.setBeginDate(beginDate);
        this_.setEndDate(endDate);
        this_.setState(state);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getReportedInFilesSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentReferenceCode$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentReferenceCode this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.cannot.delete", new String[0]);
        }
        this_.setPaymentCodePool(null);
        this_.setTargetPayment(null);
        this_.deleteDomainObject();
    }

    public static PaymentReferenceCode create(String string, LocalDate localDate, LocalDate localDate2, PaymentReferenceCodeStateType paymentReferenceCodeStateType, PaymentCodePool paymentCodePool, BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return (PaymentReferenceCode)((Object)advice$create.perform((Callable)new PaymentReferenceCode$callable$create(string, localDate, localDate2, paymentReferenceCodeStateType, paymentCodePool, bigDecimal, bigDecimal2)));
    }

    static /* synthetic */ PaymentReferenceCode advised$create(String referenceCode, LocalDate beginDate, LocalDate endDate, PaymentReferenceCodeStateType state, PaymentCodePool pool, BigDecimal minAmount, BigDecimal maxAmount) {
        PaymentReferenceCode paymentReferenceCode = new PaymentReferenceCode();
        paymentReferenceCode.init(referenceCode, beginDate, endDate, state, pool, minAmount, maxAmount);
        return paymentReferenceCode;
    }

    public static Stream<PaymentReferenceCode> findAll() {
        HashSet result = new HashSet();
        for (PaymentCodePool pool : PaymentCodePool.findAll().collect(Collectors.toList())) {
            result.addAll(pool.getPaymentReferenceCodesSet());
        }
        return result.stream();
    }

    private static Stream<PaymentReferenceCode> findByReferenceCode(String entityReferenceCode, String referenceCode, FinantialInstitution finantialInstitution) {
        return PaymentReferenceCode.findByReferenceCode(referenceCode, finantialInstitution).filter(x -> x.getPaymentCodePool().getEntityReferenceCode().equals(entityReferenceCode));
    }

    private static Stream<PaymentReferenceCode> find(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getPaymentCodePoolsSet().stream().flatMap(i -> i.getPaymentReferenceCodesSet().stream());
    }

    public static Stream<PaymentReferenceCode> findByReferenceCode(String referenceCode, FinantialInstitution finantialInstitution) {
        return PaymentReferenceCode.find(finantialInstitution).filter(i -> referenceCode.equalsIgnoreCase(i.getReferenceCode()));
    }

    public static Stream<PaymentReferenceCode> findByBeginDate(LocalDate beginDate, FinantialInstitution finantialInstitution) {
        return PaymentReferenceCode.find(finantialInstitution).filter(i -> beginDate.equals((Object)i.getBeginDate()));
    }

    public static Stream<PaymentReferenceCode> findByEndDate(LocalDate endDate, FinantialInstitution finantialInstitution) {
        return PaymentReferenceCode.find(finantialInstitution).filter(i -> endDate.equals((Object)i.getEndDate()));
    }

    public static Stream<PaymentReferenceCode> findByState(PaymentReferenceCodeStateType state, FinantialInstitution finantialInstitution) {
        return PaymentReferenceCode.find(finantialInstitution).filter(i -> state.equals((Object)i.getState()));
    }

    public String getFormattedCode() {
        StringBuilder result = new StringBuilder();
        int i = 1;
        for (char character : this.getReferenceCode().toCharArray()) {
            result.append(character);
            if (i % 3 == 0) {
                result.append(" ");
            }
            ++i;
        }
        return result.charAt(result.length() - 1) == ' ' ? result.deleteCharAt(result.length() - 1).toString() : result.toString();
    }

    public void setReferenceCode(String code) {
        super.setReferenceCode(code);
    }

    public void bruteForceSetReferenceCode(String string) {
        Object object = advice$bruteForceSetReferenceCode.perform((Callable)new PaymentReferenceCode$callable$bruteForceSetReferenceCode(this, string));
    }

    static /* synthetic */ void advised$bruteForceSetReferenceCode(PaymentReferenceCode this_, String code) {
        super.setReferenceCode(code);
    }

    public void setState(PaymentReferenceCodeStateType paymentReferenceCodeStateType) {
        Object object = advice$setState.perform((Callable)new PaymentReferenceCode$callable$setState(this, paymentReferenceCodeStateType));
    }

    static /* synthetic */ void advised$setState(PaymentReferenceCode this_, PaymentReferenceCodeStateType state) {
        super.setState(state);
    }

    public boolean isNew() {
        return this.getState() == PaymentReferenceCodeStateType.UNUSED;
    }

    protected void reuseCode() {
        this.setState(PaymentReferenceCodeStateType.UNUSED);
    }

    public boolean isUsed() {
        return this.getState() == PaymentReferenceCodeStateType.USED;
    }

    public boolean isAnnulled() {
        return this.getState() == PaymentReferenceCodeStateType.ANNULLED;
    }

    public boolean isProcessed() {
        return this.getState() == PaymentReferenceCodeStateType.PROCESSED;
    }

    public void anull() {
        this.setState(PaymentReferenceCodeStateType.ANNULLED);
    }

    public boolean isFixedAmount() {
        return this.getPaymentCodePool().getIsFixedAmount();
    }

    public boolean isAvailableForReuse() {
        return !this.isNew();
    }

    public void update(LocalDate startDate, LocalDate endDate, BigDecimal minAmount, BigDecimal maxAmount) {
        super.setBeginDate(startDate);
        super.setEndDate(endDate);
        super.setMinAmount(minAmount);
        super.setMaxAmount(maxAmount != null ? maxAmount : SIBS_IGNORE_MAX_AMOUNT);
        this.checkRules();
    }

    public SettlementNote processPayment(User user, BigDecimal bigDecimal, DateTime dateTime, String string, String string2, DateTime dateTime2, SibsReportFile sibsReportFile) {
        return (SettlementNote)((Object)advice$processPayment.perform((Callable)new PaymentReferenceCode$callable$processPayment(this, user, bigDecimal, dateTime, string, string2, dateTime2, sibsReportFile)));
    }

    static /* synthetic */ SettlementNote advised$processPayment(PaymentReferenceCode this_, User responsibleUser, BigDecimal amountToPay, DateTime whenRegistered, String sibsTransactionId, String comments, DateTime whenProcessedBySibs, SibsReportFile sibsReportFile) {
        if (!this_.isNew() && SibsTransactionDetail.isReferenceProcessingDuplicate(this_.getReferenceCode(), this_.getPaymentCodePool().getEntityReferenceCode(), whenRegistered)) {
            return null;
        }
        SettlementNote note = this_.getTargetPayment().processPayment(responsibleUser, amountToPay, whenRegistered, sibsTransactionId, comments);
        DebtAccount referenceDebtAccount = this_.getTargetPayment().getDebtAccount();
        String debtAccountId = referenceDebtAccount.getExternalId();
        String customerId = referenceDebtAccount.getCustomer().getExternalId();
        String businessIdentification = referenceDebtAccount.getCustomer().getBusinessIdentification();
        String fiscalNumber = this_.valueOrEmpty(referenceDebtAccount.getCustomer().getFiscalCountry()) + ":" + this_.valueOrEmpty(referenceDebtAccount.getCustomer().getFiscalNumber());
        String customerName = referenceDebtAccount.getCustomer().getName();
        String settlementDocumentNumber = note.getUiDocumentNumber();
        SibsTransactionDetail.create(sibsReportFile, comments, whenProcessedBySibs, whenRegistered, amountToPay, this_.getPaymentCodePool().getEntityReferenceCode(), this_.getReferenceCode(), sibsTransactionId, debtAccountId, customerId, businessIdentification, fiscalNumber, customerName, settlementDocumentNumber);
        return note;
    }

    public String getDescription() {
        return this.getPaymentCodePool().getEntityReferenceCode() + " " + this.getReferenceCode();
    }

    public static PaymentReferenceCode readByCode(String code, FinantialInstitution finantialInstitution) {
        PaymentCodePool pool;
        if (StringUtils.isEmpty((String)code)) {
            return null;
        }
        PaymentReferenceCode paymentReferenceCode = null;
        Iterator iterator = finantialInstitution.getPaymentCodePoolsSet().iterator();
        while (iterator.hasNext() && (paymentReferenceCode = (PaymentReferenceCode)(pool = (PaymentCodePool)((Object)iterator.next())).getPaymentReferenceCodesSet().stream().filter(y -> y.getReferenceCode().equals(code)).findFirst().orElse(null)) == null) {
        }
        return paymentReferenceCode;
    }

    public String getReferenceCodeWithoutCheckDigits() {
        if (Boolean.TRUE.equals(this.getPaymentCodePool().getUseCheckDigit())) {
            if (this.getReferenceCode().length() >= 2) {
                return this.getReferenceCode().substring(0, this.getReferenceCode().length() - 2);
            }
            return this.getReferenceCode();
        }
        throw new TreasuryDomainException("error.PaymentReferenceCode.not.from.pool.with.checkdigit", new String[0]);
    }

    public SibsReportFile getReportOnDate(DateTime transactionWhenRegistered) {
        return this.getReportedInFilesSet().stream().filter(x -> x.getWhenProcessedBySibs().equals((Object)transactionWhenRegistered)).findFirst().orElse(null);
    }

    public void createPaymentTargetTo(FinantialDocument finantialDocument) {
        Object object = advice$createPaymentTargetTo.perform((Callable)new PaymentReferenceCode$callable$createPaymentTargetTo(this, finantialDocument));
    }

    static /* synthetic */ void advised$createPaymentTargetTo(PaymentReferenceCode this_, FinantialDocument finantialDocument) {
        if (this_.getTargetPayment() != null && Boolean.TRUE.equals(this_.getTargetPayment().getValid())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.payment.target.already.exists", new String[0]);
        }
        FinantialDocumentPaymentCode targetToFinantialDocument = FinantialDocumentPaymentCode.create(finantialDocument, this_, true);
        this_.setTargetPayment((PaymentCodeTarget)((Object)targetToFinantialDocument));
        this_.setState(PaymentReferenceCodeStateType.USED);
        this_.setPayableAmount(finantialDocument.getOpenAmount());
        this_.checkRules();
    }

    public void createPaymentTargetTo(Set<DebitEntry> set, BigDecimal bigDecimal) {
        Object object = advice$createPaymentTargetTo$1.perform((Callable)new PaymentReferenceCode$callable$createPaymentTargetTo$1(this, set, bigDecimal));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ void advised$createPaymentTargetTo(PaymentReferenceCode this_, Set debitNoteEntries, BigDecimal payableAmount) {
        if (this_.getTargetPayment() != null && Boolean.TRUE.equals(this_.getTargetPayment().getValid())) {
            throw new TreasuryDomainException("error.PaymentReferenceCode.payment.target.already.exists", new String[0]);
        }
        MultipleEntriesPaymentCode target = MultipleEntriesPaymentCode.create(debitNoteEntries, this_, true);
        this_.setTargetPayment((PaymentCodeTarget)((Object)target));
        this_.setState(PaymentReferenceCodeStateType.USED);
        this_.setPayableAmount(payableAmount);
        this_.checkRules();
    }

    public void anullPaymentReferenceCode() {
        Object object = advice$anullPaymentReferenceCode.perform((Callable)new PaymentReferenceCode$callable$anullPaymentReferenceCode(this));
    }

    static /* synthetic */ void advised$anullPaymentReferenceCode(PaymentReferenceCode this_) {
        if (!this_.getState().equals((Object)PaymentReferenceCodeStateType.ANNULLED)) {
            this_.setState(PaymentReferenceCodeStateType.ANNULLED);
        }
        this_.checkRules();
    }

    private String valueOrEmpty(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return "";
        }
        return value;
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$bruteForceSetReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$setState = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$processPayment = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createPaymentTargetTo = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createPaymentTargetTo$1 = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$anullPaymentReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        SIBS_IGNORE_MAX_AMOUNT = BigDecimal.ZERO;
    }
}

