/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.integration;

import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPImportOperation$callable$create;
import org.fenixedu.treasury.domain.integration.ERPImportOperation$callable$delete;
import org.fenixedu.treasury.domain.integration.ERPImportOperation_Base;
import org.fenixedu.treasury.domain.integration.IntegrationOperation;
import org.fenixedu.treasury.domain.integration.OperationFile;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ERPImportOperation
extends ERPImportOperation_Base {
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected ERPImportOperation() {
    }

    protected void init(OperationFile file, FinantialInstitution finantialInstitution, String erpOperationId, DateTime executionDate, boolean processed, boolean success, boolean corrected) {
        this.setFile(file);
        this.setFinantialInstitution(finantialInstitution);
        this.setErpOperationId(erpOperationId);
        this.setExecutionDate(executionDate);
        this.setProcessed(processed);
        this.setSuccess(success);
        this.setCorrected(corrected);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFile() == null) {
            throw new TreasuryDomainException("error.ERPImportOperation.file.required", new String[0]);
        }
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.ERPImportOperation.finantialInstitution.required", new String[0]);
        }
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new ERPImportOperation$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(ERPImportOperation this_) {
        TreasuryDomainException.throwWhenDeleteBlocked(this_.getDeletionBlockers());
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.ERPImportOperation.cannot.delete", new String[0]);
        }
        this_.setFinantialInstitution(null);
        for (FinantialDocument document : this_.getFinantialDocumentsSet()) {
            this_.removeFinantialDocuments(document);
        }
        super.delete();
    }

    public static ERPImportOperation create(String string, byte[] byArray, FinantialInstitution finantialInstitution, String string2, DateTime dateTime, boolean bl, boolean bl2, boolean bl3) {
        return (ERPImportOperation)((Object)advice$create.perform((Callable)new ERPImportOperation$callable$create(string, byArray, finantialInstitution, string2, dateTime, bl, bl2, bl3)));
    }

    static /* synthetic */ ERPImportOperation advised$create(String filename, byte[] bytes, FinantialInstitution finantialInstitution, String erpOperationId, DateTime executionDate, boolean processed, boolean success, boolean corrected) {
        ERPImportOperation eRPImportOperation = new ERPImportOperation();
        OperationFile file = OperationFile.create(filename, bytes, (IntegrationOperation)((Object)eRPImportOperation));
        eRPImportOperation.init(file, finantialInstitution, erpOperationId, executionDate, processed, success, corrected);
        return eRPImportOperation;
    }

    public static Stream<ERPImportOperation> findAll() {
        HashSet results = new HashSet();
        for (FinantialInstitution fi : Bennu.getInstance().getFinantialInstitutionsSet()) {
            results.addAll(fi.getIntegrationOperationsSet().stream().filter(x -> x instanceof ERPImportOperation).map(ERPImportOperation.class::cast).collect(Collectors.toList()));
        }
        return results.stream();
    }

    public static Stream<ERPImportOperation> findByFile(OperationFile file) {
        HashSet result = Sets.newHashSet();
        IntegrationOperation operation = file.getIntegrationOperation();
        if (operation != null && operation instanceof ERPImportOperation) {
            result.add((ERPImportOperation)((Object)operation));
        }
        return result.stream();
    }

    public static Stream<ERPImportOperation> findByFinantialInstitution(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getIntegrationOperationsSet().stream().filter(x -> x instanceof ERPImportOperation).map(ERPImportOperation.class::cast);
    }

    public static Stream<ERPImportOperation> find(FinantialDocument finantialDocument) {
        return finantialDocument.getErpImportOperationsSet().stream();
    }

    public static Stream<ERPImportOperation> findByExecutionDate(DateTime executionDate) {
        return ERPImportOperation.findAll().filter(i -> executionDate.equals((Object)i.getExecutionDate()));
    }

    public static Stream<ERPImportOperation> findByProcessed(boolean processed) {
        return ERPImportOperation.findAll().filter(i -> processed == i.getProcessed());
    }

    public static Stream<ERPImportOperation> findBySuccess(boolean success) {
        return ERPImportOperation.findAll().filter(i -> success == i.getSuccess());
    }

    public static Stream<ERPImportOperation> findByCorrected(boolean corrected) {
        return ERPImportOperation.findAll().filter(i -> corrected == i.getCorrected());
    }

    public static Stream<ERPImportOperation> findByErrorLog(String errorLog) {
        return ERPImportOperation.findAll().filter(i -> errorLog.equalsIgnoreCase(i.getErrorLog()));
    }
}

