/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.forwardpayments;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration$callable$create;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration$callable$edit;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration$callable$saveVirtualTPACertificate;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfigurationFile;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentConfiguration_Base;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentImplementation;
import org.fenixedu.treasury.dto.forwardpayments.ForwardPaymentConfigurationBean;
import org.fenixedu.treasury.ui.document.forwardpayments.IForwardPaymentController;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ForwardPaymentConfiguration
extends ForwardPaymentConfiguration_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$saveVirtualTPACertificate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    private ForwardPaymentConfiguration() {
        this.setBennu(Bennu.getInstance());
    }

    private ForwardPaymentConfiguration(FinantialInstitution finantialInstitution, ForwardPaymentConfigurationBean bean) {
        this();
        this.setFinantialInstitution(finantialInstitution);
        this.setActive(bean.isActive());
        this.setName(bean.getName());
        this.setPaymentURL(bean.getPaymentURL());
        this.setReturnURL(bean.getReturnURL());
        this.setVirtualTPAMOXXURL(bean.getVirtualTPAMOXXURL());
        this.setVirtualTPAMerchantId(bean.getVirtualTPAMerchantId());
        this.setVirtualTPAId(bean.getVirtualTPAId());
        this.setVirtualTPAKeyStoreName(bean.getVirtualTPAKeyStoreName());
        this.setVirtualTPACertificateAlias(bean.getVirtualTPACertificateAlias());
        this.setVirtualTPACertificatePassword(bean.getVirtualTPACertificatePassword());
        this.setImplementation(bean.getImplementation());
        this.setPaylineMerchantId(bean.getPaylineMerchantId());
        this.setPaylineMerchantAccessKey(bean.getPaylineMerchantAccessKey());
        this.setPaylineContractNumber(bean.getPaylineContractNumber());
        this.setSeries(bean.getSeries());
        this.setPaymentMethod(bean.getPaymentMethod());
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.ForwardPaymentConfiguration.finantialInstitution.required", new String[0]);
        }
        if (this.getFinantialInstitution().getForwardPaymentConfigurationsSet().size() > 1) {
            throw new TreasuryDomainException("error.ForwardPaymentConfiguration.finantialInstitution.only.one.allowed", new String[0]);
        }
    }

    public void edit(ForwardPaymentConfigurationBean forwardPaymentConfigurationBean) {
        Object object = advice$edit.perform((Callable)new ForwardPaymentConfiguration$callable$edit(this, forwardPaymentConfigurationBean));
    }

    static /* synthetic */ void advised$edit(ForwardPaymentConfiguration this_, ForwardPaymentConfigurationBean bean) {
        this_.setActive(bean.isActive());
        this_.setName(bean.getName());
        this_.setPaymentURL(bean.getPaymentURL());
        this_.setReturnURL(bean.getReturnURL());
        this_.setVirtualTPAMOXXURL(bean.getVirtualTPAMOXXURL());
        this_.setVirtualTPAMerchantId(bean.getVirtualTPAMerchantId());
        this_.setVirtualTPAId(bean.getVirtualTPAId());
        this_.setVirtualTPAKeyStoreName(bean.getVirtualTPAKeyStoreName());
        this_.setVirtualTPACertificateAlias(bean.getVirtualTPACertificateAlias());
        this_.setVirtualTPACertificatePassword(bean.getVirtualTPACertificatePassword());
        this_.setImplementation(bean.getImplementation());
        this_.setPaylineMerchantId(bean.getPaylineMerchantId());
        this_.setPaylineMerchantAccessKey(bean.getPaylineMerchantAccessKey());
        this_.setPaylineContractNumber(bean.getPaylineContractNumber());
        this_.setSeries(bean.getSeries());
        this_.setPaymentMethod(bean.getPaymentMethod());
        this_.checkRules();
    }

    public void saveVirtualTPACertificate(String string, byte[] byArray) {
        Object object = advice$saveVirtualTPACertificate.perform((Callable)new ForwardPaymentConfiguration$callable$saveVirtualTPACertificate(this, string, byArray));
    }

    static /* synthetic */ void advised$saveVirtualTPACertificate(ForwardPaymentConfiguration this_, String filename, byte[] contents) {
        if (this_.getVirtualTPACertificate() != null) {
            ForwardPaymentConfigurationFile virtualTPACertificate = this_.getVirtualTPACertificate();
            this_.setVirtualTPACertificate(null);
            virtualTPACertificate.delete();
        }
        this_.setVirtualTPACertificate(ForwardPaymentConfigurationFile.create(filename, contents));
    }

    public boolean isActive() {
        return this.getActive();
    }

    public String formattedAmount(ForwardPayment forwardPayment) {
        return this.implementation().getFormattedAmount(forwardPayment);
    }

    public IForwardPaymentController getForwardPaymentController(ForwardPayment forwardPayment) {
        return this.implementation().getForwardPaymentController(forwardPayment);
    }

    public IForwardPaymentImplementation implementation() {
        try {
            return (IForwardPaymentImplementation)Class.forName(this.getImplementation()).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static ForwardPaymentConfiguration create(FinantialInstitution finantialInstitution, ForwardPaymentConfigurationBean forwardPaymentConfigurationBean) {
        return (ForwardPaymentConfiguration)((Object)advice$create.perform((Callable)new ForwardPaymentConfiguration$callable$create(finantialInstitution, forwardPaymentConfigurationBean)));
    }

    static /* synthetic */ ForwardPaymentConfiguration advised$create(FinantialInstitution finantialInstitution, ForwardPaymentConfigurationBean bean) {
        return new ForwardPaymentConfiguration(finantialInstitution, bean);
    }

    public static Optional<ForwardPaymentConfiguration> find(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getForwardPaymentConfigurationsSet().stream().findFirst();
    }

    public static boolean isActive(FinantialInstitution finantialInstitution) {
        if (!ForwardPaymentConfiguration.find(finantialInstitution).isPresent()) {
            return false;
        }
        return ForwardPaymentConfiguration.find(finantialInstitution).get().isActive();
    }
}

