/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document.reimbursement;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStateLog$callable$create;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStateLog_Base;
import org.fenixedu.treasury.domain.document.reimbursement.ReimbursementProcessStatusType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class ReimbursementProcessStateLog
extends ReimbursementProcessStateLog_Base {
    public static final Comparator<ReimbursementProcessStateLog> COMPARE_BY_VERSIONING_DATE;
    public static final Advice advice$create;

    public ReimbursementProcessStateLog() {
        this.setBennu(Bennu.getInstance());
    }

    protected ReimbursementProcessStateLog(SettlementNote settlementNote, ReimbursementProcessStatusType reimbursementProcessStatusType, String statusId, DateTime statusDate, String remarks) {
        this();
        this.setSettlementNote(settlementNote);
        this.setReimbursementProcessStatusType(reimbursementProcessStatusType);
        this.setStatusId(statusId);
        this.setStatusDate(statusDate);
        this.setRemarks(remarks);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getBennu() == null) {
            throw new TreasuryDomainException("error.ReimbursementProcessStateLog.bennu.required", new String[0]);
        }
        if (this.getReimbursementProcessStatusType() == null) {
            throw new TreasuryDomainException("error.ReimbursementProcessStateLog.reimbursementProcessStatusType.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getStatusId())) {
            throw new TreasuryDomainException("error.ReimbursementProcessStateLog.statusId.required", new String[0]);
        }
        if (this.getStatusDate() == null) {
            throw new TreasuryDomainException("error.ReimbursementProcessStateLog.statusDate.required", new String[0]);
        }
    }

    public static Stream<ReimbursementProcessStateLog> findAll() {
        return Bennu.getInstance().getReimbursementProcessStateLogsSet().stream();
    }

    public static Stream<ReimbursementProcessStateLog> find(SettlementNote settlementNote) {
        return settlementNote.getReimbursementProcessStateLogsSet().stream();
    }

    public static ReimbursementProcessStateLog create(SettlementNote settlementNote, ReimbursementProcessStatusType reimbursementProcessStatusType, String string, DateTime dateTime, String string2) {
        return (ReimbursementProcessStateLog)((Object)advice$create.perform((Callable)new ReimbursementProcessStateLog$callable$create(settlementNote, reimbursementProcessStatusType, string, dateTime, string2)));
    }

    static /* synthetic */ ReimbursementProcessStateLog advised$create(SettlementNote settlementNote, ReimbursementProcessStatusType reimbursementProcessStatusType, String statusId, DateTime statusDate, String remarks) {
        return new ReimbursementProcessStateLog(settlementNote, reimbursementProcessStatusType, statusId, statusDate, remarks);
    }

    static {
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_VERSIONING_DATE = new Comparator<ReimbursementProcessStateLog>(){

            @Override
            public int compare(ReimbursementProcessStateLog o1, ReimbursementProcessStateLog o2) {
                int c = o1.getVersioningCreationDate().compareTo((ReadableInstant)o2.getVersioningCreationDate());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

