/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Series$callable$create;
import org.fenixedu.treasury.domain.document.Series$callable$createDebitNoteForPendingEntries;
import org.fenixedu.treasury.domain.document.Series$callable$createDebitNoteForPendingEntry;
import org.fenixedu.treasury.domain.document.Series$callable$delete;
import org.fenixedu.treasury.domain.document.Series$callable$edit;
import org.fenixedu.treasury.domain.document.Series_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class Series
extends Series_Base {
    private static final Comparator<Series> COMPARATOR_BY_CODE;
    public static final Comparator<Series> COMPARATOR_BY_DEFAULT;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;
    public static final Advice advice$createDebitNoteForPendingEntries;
    public static final Advice advice$createDebitNoteForPendingEntry;

    protected Series() {
        this.setBennu(Bennu.getInstance());
    }

    protected Series(FinantialInstitution finantialInstitution, String code, LocalizedString name, boolean externSeries, boolean certificated, boolean legacy, boolean defaultSeries, boolean selectable) {
        this();
        this.setActive(true);
        this.setFinantialInstitution(finantialInstitution);
        this.setCode(code);
        this.setName(name);
        this.setExternSeries(externSeries);
        this.setCertificated(certificated);
        this.setLegacy(legacy);
        this.setDefaultSeries(defaultSeries);
        this.setSelectable(selectable);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.Series.finantialInstitution.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.Series.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.Series.name.required", new String[0]);
        }
        Series.findByCode(this.getFinantialInstitution(), this.getCode());
        this.getName().getLocales().stream().forEach(l -> Series.findByName(this.getFinantialInstitution(), this.getName().getContent(l)));
        FinantialDocumentType.findAll().forEach(x -> {
            if (!this.getDocumentNumberSeriesSet().stream().anyMatch(series -> series.getFinantialDocumentType().equals(x))) {
                this.addDocumentNumberSeries(new DocumentNumberSeries((FinantialDocumentType)((Object)x), this));
            }
        });
        if (Series.findDefault(this.getFinantialInstitution()).count() > 1L) {
            throw new TreasuryDomainException("error.Series.default.not.unique", new String[0]);
        }
    }

    public void edit(String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        Object object = advice$edit.perform((Callable)new Series$callable$edit(this, string, localizedString, bl, bl2, bl3, bl4, bl5));
    }

    static /* synthetic */ void advised$edit(Series this_, String code, LocalizedString name, boolean externSeries, boolean certificated, boolean legacy, boolean active, boolean selectable) {
        this_.setName(name);
        this_.setActive(active);
        if (!code.equalsIgnoreCase(this_.getCode())) {
            if (this_.isSeriesUsedForAnyDocument()) {
                throw new TreasuryDomainException("error.Series.invalid.series.type.in.used.series", new String[0]);
            }
            this_.setCode(code);
        }
        if (externSeries != this_.getExternSeries()) {
            if (this_.isSeriesUsedForAnyDocument()) {
                throw new TreasuryDomainException("error.Series.invalid.series.type.in.used.series", new String[0]);
            }
            this_.setExternSeries(externSeries);
        }
        if (certificated != this_.getCertificated()) {
            if (this_.isSeriesUsedForAnyDocument()) {
                throw new TreasuryDomainException("error.Series.invalid.series.type.in.used.series", new String[0]);
            }
            this_.setCertificated(certificated);
        }
        if (legacy != this_.getLegacy()) {
            if (this_.isSeriesUsedForAnyDocument()) {
                throw new TreasuryDomainException("error.Series.invalid.series.type.in.used.series", new String[0]);
            }
            this_.setLegacy(legacy);
        }
        this_.setSelectable(selectable);
        this_.checkRules();
    }

    private boolean isSeriesUsedForAnyDocument() {
        return this.getDocumentNumberSeriesSet().stream().anyMatch(x -> !x.getFinantialDocumentsSet().isEmpty());
    }

    public boolean isDeletable() {
        return !this.getDocumentNumberSeriesSet().stream().anyMatch(x -> !x.isDeletable());
    }

    public boolean isDefaultSeries() {
        return super.getDefaultSeries();
    }

    public boolean isSelectable() {
        return super.getSelectable();
    }

    public boolean isRegulationSeries() {
        return this.getFinantialInstitution().getRegulationSeries() == this;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new Series$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(Series this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.Series.cannot.delete", new String[0]);
        }
        this_.setBennu(null);
        for (DocumentNumberSeries ser : this_.getDocumentNumberSeriesSet()) {
            this_.removeDocumentNumberSeries(ser);
            ser.delete();
        }
        this_.setFinantialInstitution(null);
        this_.deleteDomainObject();
    }

    public static Set<Series> findAll() {
        return Bennu.getInstance().getSeriesSet();
    }

    public static Set<Series> find(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getSeriesSet();
    }

    public static Series findByCode(FinantialInstitution finantialInstitution, String code) {
        Series result = null;
        for (Series it : Series.find(finantialInstitution)) {
            if (!it.getCode().equalsIgnoreCase(code)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.Series.duplicated.code", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static Series findByName(FinantialInstitution finantialInstitution, String name) {
        Series result = null;
        for (Series it : Series.find(finantialInstitution)) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.Series.duplicated.name", new String[0]);
            }
            result = it;
        }
        return result;
    }

    protected static Stream<Series> findDefault(FinantialInstitution finantialInstitution) {
        return Series.find(finantialInstitution).stream().filter(s -> s.isDefaultSeries());
    }

    public static Optional<Series> findUniqueDefault(FinantialInstitution finantialInstitution) {
        return Series.findDefault(finantialInstitution).findFirst();
    }

    public static Series create(FinantialInstitution finantialInstitution, String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
        return (Series)((Object)advice$create.perform((Callable)new Series$callable$create(finantialInstitution, string, localizedString, bl, bl2, bl3, bl4, bl5)));
    }

    static /* synthetic */ Series advised$create(FinantialInstitution finantialInstitution, String code, LocalizedString name, boolean externSeries, boolean certificated, boolean legacy, boolean defaultSeries, boolean selectable) {
        return new Series(finantialInstitution, code, name, externSeries, certificated, legacy, defaultSeries, selectable);
    }

    public void createDebitNoteForPendingEntries(DebtAccount debtAccount) {
        Object object = advice$createDebitNoteForPendingEntries.perform((Callable)new Series$callable$createDebitNoteForPendingEntries(this, debtAccount));
    }

    static /* synthetic */ void advised$createDebitNoteForPendingEntries(Series this_, DebtAccount debtAccount) {
        boolean useEntryDateTimeAsDocumentDate = !this_.getCertificated();
        DocumentNumberSeries seriesToProcess = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), this_);
        List debitEntries = debtAccount.getPendingInvoiceEntriesSet().stream().filter(x -> x.getFinantialDocument() == null).filter(x -> x.isDebitNoteEntry()).map(DebitEntry.class::cast).sorted((x, y) -> {
            if (x.getEntryDateTime().equals((Object)y.getEntryDateTime())) {
                return x.getDueDate().compareTo((ReadablePartial)y.getDueDate());
            }
            return x.getEntryDateTime().compareTo((ReadableInstant)y.getEntryDateTime());
        }).collect(Collectors.toList());
        DebitNote debitNote = null;
        DebitEntry previousEntry = null;
        if (debitEntries.size() == 0) {
            return;
        }
        boolean debtAccountClosed = debtAccount.getClosed();
        if (debtAccountClosed) {
            debtAccount.reopenDebtAccount();
        }
        for (DebitEntry entry : debitEntries) {
            if (debitNote == null) {
                if (useEntryDateTimeAsDocumentDate) {
                    debitNote = DebitNote.create(debtAccount, seriesToProcess, entry.getEntryDateTime());
                    debitNote.setDocumentDueDate(entry.getDueDate());
                } else {
                    debitNote = DebitNote.create(debtAccount, seriesToProcess, new DateTime());
                }
            }
            if (previousEntry == null) {
                previousEntry = entry;
            }
            if (entry.getEntryDateTime().equals((Object)previousEntry.getEntryDateTime()) && entry.getDueDate().equals((Object)previousEntry.getDueDate())) {
                entry.setFinantialDocument((FinantialDocument)((Object)debitNote));
            } else {
                if (useEntryDateTimeAsDocumentDate) {
                    debitNote = DebitNote.create(debtAccount, seriesToProcess, entry.getEntryDateTime());
                    debitNote.setDocumentDueDate(entry.getDueDate());
                } else {
                    debitNote = DebitNote.create(debtAccount, seriesToProcess, new DateTime());
                }
                entry.setFinantialDocument((FinantialDocument)((Object)debitNote));
            }
            previousEntry = entry;
        }
        if (debtAccountClosed) {
            debtAccount.closeDebtAccount();
        }
    }

    public void createDebitNoteForPendingEntry(DebitEntry debitEntry) {
        Object object = advice$createDebitNoteForPendingEntry.perform((Callable)new Series$callable$createDebitNoteForPendingEntry(this, debitEntry));
    }

    static /* synthetic */ void advised$createDebitNoteForPendingEntry(Series this_, DebitEntry debitEntry) {
        boolean useEntryDateTimeAsDocumentDate = !this_.getCertificated();
        DocumentNumberSeries seriesToProcess = DocumentNumberSeries.find(FinantialDocumentType.findForDebitNote(), this_);
        DebtAccount debtAccount = debitEntry.getDebtAccount();
        DebitNote debitNote = null;
        boolean debtAccountClosed = debtAccount.getClosed();
        if (debtAccountClosed) {
            debtAccount.reopenDebtAccount();
        }
        if (useEntryDateTimeAsDocumentDate) {
            debitNote = DebitNote.create(debtAccount, seriesToProcess, debitEntry.getEntryDateTime());
            debitNote.setDocumentDueDate(debitEntry.getDueDate());
        } else {
            debitNote = DebitNote.create(debtAccount, seriesToProcess, new DateTime());
        }
        debitEntry.setFinantialDocument((FinantialDocument)((Object)debitNote));
        if (debtAccountClosed) {
            debtAccount.closeDebtAccount();
        }
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createDebitNoteForPendingEntries = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$createDebitNoteForPendingEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARATOR_BY_CODE = new Comparator<Series>(){

            @Override
            public int compare(Series o1, Series o2) {
                int c = o1.getCode().compareTo(o2.getCode());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
        COMPARATOR_BY_DEFAULT = new Comparator<Series>(){

            @Override
            public int compare(Series o1, Series o2) {
                if (o1.isDefaultSeries() && o2.isDefaultSeries()) {
                    return 1;
                }
                if (!o1.isDefaultSeries() && o2.isDefaultSeries()) {
                    return -1;
                }
                return COMPARATOR_BY_CODE.compare(o1, o2);
            }
        };
    }
}

