/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.fenixedu.treasury.domain.AdhocCustomer;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.Constants;

public class ERPCustomerFieldsBean {
    private static final String MORADA_DESCONHECIDO = "Desconhecido";
    private static final int MAX_ADDRESS_DETAIL = 100;
    private static final int MAX_CITY = 50;
    private static final int MAX_ZIPCODE = 20;
    private static final int MAX_REGION = 50;
    private static final int MAX_FISCAL_NUM = 20;
    private static final int MAX_CONTACT = 50;
    private static final int MAX_NAME = 100;
    private static final int MAX_STREET_NAME = 90;
    private String customerId;
    private String customerBusinessId;
    private String customerFiscalCountry;
    private String customerNationality;
    private String customerAccountId;
    private String customerFiscalNumber;
    private String customerName;
    private String customerContact;
    private String customerStreetName;
    private String customerAddressDetail;
    private String customerCity;
    private String customerZipCode;
    private String customerRegion;
    private String customerCountry;

    private void checkRules() {
    }

    public static ERPCustomerFieldsBean fillFromCustomer(Customer customer) {
        ERPCustomerFieldsBean bean = new ERPCustomerFieldsBean();
        if (customer instanceof AdhocCustomer) {
            bean.setCustomerAccountId("ADHOC");
        } else {
            bean.setCustomerAccountId("STUDENT");
        }
        if (!ERPCustomerFieldsBean.validateFiscalNumber(customer.getFiscalCountry(), customer.getFiscalNumber())) {
            throw new TreasuryDomainException("error.ERPCustomerFieldsBean.invalid.fiscal.number", new String[0]);
        }
        String fiscalCountry = customer.getFiscalCountry();
        String fiscalNumber = customer.getFiscalNumber();
        String name = customer.getName();
        ArrayList errorMessages = Lists.newArrayList();
        if (!ERPCustomerFieldsBean.validateAddress(fiscalCountry, fiscalNumber, name, customer.getAddressCountryCode(), customer.getAddress(), customer.getZipCode(), customer.getDistrictSubdivision(), errorMessages)) {
            throw new TreasuryDomainException("error.ERPCustomerFieldsBean.invalid.address", new String[0]);
        }
        ERPCustomerFieldsBean.convertAddress(bean, customer.getAddressCountryCode(), customer.getAddress(), customer.getZipCode(), customer.getDistrictSubdivision(), customer.getAddress());
        if (customer.getName().length() > 100) {
            throw new TreasuryDomainException("error.ERPCustomerFieldsBean.customerName.more.than.allowed", String.valueOf(100));
        }
        bean.setCustomerName(customer.getName());
        bean.setCustomerContact((String)Splitter.fixedLength((int)50).splitToList((CharSequence)customer.getName()).get(0));
        bean.setCustomerId(customer.getCode());
        bean.setCustomerBusinessId(customer.getBusinessIdentification());
        if (!Strings.isNullOrEmpty((String)customer.getFiscalNumber()) && customer.getFiscalNumber().length() > 20) {
            throw new TreasuryDomainException("error.ERPCustomerFieldsBean.fiscalNumber.more.than.allowed", String.valueOf(20));
        }
        bean.setCustomerFiscalNumber(customer.getFiscalNumber());
        bean.setCustomerFiscalCountry(customer.getFiscalCountry());
        bean.setCustomerNationality(customer.getNationalityCountryCode());
        bean.checkRules();
        return bean;
    }

    private static boolean validateFiscalNumber(String fiscalCountryCode, String fiscalNumber) {
        return !Strings.isNullOrEmpty((String)fiscalNumber);
    }

    public static ERPCustomerFieldsBean fillFromDebitNote(DebitNote debitNote) {
        return ERPCustomerFieldsBean.fillFromCustomer(debitNote.getDebtAccount().getCustomer());
    }

    public static ERPCustomerFieldsBean fillPayorFromDebitNote(DebitNote debitNote) {
        Customer payorCustomer = debitNote.getPayorDebtAccount().getCustomer();
        String fiscalCountry = payorCustomer.getFiscalCountry();
        String fiscalNumber = payorCustomer.getFiscalNumber();
        String name = payorCustomer.getName();
        ArrayList errorMessages = Lists.newArrayList();
        if (!ERPCustomerFieldsBean.validateAddress(fiscalCountry, fiscalNumber, name, payorCustomer.getAddressCountryCode(), payorCustomer.getAddress(), payorCustomer.getZipCode(), payorCustomer.getDistrictSubdivision(), errorMessages)) {
            throw new TreasuryDomainException("error.ERPCustomerFieldsBean.invalid.address", new String[0]);
        }
        return ERPCustomerFieldsBean.fillFromCustomer(payorCustomer);
    }

    public static ERPCustomerFieldsBean fillFromCreditNote(CreditNote creditNote) {
        return ERPCustomerFieldsBean.fillFromCustomer(creditNote.getDebtAccount().getCustomer());
    }

    public static ERPCustomerFieldsBean fillPayorFromCreditNote(CreditNote creditNote) {
        Customer payorCustomer = creditNote.getPayorDebtAccount().getCustomer();
        String fiscalCountry = payorCustomer.getFiscalCountry();
        String fiscalNumber = payorCustomer.getFiscalNumber();
        String name = payorCustomer.getName();
        ArrayList errorMessages = Lists.newArrayList();
        if (!ERPCustomerFieldsBean.validateAddress(fiscalCountry, fiscalNumber, name, payorCustomer.getAddressCountryCode(), payorCustomer.getAddress(), payorCustomer.getZipCode(), payorCustomer.getDistrictSubdivision(), errorMessages)) {
            throw new TreasuryDomainException("error.ERPCustomerFieldsBean.invalid.address", new String[0]);
        }
        return ERPCustomerFieldsBean.fillFromCustomer(payorCustomer);
    }

    private static void convertAddress(ERPCustomerFieldsBean bean, String country, String addressDetail, String zipCode, String zipCodeRegion, String street) {
        bean.setCustomerCountry(!Strings.isNullOrEmpty((String)country) ? country : MORADA_DESCONHECIDO);
        bean.setCustomerAddressDetail(!Strings.isNullOrEmpty((String)addressDetail) ? addressDetail : MORADA_DESCONHECIDO);
        bean.setCustomerCity(!Strings.isNullOrEmpty((String)zipCodeRegion) ? zipCodeRegion : MORADA_DESCONHECIDO);
        bean.setCustomerZipCode(!Strings.isNullOrEmpty((String)zipCode) ? zipCode : MORADA_DESCONHECIDO);
        bean.setCustomerRegion(!Strings.isNullOrEmpty((String)zipCodeRegion) ? zipCodeRegion : MORADA_DESCONHECIDO);
        bean.setCustomerStreetName((String)Splitter.fixedLength((int)90).splitToList((CharSequence)street).get(0));
    }

    public static boolean validateAddress(Customer customer, List<String> errorMessages) {
        return ERPCustomerFieldsBean.validateAddress(customer.getFiscalCountry(), customer.getFiscalNumber(), customer.getName(), customer.getAddressCountryCode(), customer.getAddress(), customer.getZipCode(), customer.getDistrictSubdivision(), errorMessages);
    }

    private static boolean validateAddress(String fiscalCountry, String fiscalNumber, String name, String addressCountryCode, String address, String zipCode, String districtSubdivision, List<String> errorMessages) {
        if (Strings.isNullOrEmpty((String)addressCountryCode)) {
            errorMessages.add(Constants.bundle("error.ERPCustomerFieldsBean.address.countryCode.not.filled", fiscalCountry, fiscalNumber, name));
        }
        if (Strings.isNullOrEmpty((String)address)) {
            errorMessages.add(Constants.bundle("error.ERPCustomerFieldsBean.address.address.not.filled", fiscalCountry, fiscalNumber, name));
        }
        if (Strings.isNullOrEmpty((String)zipCode)) {
            errorMessages.add(Constants.bundle("error.ERPCustomerFieldsBean.address.zipCode.not.filled", fiscalCountry, fiscalNumber, name));
        }
        if (Strings.isNullOrEmpty((String)districtSubdivision)) {
            errorMessages.add(Constants.bundle("error.ERPCustomerFieldsBean.address.districtSubdivision.not.filled", fiscalCountry, fiscalNumber, name));
        }
        if (!Strings.isNullOrEmpty((String)address) && address.length() > 100) {
            errorMessages.add(Constants.bundle("error.ERPCustomerFieldsBean.addressDetail.more.than.allowed", String.valueOf(100), address, fiscalCountry, fiscalNumber, name));
        }
        if (!Strings.isNullOrEmpty((String)districtSubdivision) && districtSubdivision.length() > 50) {
            errorMessages.add(Constants.bundle("error.ERPCustomerFieldsBean.city.more.than.allowed", String.valueOf(50), districtSubdivision, fiscalCountry, fiscalNumber, name));
        }
        if (!Strings.isNullOrEmpty((String)zipCode) && zipCode.length() > 20) {
            errorMessages.add(Constants.bundle("error.ERPCustomerFieldsBean.zipCode.more.than.allowed", String.valueOf(20), zipCode, fiscalCountry, fiscalNumber, name));
        }
        if (!Strings.isNullOrEmpty((String)districtSubdivision) && districtSubdivision.length() > 50) {
            errorMessages.add(Constants.bundle("error.ERPCustomerFieldsBean.region.more.than.allowed", String.valueOf(50), districtSubdivision, fiscalCountry, fiscalNumber, name));
        }
        return errorMessages.isEmpty();
    }

    public static boolean checkIncompleteAddressForDebtAccountAndPayors(DebtAccount debtAccount, List<String> errorMessages) {
        HashSet referencedCustomers = Sets.newHashSet((Object[])new Customer[]{debtAccount.getCustomer()});
        for (InvoiceEntry invoiceEntry : debtAccount.getActiveInvoiceEntries().collect(Collectors.toSet())) {
            Invoice invoice;
            if (invoiceEntry.getFinantialDocument() == null || !(invoice = (Invoice)((Object)invoiceEntry.getFinantialDocument())).isForPayorDebtAccount()) continue;
            referencedCustomers.add(invoice.getPayorDebtAccount().getCustomer());
        }
        boolean validAddress = true;
        for (Customer customer : referencedCustomers) {
            validAddress &= ERPCustomerFieldsBean.validateAddress(customer, errorMessages);
        }
        return validAddress;
    }

    public String getCustomerBusinessId() {
        return this.customerBusinessId;
    }

    public void setCustomerBusinessId(String customerBusinessId) {
        this.customerBusinessId = customerBusinessId;
    }

    public String getCustomerFiscalCountry() {
        return this.customerFiscalCountry;
    }

    public void setCustomerFiscalCountry(String customerFiscalCountry) {
        this.customerFiscalCountry = customerFiscalCountry;
    }

    public String getCustomerNationality() {
        return this.customerNationality;
    }

    public void setCustomerNationality(String customerNationality) {
        this.customerNationality = customerNationality;
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getCustomerAccountId() {
        return this.customerAccountId;
    }

    public void setCustomerAccountId(String customerAccountId) {
        this.customerAccountId = customerAccountId;
    }

    public String getCustomerFiscalNumber() {
        return this.customerFiscalNumber;
    }

    public void setCustomerFiscalNumber(String customerFiscalNumber) {
        this.customerFiscalNumber = customerFiscalNumber;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getCustomerContact() {
        return this.customerContact;
    }

    public void setCustomerContact(String customerContact) {
        this.customerContact = customerContact;
    }

    public String getCustomerStreetName() {
        return this.customerStreetName;
    }

    public void setCustomerStreetName(String custometStreetName) {
        this.customerStreetName = custometStreetName;
    }

    public String getCustomerAddressDetail() {
        return this.customerAddressDetail;
    }

    public void setCustomerAddressDetail(String customerAddressDetail) {
        this.customerAddressDetail = customerAddressDetail;
    }

    public String getCustomerCity() {
        return this.customerCity;
    }

    public void setCustomerCity(String customerCity) {
        this.customerCity = customerCity;
    }

    public String getCustomerZipCode() {
        return this.customerZipCode;
    }

    public void setCustomerZipCode(String customerZipCode) {
        this.customerZipCode = customerZipCode;
    }

    public String getCustomerRegion() {
        return this.customerRegion;
    }

    public void setCustomerRegion(String customerRegion) {
        this.customerRegion = customerRegion;
    }

    public String getCustomerCountry() {
        return this.customerCountry;
    }

    public void setCustomerCountry(String customerCountry) {
        this.customerCountry = customerCountry;
    }
}

