/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries$callable$create;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries$callable$delete;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries$callable$getSequenceNumberAndIncrement;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries_Base;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DocumentNumberSeries
extends DocumentNumberSeries_Base {
    public static Comparator<DocumentNumberSeries> COMPARE_BY_DEFAULT;
    public static Comparator<DocumentNumberSeries> COMPARE_BY_NAME;
    public static final Advice advice$getSequenceNumberAndIncrement;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    protected DocumentNumberSeries() {
        this.setBennu(Bennu.getInstance());
    }

    protected DocumentNumberSeries(FinantialDocumentType finantialDocumentType, Series series) {
        this();
        this.setCounter(0);
        this.setFinantialDocumentType(finantialDocumentType);
        this.setSeries(series);
        this.setReplacePrefix(false);
        this.setReplacingPrefix(null);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialDocumentType() == null) {
            throw new TreasuryDomainException("error.DocumentNumberSeries.finantialDocumentType.required", new String[0]);
        }
        if (this.getSeries() == null) {
            throw new TreasuryDomainException("error.DocumentNumberSeries.series.required", new String[0]);
        }
        if (this.isReplacePrefix() && Strings.isNullOrEmpty((String)this.getReplacingPrefix())) {
            throw new TreasuryDomainException("error.DocumentNumberSeries.replacePrefix.wrong.arguments", new String[0]);
        }
        if (!this.isReplacePrefix() && !Strings.isNullOrEmpty((String)this.getReplacingPrefix())) {
            throw new TreasuryDomainException("error.DocumentNumberSeries.replacePrefix.wrong.arguments", new String[0]);
        }
        DocumentNumberSeries.find(this.getFinantialDocumentType(), this.getSeries());
    }

    public int getSequenceNumber() {
        return this.getCounter();
    }

    public int getSequenceNumberAndIncrement() {
        return (Integer)advice$getSequenceNumberAndIncrement.perform((Callable)new DocumentNumberSeries$callable$getSequenceNumberAndIncrement(this));
    }

    static /* synthetic */ int advised$getSequenceNumberAndIncrement(DocumentNumberSeries this_) {
        if (!this_.getSeries().getActive()) {
            throw new TreasuryDomainException("error.DocumentNumberSeries.document.is.in.closed.series", new String[0]);
        }
        int count = this_.getCounter();
        this_.setCounter(++count);
        return count;
    }

    public boolean isReplacePrefix() {
        return this.getReplacePrefix();
    }

    public boolean isDeletable() {
        return this.getFinantialDocumentsSet().isEmpty() && this.getPaymentCodePoolPaymentSeriesSet().isEmpty();
    }

    public void editReplacingPrefix(boolean replacePrefix, String replacingPrefix) {
        this.setReplacePrefix(replacePrefix);
        if (this.isReplacePrefix()) {
            this.setReplacingPrefix(replacingPrefix);
        }
        this.checkRules();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new DocumentNumberSeries$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(DocumentNumberSeries this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.DocumentNumberSeries.cannot.delete", new String[0]);
        }
        this_.setBennu(null);
        this_.setFinantialDocumentType(null);
        this_.setSeries(null);
        this_.deleteDomainObject();
    }

    public static Stream<DocumentNumberSeries> findAll() {
        return Bennu.getInstance().getDocumentNumberSeriesSet().stream();
    }

    public static DocumentNumberSeries find(FinantialDocumentType finantialDocumentType, Series series) {
        Set result = finantialDocumentType.getDocumentNumberSeriesSet().stream().filter(dns -> dns.getSeries().getCode().equals(series.getCode()) && dns.getSeries().getFinantialInstitution().equals(series.getFinantialInstitution())).collect(Collectors.toSet());
        if (result.size() > 1) {
            throw new TreasuryDomainException("error.DocumentNumberSeries.not.unique.in.finantialDocumentType.and.series", new String[0]);
        }
        return result.stream().findFirst().orElse(null);
    }

    public static Stream<DocumentNumberSeries> find(FinantialDocumentType finantialDocumentType, FinantialInstitution finantialInstitution) {
        return finantialDocumentType.getDocumentNumberSeriesSet().stream().filter(x -> x.getSeries().getFinantialInstitution().getCode().equals(finantialInstitution.getCode()));
    }

    public static Optional<DocumentNumberSeries> findUniqueDefault(FinantialDocumentType finantialDocumentType, FinantialInstitution finantialInstitution) {
        if (!Series.findUniqueDefault(finantialInstitution).isPresent()) {
            return Optional.empty();
        }
        return Optional.of(DocumentNumberSeries.find(finantialDocumentType, Series.findUniqueDefault(finantialInstitution).get()));
    }

    public static DocumentNumberSeries create(FinantialDocumentType finantialDocumentType, Series series) {
        return (DocumentNumberSeries)((Object)advice$create.perform((Callable)new DocumentNumberSeries$callable$create(finantialDocumentType, series)));
    }

    static /* synthetic */ DocumentNumberSeries advised$create(FinantialDocumentType finantialDocumentType, Series series) {
        return new DocumentNumberSeries(finantialDocumentType, series);
    }

    public long getPreparingDocumentsCount() {
        return this.getFinantialDocumentsSet().stream().filter(x -> x.isPreparing()).count();
    }

    public long getDocumentsCount() {
        return this.getFinantialDocumentsSet().stream().count();
    }

    public long getClosedDocumentsCount() {
        return this.getFinantialDocumentsSet().stream().filter(x -> x.isClosed()).count();
    }

    public static Stream<DocumentNumberSeries> applyActiveSelectableAndDefaultSorting(Stream<DocumentNumberSeries> stream) {
        return stream.filter(x -> x.getSeries().getActive()).filter(d -> d.getSeries().isSelectable()).sorted(COMPARE_BY_DEFAULT.thenComparing(COMPARE_BY_NAME));
    }

    public String documentNumberSeriesPrefix() {
        if (this.isReplacePrefix()) {
            return this.getReplacingPrefix();
        }
        return this.getFinantialDocumentType().getDocumentNumberSeriesPrefix();
    }

    static {
        advice$getSequenceNumberAndIncrement = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_DEFAULT = (x, y) -> {
            if (x.getSeries().isDefaultSeries()) {
                return -1;
            }
            return 1;
        };
        COMPARE_BY_NAME = (x, y) -> {
            int c = x.getSeries().getName().compareTo(y.getSeries().getName());
            return c != 0 ? c : x.getExternalId().compareTo(y.getExternalId());
        };
    }
}

