/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.accesscontrol;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.DynamicGroup;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.services.accesscontrol.spi.ITreasuryAccessControlExtension;

public class TreasuryAccessControl {
    private static final String TREASURY_MANAGERS = "treasuryManagers";
    private static final String TREASURY_BACK_OFFICE = "treasuryBackOffice";
    private static final String TREASURY_FRONT_OFFICE = "treasuryFrontOffice";
    private static TreasuryAccessControl _instance = null;
    private List<ITreasuryAccessControlExtension> extensions = Collections.synchronizedList(Lists.newArrayList());

    private TreasuryAccessControl() {
    }

    public boolean isFrontOfficeMember() {
        return this.isFrontOfficeMember(Authenticate.getUser());
    }

    public boolean isBackOfficeMember() {
        return this.isBackOfficeMember(Authenticate.getUser());
    }

    public boolean isFrontOfficeMember(FinantialInstitution finantialInstitution) {
        return this.isFrontOfficeMember(Authenticate.getUser(), finantialInstitution);
    }

    public boolean isBackOfficeMember(FinantialInstitution finantialInstitution) {
        return this.isBackOfficeMember(Authenticate.getUser(), finantialInstitution);
    }

    public boolean isManager() {
        return this.isManager(Authenticate.getUser());
    }

    public boolean isFrontOfficeMember(User user) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isFrontOfficeMember(user)) continue;
            return true;
        }
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
    }

    public boolean isFrontOfficeMember(User user, FinantialInstitution finantialInstitution) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isFrontOfficeMember(user, finantialInstitution)) continue;
            return true;
        }
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
    }

    public boolean isBackOfficeMember(User user) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isBackOfficeMember(user)) continue;
            return true;
        }
        return this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).isMember(user);
    }

    public boolean isBackOfficeMember(User user, FinantialInstitution finantialInstitution) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isBackOfficeMember(user, finantialInstitution)) continue;
            return true;
        }
        return this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).isMember(user);
    }

    public boolean isBackOfficeMember(User user, FinantialEntity finantialEntity) {
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (!iTreasuryAccessControlExtension.isBackOfficeMember(user, finantialEntity)) continue;
            return true;
        }
        return this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).isMember(user);
    }

    public boolean isManager(User user) {
        return this.getOrCreateDynamicGroup(TREASURY_MANAGERS).isMember(user);
    }

    public Set<User> getFrontOfficeMembers() {
        HashSet result = Sets.newHashSet();
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            result.addAll(iTreasuryAccessControlExtension.getFrontOfficeMembers());
        }
        result.addAll(this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).getMembers());
        return result;
    }

    public Set<User> getBackOfficeMembers() {
        HashSet result = Sets.newHashSet();
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            result.addAll(iTreasuryAccessControlExtension.getBackOfficeMembers());
        }
        result.addAll(this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).getMembers());
        return result;
    }

    public Set<User> getTreasuryManagerMembers() {
        HashSet result = Sets.newHashSet();
        result.addAll(this.getOrCreateDynamicGroup(TREASURY_MANAGERS).getMembers());
        return result;
    }

    public void registerExtension(ITreasuryAccessControlExtension extension) {
        this.extensions.add(extension);
    }

    public void unregisterExtension(ITreasuryAccessControlExtension extension) {
        this.extensions.add(extension);
    }

    public static synchronized TreasuryAccessControl getInstance() {
        if (_instance == null) {
            _instance = new TreasuryAccessControl();
        }
        return _instance;
    }

    private DynamicGroup getOrCreateDynamicGroup(String dynamicGroupName) {
        DynamicGroup dynamicGroup = DynamicGroup.get((String)dynamicGroupName);
        if (!dynamicGroup.isDefined()) {
            User manager = User.findByUsername((String)"manager");
            if (manager != null) {
                dynamicGroup.mutator().grant(manager);
            } else {
                dynamicGroup.toPersistentGroup();
            }
        }
        return dynamicGroup;
    }

    public boolean isAllowToModifyInvoices(User user, FinantialInstitution finantialInstitution) {
        boolean result = this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
        if (result) {
            return result;
        }
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (iTreasuryAccessControlExtension.isAllowToModifyInvoices(user, finantialInstitution)) continue;
            return false;
        }
        return true;
    }

    public boolean isAllowToModifySettlements(User user, FinantialInstitution finantialInstitution) {
        boolean result = this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
        if (result) {
            return result;
        }
        for (ITreasuryAccessControlExtension iTreasuryAccessControlExtension : this.extensions) {
            if (iTreasuryAccessControlExtension.isAllowToModifySettlements(user, finantialInstitution)) continue;
            return false;
        }
        return true;
    }
}

