/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.VatExemptionReason$callable$create;
import org.fenixedu.treasury.domain.VatExemptionReason$callable$delete;
import org.fenixedu.treasury.domain.VatExemptionReason$callable$edit;
import org.fenixedu.treasury.domain.VatExemptionReason$callable$initializeVatExemption;
import org.fenixedu.treasury.domain.VatExemptionReason_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class VatExemptionReason
extends VatExemptionReason_Base {
    public static final Advice advice$initializeVatExemption = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected VatExemptionReason() {
        this.setBennu(Bennu.getInstance());
    }

    public static void initializeVatExemption() {
        Object object = advice$initializeVatExemption.perform((Callable)new VatExemptionReason$callable$initializeVatExemption());
    }

    static /* synthetic */ void advised$initializeVatExemption() {
        if (VatExemptionReason.findAll().count() == 0L) {
            String[] codes;
            for (String code : codes = new String[]{"M01", "M02", "M03", "M04", "M05", "M06", "M07", "M08", "M09", "M10", "M11", "M12", "M13", "M14", "M15", "M16", "M99"}) {
                if (code.equals("M07")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "Isento Artigo 9.\u00ba do CIVA (Ou similar)"));
                    continue;
                }
                if (code.equals("M01")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "Artigo 16.\u00ba n.\u00ba 6 al\u00ednea c) do CIVA (Ou similar)"));
                    continue;
                }
                if (code.equals("M02")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "Artigo 6.\u00ba do Decreto\u2010Lei n.\u00ba 198/90, de 19 de Junho"));
                    continue;
                }
                if (code.equals("M03")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "Exigibilidade de caixa"));
                    continue;
                }
                if (code.equals("M04")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "Isento Artigo 13.\u00ba do CIVA (Ou similar)"));
                    continue;
                }
                if (code.equals("M05")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "Isento Artigo 14.\u00ba do CIVA (Ou similar)"));
                    continue;
                }
                if (code.equals("M06")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "Isento Artigo 15.\u00ba do CIVA (Ou similar)"));
                    continue;
                }
                if (code.equals("M08")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "IVA - Autoliquida\u00e7\u00e3o"));
                    continue;
                }
                if (code.equals("M09")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "IVA \u2010 N\u00e3o confere direito a dedu\u00e7\u00e3o"));
                    continue;
                }
                if (code.equals("M10")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "IVA - Regime de isen\u00e7\u00e3o"));
                    continue;
                }
                if (code.equals("M16")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "Isento Artigo 14.\u00ba do RITI (Ou similar)"));
                    continue;
                }
                if (code.equals("M99")) {
                    VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), "N\u00e3o sujeito; n\u00e3o tributado (Ou similar)"));
                    continue;
                }
                VatExemptionReason.create(code, new LocalizedString(Locale.getDefault(), code));
            }
        }
    }

    protected VatExemptionReason(String code, LocalizedString name) {
        this();
        this.setCode(code);
        this.setName(name);
        this.checkRules();
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.VatExemptionReason.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.VatExemptionReason.name.required", new String[0]);
        }
        VatExemptionReason.findByCode(this.getCode());
        this.getName().getLocales().stream().forEach(l -> VatExemptionReason.findByName(this.getName().getContent(l)));
    }

    public void edit(String string, LocalizedString localizedString) {
        Object object = advice$edit.perform((Callable)new VatExemptionReason$callable$edit(this, string, localizedString));
    }

    static /* synthetic */ void advised$edit(VatExemptionReason this_, String code, LocalizedString name) {
        this_.setCode(code);
        this_.setName(name);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getProductsSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new VatExemptionReason$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(VatExemptionReason this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.VatExemptionReason.cannot.delete", new String[0]);
        }
        this_.setBennu(null);
        this_.deleteDomainObject();
    }

    public static Stream<VatExemptionReason> findAll() {
        return Bennu.getInstance().getVatExemptionReasonsSet().stream();
    }

    public static VatExemptionReason findByCode(String code) {
        VatExemptionReason result = null;
        for (VatExemptionReason it : VatExemptionReason.findAll().collect(Collectors.toList())) {
            if (!it.getCode().equalsIgnoreCase(code)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.VatExemptionReason.duplicated.code", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static VatExemptionReason findByName(String name) {
        VatExemptionReason result = null;
        for (VatExemptionReason it : VatExemptionReason.findAll().collect(Collectors.toList())) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.VatExemptionReason.duplicated.name", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static VatExemptionReason create(String string, LocalizedString localizedString) {
        return (VatExemptionReason)((Object)advice$create.perform((Callable)new VatExemptionReason$callable$create(string, localizedString)));
    }

    static /* synthetic */ VatExemptionReason advised$create(String code, LocalizedString name) {
        return new VatExemptionReason(code, name);
    }
}

