/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.PaymentMethod$callable$create;
import org.fenixedu.treasury.domain.PaymentMethod$callable$delete;
import org.fenixedu.treasury.domain.PaymentMethod$callable$edit;
import org.fenixedu.treasury.domain.PaymentMethod$callable$initializePaymentMethod;
import org.fenixedu.treasury.domain.PaymentMethod_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.util.Constants;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class PaymentMethod
extends PaymentMethod_Base {
    public static final Advice advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$initializePaymentMethod = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    protected PaymentMethod() {
        this.setBennu(Bennu.getInstance());
    }

    protected PaymentMethod(String code, LocalizedString name, boolean availableForPaymentInApplication) {
        this();
        this.setCode(code);
        this.setName(name);
        this.setAvailableForPaymentInApplication(availableForPaymentInApplication);
        this.checkRules();
    }

    private void checkRules() {
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.PaymentMethod.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.PaymentMethod.name.required", new String[0]);
        }
        PaymentMethod.findByCode(this.getCode());
        this.getName().getLocales().stream().forEach(l -> PaymentMethod.findByName(this.getName().getContent(l)));
    }

    public boolean isAvailableForPaymentInApplication() {
        return this.getAvailableForPaymentInApplication();
    }

    public void edit(String string, LocalizedString localizedString, boolean bl) {
        Object object = advice$edit.perform((Callable)new PaymentMethod$callable$edit(this, string, localizedString, bl));
    }

    static /* synthetic */ void advised$edit(PaymentMethod this_, String code, LocalizedString name, boolean availableForPaymentInApplication) {
        this_.setCode(code);
        this_.setName(name);
        this_.setAvailableForPaymentInApplication(availableForPaymentInApplication);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return this.getPaymentCodePoolPaymentMethodSet().isEmpty() && this.getPaymentEntriesSet().isEmpty() && this.getReimbursementEntriesSet().isEmpty();
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new PaymentMethod$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(PaymentMethod this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.PaymentMethod.cannot.delete", new String[0]);
        }
        this_.setBennu(null);
        this_.deleteDomainObject();
    }

    public static void initializePaymentMethod() {
        Object object = advice$initializePaymentMethod.perform((Callable)new PaymentMethod$callable$initializePaymentMethod());
    }

    static /* synthetic */ void advised$initializePaymentMethod() {
        if (PaymentMethod.findAll().count() == 0L) {
            PaymentMethod.create("NU", new LocalizedString(Locale.getDefault(), BundleUtil.getString((String)Constants.BUNDLE, (String)"label.PaymentMethod.MON", (String[])new String[0])), true);
            PaymentMethod.create("TB", new LocalizedString(Locale.getDefault(), BundleUtil.getString((String)Constants.BUNDLE, (String)"label.PaymentMethod.WTR", (String[])new String[0])), true);
            PaymentMethod.create("MB", new LocalizedString(Locale.getDefault(), BundleUtil.getString((String)Constants.BUNDLE, (String)"label.PaymentMethod.ELE", (String[])new String[0])), true);
            PaymentMethod.create("CD", new LocalizedString(Locale.getDefault(), BundleUtil.getString((String)Constants.BUNDLE, (String)"label.PaymentMethod.CCR", (String[])new String[0])), true);
            PaymentMethod.create("CH", new LocalizedString(Locale.getDefault(), BundleUtil.getString((String)Constants.BUNDLE, (String)"label.PaymentMethod.CH", (String[])new String[0])), true);
        }
    }

    public static Stream<PaymentMethod> findAll() {
        return Bennu.getInstance().getPaymentMethodsSet().stream();
    }

    public static Stream<PaymentMethod> findAvailableForPaymentInApplication() {
        return PaymentMethod.findAll().filter(l -> l.isAvailableForPaymentInApplication());
    }

    public static PaymentMethod findByCode(String code) {
        PaymentMethod result = null;
        for (PaymentMethod it : PaymentMethod.findAll().collect(Collectors.toList())) {
            if (!it.getCode().equalsIgnoreCase(code)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.PaymentMethod.duplicated.code", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static PaymentMethod findByName(String name) {
        PaymentMethod result = null;
        for (PaymentMethod it : PaymentMethod.findAll().collect(Collectors.toList())) {
            if (!LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(it.getName(), name)) continue;
            if (result != null) {
                throw new TreasuryDomainException("error.PaymentMethod.duplicated.name", new String[0]);
            }
            result = it;
        }
        return result;
    }

    public static PaymentMethod create(String string, LocalizedString localizedString, boolean bl) {
        return (PaymentMethod)((Object)advice$create.perform((Callable)new PaymentMethod$callable$create(string, localizedString, bl)));
    }

    static /* synthetic */ PaymentMethod advised$create(String code, LocalizedString name, boolean availableForPaymentInApplication) {
        return new PaymentMethod(code, name, availableForPaymentInApplication);
    }
}

