/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import com.google.common.base.Strings;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FiscalDataUpdateLog_Base;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.joda.time.DateTime;

public class FiscalDataUpdateLog
extends FiscalDataUpdateLog_Base {
    public FiscalDataUpdateLog() {
        this.setBennu(Bennu.getInstance());
    }

    private FiscalDataUpdateLog(Customer customer, String oldFiscalCountry, String oldFiscalNumber, boolean changeFiscalNumberConfirmed, boolean withFinantialDocumentsIntegratedInERP, boolean customerInformationMaybeIntegratedWithSuccess, boolean customerWithFinantialDocumentsIntegratedInPreviousERP) {
        this();
        this.setCustomer(customer);
        this.setWhenUpdated(new DateTime());
        this.setResponsibleUsername(Authenticate.getUser().getUsername());
        this.setOldFiscalCountry(oldFiscalCountry);
        this.setOldFiscalNumber(oldFiscalNumber);
        this.setUpdatedFiscalCountry(customer.getFiscalCountry());
        this.setUpdatedFiscalNumber(customer.getFiscalNumber());
        this.setChangeFiscalNumberConfirmed(changeFiscalNumberConfirmed);
        this.setWithFinantialDocumentsIntegratedInERP(withFinantialDocumentsIntegratedInERP);
        this.setCustomerInformationMaybeIntegratedWithSuccess(customerInformationMaybeIntegratedWithSuccess);
        this.setCustomerWithFinantialDocumentsIntegratedInPreviousERP(customerWithFinantialDocumentsIntegratedInPreviousERP);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getBennu() == null) {
            throw new TreasuryDomainException("error.FiscalDataUpdateLog.bennu.required", new String[0]);
        }
        if (this.getCustomer() == null) {
            throw new TreasuryDomainException("error.FiscalDataUpdateLog.customer.required", new String[0]);
        }
        if (this.getWhenUpdated() == null) {
            throw new TreasuryDomainException("error.FiscalDataUpdateLog.whenUpdated.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getResponsibleUsername())) {
            throw new TreasuryDomainException("error.FiscalDataUpdateLog.responsibleUsername.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getUpdatedFiscalCountry())) {
            throw new TreasuryDomainException("error.FiscalDataUpdateLog.updatedFiscalCountry.required", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getUpdatedFiscalNumber())) {
            throw new TreasuryDomainException("error.FiscalDataUpdateLog.updatedFiscalNumber.required", new String[0]);
        }
    }

    public static FiscalDataUpdateLog create(Customer customer, String oldFiscalCountry, String oldFiscalNumber, boolean changeFiscalNumberConfirmed, boolean withFinantialDocumentsIntegratedInERP, boolean customerInformationMaybeIntegratedWithSuccess, boolean customerWithFinantialDocumentsIntegratedInPreviousERP) {
        FiscalDataUpdateLog log = new FiscalDataUpdateLog(customer, oldFiscalCountry, oldFiscalNumber, changeFiscalNumberConfirmed, withFinantialDocumentsIntegratedInERP, customerInformationMaybeIntegratedWithSuccess, customerWithFinantialDocumentsIntegratedInPreviousERP);
        return log;
    }
}

