/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain;

import java.lang.annotation.Annotation;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.Bennu;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialEntity$callable$create;
import org.fenixedu.treasury.domain.FinantialEntity$callable$delete;
import org.fenixedu.treasury.domain.FinantialEntity$callable$edit;
import org.fenixedu.treasury.domain.FinantialEntity_Base;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.TreasuryDocumentTemplate;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.FixedTariff;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.util.LocalizedStringUtil;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class FinantialEntity
extends FinantialEntity_Base {
    public static final Comparator<FinantialEntity> COMPARE_BY_NAME;
    public static final Advice advice$edit;
    public static final Advice advice$delete;
    public static final Advice advice$create;

    protected FinantialEntity() {
        this.setBennu(Bennu.getInstance());
    }

    protected FinantialEntity(FinantialInstitution finantialInstitution, String code, LocalizedString name) {
        this();
        this.setFinantialInstitution(finantialInstitution);
        this.setCode(code);
        this.setName(name);
        this.checkRules();
    }

    private void checkRules() {
        if (this.getFinantialInstitution() == null) {
            throw new TreasuryDomainException("error.FinantialEntity.finantialInstitution.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getCode())) {
            throw new TreasuryDomainException("error.FinantialEntity.code.required", new String[0]);
        }
        if (LocalizedStringUtil.isTrimmedEmpty(this.getName())) {
            throw new TreasuryDomainException("error.FinantialEntity.name.required", new String[0]);
        }
        if (FinantialEntity.findByCode(this.getFinantialInstitution(), this.getCode()).count() > 1L) {
            throw new TreasuryDomainException("error.FinantialEntity.code.duplicated", new String[0]);
        }
        this.getName().getLocales().stream().forEach(l -> {
            if (FinantialEntity.findByName(this.getFinantialInstitution(), this.getName().getContent(l)).count() > 1L) {
                throw new TreasuryDomainException("error.FinantialEntity.name.duplicated", l.toString());
            }
        });
    }

    public void edit(String string, LocalizedString localizedString) {
        Object object = advice$edit.perform((Callable)new FinantialEntity$callable$edit(this, string, localizedString));
    }

    static /* synthetic */ void advised$edit(FinantialEntity this_, String code, LocalizedString name) {
        this_.setCode(code);
        this_.setName(name);
        this_.checkRules();
    }

    public boolean isDeletable() {
        return true;
    }

    public void delete() {
        Object object = advice$delete.perform((Callable)new FinantialEntity$callable$delete(this));
    }

    static /* synthetic */ void advised$delete(FinantialEntity this_) {
        if (!this_.isDeletable()) {
            throw new TreasuryDomainException("error.FinantialEntity.cannot.delete", new String[0]);
        }
        this_.setBennu(null);
        this_.setFinantialInstitution(null);
        for (Tariff t : this_.getTariffSet()) {
            this_.removeTariff(t);
            t.delete();
        }
        for (TreasuryDocumentTemplate template : this_.getTreasuryDocumentTemplatesSet()) {
            this_.removeTreasuryDocumentTemplates(template);
            template.delete();
        }
        this_.deleteDomainObject();
    }

    public TreasuryDocumentTemplate hasDocumentTemplate(FinantialDocumentType type) {
        for (TreasuryDocumentTemplate documentTemplate : this.getTreasuryDocumentTemplatesSet()) {
            if (!documentTemplate.getFinantialDocumentType().getType().equals((Object)type.getType())) continue;
            return documentTemplate;
        }
        return null;
    }

    public static Stream<FinantialEntity> findAll() {
        return Bennu.getInstance().getFinantialEntitiesSet().stream();
    }

    public static Stream<FinantialEntity> find(FinantialInstitution finantialInstitution) {
        return finantialInstitution.getFinantialEntitiesSet().stream();
    }

    public static Stream<FinantialEntity> findByCode(FinantialInstitution finantialInstitution, String code) {
        return FinantialEntity.find(finantialInstitution).filter(fe -> fe.getCode().equalsIgnoreCase(code));
    }

    public static Stream<FinantialEntity> findByName(FinantialInstitution finantialInstitution, String name) {
        return FinantialEntity.findAll().filter(fe -> LocalizedStringUtil.isEqualToAnyLocaleIgnoreCase(fe.getName(), name));
    }

    public static Stream<FinantialEntity> findWithBackOfficeAccessFor(User user) {
        return FinantialEntity.findAll().filter(l -> TreasuryAccessControlAPI.isBackOfficeMember(user, l));
    }

    public static FinantialEntity create(FinantialInstitution finantialInstitution, String string, LocalizedString localizedString) {
        return (FinantialEntity)((Object)advice$create.perform((Callable)new FinantialEntity$callable$create(finantialInstitution, string, localizedString)));
    }

    static /* synthetic */ FinantialEntity advised$create(FinantialInstitution finantialInstitution, String code, LocalizedString name) {
        return new FinantialEntity(finantialInstitution, code, name);
    }

    public Set<FixedTariff> getFixedTariffSet() {
        return this.getTariffSet().stream().filter(x -> x instanceof FixedTariff).map(FixedTariff.class::cast).collect(Collectors.toSet());
    }

    static {
        advice$edit = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$create = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_NAME = new Comparator<FinantialEntity>(){

            @Override
            public int compare(FinantialEntity o1, FinantialEntity o2) {
                int c = o1.getName().getContent().compareTo(o2.getName().getContent());
                return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
            }
        };
    }
}

