/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.payments.onlinepaymentsgateway;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.onlinepaymentsgateway.api.DigitalPlatformResultBean;
import org.fenixedu.onlinepaymentsgateway.api.PaymentStateBean;
import org.fenixedu.onlinepaymentsgateway.api.SIBSOnlinePaymentsGatewayService;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PaymentType;
import org.fenixedu.onlinepaymentsgateway.util.Decryption;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPaymentRequest;
import org.fenixedu.treasury.domain.forwardpayments.implementations.IForwardPaymentPlatformService;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.paymentcodes.integration.ISibsPaymentCodePoolService;
import org.fenixedu.treasury.domain.payments.IMbwayPaymentPlatformService;
import org.fenixedu.treasury.domain.payments.PaymentRequest;
import org.fenixedu.treasury.domain.payments.PaymentRequestLog;
import org.fenixedu.treasury.domain.payments.integration.DigitalPaymentPlatform;
import org.fenixedu.treasury.domain.sibspaymentsgateway.MbwayRequest;
import org.fenixedu.treasury.domain.sibspaymentsgateway.SibsPaymentsGatewayLog;
import org.fenixedu.treasury.domain.sibspaymentsgateway.integration.SibsPaymentsGateway;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.document.payments.onlinepaymentsgateway.OnlinePaymentsGatewayWebhooksController$callable$createLog;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(title="label.OnlinePaymentsGatewayWebhooksController.title", app=TreasuryController.class)
@RequestMapping(value={"/treasury/document/payments/onlinepaymentsgateway"})
public class OnlinePaymentsGatewayWebhooksController
extends TreasuryBaseController {
    private static final String RISK_MANAGEMENT_TIMEOUT = "100.380.501";
    private static final Logger logger;
    public static final String CONTROLLER_URL = "/treasury/document/payments/onlinepaymentsgateway";
    private static final String NOTIFICATION_URI = "/notification";
    public static final String NOTIFICATION_URL = "/treasury/document/payments/onlinepaymentsgateway/notification";
    public static final Advice advice$createLog;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path={"/notification"}, method={RequestMethod.POST})
    @ResponseBody
    public void notification(HttpServletRequest request, HttpServletResponse response) {
        SibsPaymentsGatewayLog log = this.createLog();
        boolean mockedUser = false;
        try {
            String notificationInitializationVector = SIBSOnlinePaymentsGatewayService.notificationInitializationVector((HttpServletRequest)request);
            String notificationAuthenticationTag = SIBSOnlinePaymentsGatewayService.notificationAuthenticationTag((HttpServletRequest)request);
            String notificationEncryptedPayload = SIBSOnlinePaymentsGatewayService.notificationEncryptedPayload((HttpServletRequest)request);
            FenixFramework.atomic(() -> log.saveWebhookNotificationData(notificationInitializationVector, notificationAuthenticationTag, notificationEncryptedPayload));
            if (this.isTestPayloadForWebhookActivation(notificationInitializationVector, notificationAuthenticationTag, notificationEncryptedPayload)) {
                response.setStatus(200);
                return;
            }
            SibsPaymentsGateway gateway = (SibsPaymentsGateway)SibsPaymentsGateway.findUniqueActive((FinantialInstitution)((FinantialInstitution)FinantialInstitution.findAll().iterator().next())).orElseThrow(() -> new TreasuryDomainException("error.OnlinePaymentsGatewayWebhooksController.gateway.is.not.active", new String[0]));
            if (!gateway.isActive()) {
                throw new TreasuryDomainException("error.OnlinePaymentsGatewayWebhooksController.gateway.is.not.active", new String[0]);
            }
            PaymentStateBean bean = gateway.handleWebhookNotificationRequest(notificationInitializationVector, notificationAuthenticationTag, notificationEncryptedPayload);
            FenixFramework.atomic(() -> {
                log.logRequestReceiveDateAndData(bean.getTransactionId(), bean.isOperationSuccess(), bean.isPaid(), bean.getPaymentGatewayResultCode(), bean.getPaymentGatewayResultDescription());
                log.saveRequest(bean.getRequestLog());
            });
            if (!"PAYMENT".equals(bean.getNotificationType())) {
                response.setStatus(200);
                return;
            }
            FenixFramework.atomic(() -> {
                log.saveMerchantTransactionId(bean.getMerchantTransactionId());
                log.saveTransactionId(bean.getTransactionId());
                log.saveReferenceId(bean.getReferencedId());
            });
            if (PaymentType.PA.name().equals(bean.getPaymentType()) && "SIBS_MULTIBANCO".equals(bean.getPaymentBrand())) {
                response.setStatus(200);
                return;
            }
            Optional referenceCodeOptional = bean.getReferencedId() != null ? SibsPaymentRequest.findUniqueBySibsGatewayTransactionId((String)bean.getReferencedId()) : Optional.empty();
            Optional mbwayPaymentRequestOptional = MbwayRequest.findUniqueBySibsGatewayMerchantTransactionId((String)bean.getMerchantTransactionId());
            Optional forwardPaymentRequestOptional = ForwardPaymentRequest.findUniqueByMerchantTransactionId((String)bean.getMerchantTransactionId());
            if (referenceCodeOptional.isPresent()) {
                if (!bean.isOperationSuccess()) {
                    response.setStatus(200);
                    return;
                }
                if (!PaymentType.RC.name().equals(bean.getPaymentType())) {
                    throw new TreasuryDomainException("error.OnlinePaymentsGatewayWebhooksController.unrecognized.payment.type.for.payment.reference.code", new String[0]);
                }
                if (!bean.isPaid()) {
                    throw new TreasuryDomainException("error.OnlinePaymentsGatewayWebhooksController.notificationBean.not.paid.check", new String[0]);
                }
            } else {
                if (mbwayPaymentRequestOptional.isPresent()) {
                    if (!bean.isOperationSuccess()) {
                        response.setStatus(200);
                        return;
                    }
                    if (!PaymentType.DB.name().equals(bean.getPaymentType())) {
                        throw new TreasuryDomainException("error.OnlinePaymentsGatewayWebhooksController.unrecognized.payment.type.for.mbway.payment.request", new String[0]);
                    }
                    mockedUser = this.mockUserIfNeeded(((MbwayRequest)mbwayPaymentRequestOptional.get()).getDigitalPaymentPlatform());
                    MbwayRequest mbwayRequest = (MbwayRequest)mbwayPaymentRequestOptional.get();
                    FenixFramework.atomic(() -> log.setPaymentRequest((PaymentRequest)mbwayRequest));
                    if (bean.isPaid()) {
                        IMbwayPaymentPlatformService mbwayPaymentRequest = ((MbwayRequest)mbwayPaymentRequestOptional.get()).getDigitalPaymentPlatform().castToMbwayPaymentPlatformService();
                        mbwayPaymentRequest.processMbwayTransaction((PaymentRequestLog)log, (DigitalPlatformResultBean)bean);
                    }
                    response.setStatus(200);
                    return;
                }
                if (forwardPaymentRequestOptional.isPresent()) {
                    IForwardPaymentPlatformService digitalPaymentPlatform = (IForwardPaymentPlatformService)((ForwardPaymentRequest)forwardPaymentRequestOptional.get()).getDigitalPaymentPlatform();
                    mockedUser = this.mockUserIfNeeded(((ForwardPaymentRequest)forwardPaymentRequestOptional.get()).getDigitalPaymentPlatform());
                    ForwardPaymentRequest forwardPaymentRequest = (ForwardPaymentRequest)forwardPaymentRequestOptional.get();
                    FenixFramework.atomic(() -> log.setPaymentRequest((PaymentRequest)forwardPaymentRequest));
                    if (bean.getResult() != null && RISK_MANAGEMENT_TIMEOUT.equals(bean.getResult().getCode())) {
                        response.setStatus(200);
                        return;
                    }
                    digitalPaymentPlatform.processForwardPaymentFromWebhook((PaymentRequestLog)log, (DigitalPlatformResultBean)bean);
                    response.setStatus(200);
                    return;
                }
                throw new TreasuryDomainException("error.OnlinePaymentsGatewayWebhooksController.notificationBean.paymentReferenceCode.not.found.by.referenceId", new String[0]);
            }
            mockedUser = this.mockUserIfNeeded(((SibsPaymentRequest)referenceCodeOptional.get()).getDigitalPaymentPlatform());
            ISibsPaymentCodePoolService paymentReferenceCodeService = ((SibsPaymentRequest)referenceCodeOptional.get()).getDigitalPaymentPlatform().castToSibsPaymentCodePoolService();
            SibsPaymentRequest paymentReferenceCode = (SibsPaymentRequest)referenceCodeOptional.get();
            FenixFramework.atomic(() -> log.setPaymentRequest((PaymentRequest)paymentReferenceCode));
            paymentReferenceCodeService.processPaymentReferenceCodeTransaction((PaymentRequestLog)log, (DigitalPlatformResultBean)bean);
            response.setStatus(200);
        }
        catch (Exception e) {
            if (log != null) {
                FenixFramework.atomic(() -> log.logException(e));
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    OnlinePaymentsGatewayCommunicationException oe = (OnlinePaymentsGatewayCommunicationException)e;
                    FenixFramework.atomic(() -> {
                        log.saveRequest(oe.getRequestLog());
                        log.saveResponse(oe.getResponseLog());
                    });
                }
            }
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            response.setStatus(500);
        }
        finally {
            if (mockedUser) {
                Authenticate.unmock();
                logger.debug("Unmocked user");
            }
        }
    }

    private boolean isTestPayloadForWebhookActivation(String notificationInitializationVector, String notificationAuthenticationTag, String notificationEncryptedPayload) {
        try {
            SibsPaymentsGateway gateway = (SibsPaymentsGateway)SibsPaymentsGateway.findUniqueActive((FinantialInstitution)((FinantialInstitution)FinantialInstitution.findAll().iterator().next())).get();
            String aesKey = gateway.getAesKey();
            Decryption notification = new Decryption(aesKey, notificationInitializationVector, notificationAuthenticationTag, notificationEncryptedPayload);
            String decryptedPayload = notification.decryptPayload();
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(decryptedPayload, (TypeReference)new TypeReference<Map<String, String>>(){});
            if (map.containsKey("type") && map.containsKey("action")) {
                String typeValue = (String)map.get("type");
                String actionValue = (String)map.get("action");
                return "test".equals(typeValue) && "webhook activation".equals(actionValue);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean mockUserIfNeeded(DigitalPaymentPlatform digitalPaymentPlatform) {
        boolean needToMockUser;
        boolean bl = needToMockUser = StringUtils.isEmpty((String)TreasuryConstants.getAuthenticatedUsername()) && StringUtils.isNotEmpty((String)digitalPaymentPlatform.getApplicationUsernameForAutomaticOperations());
        if (needToMockUser) {
            this.mockApplicationUser(digitalPaymentPlatform.getApplicationUsernameForAutomaticOperations());
            logger.debug("Mocked user with " + digitalPaymentPlatform.getApplicationUsernameForAutomaticOperations());
            return true;
        }
        return false;
    }

    private void mockApplicationUser(String username) {
        User user = User.findByUsername((String)username);
        if (user == null) {
            throw new IllegalArgumentException("user not found: " + username);
        }
        Authenticate.mock((User)user, (String)"TODO: CHANGE ME");
    }

    private SibsPaymentsGatewayLog createLog() {
        return (SibsPaymentsGatewayLog)advice$createLog.perform((Callable)new OnlinePaymentsGatewayWebhooksController$callable$createLog(this));
    }

    static /* synthetic */ SibsPaymentsGatewayLog advised$createLog(OnlinePaymentsGatewayWebhooksController this_) {
        return SibsPaymentsGatewayLog.createLogForWebhookNotification();
    }

    static {
        advice$createLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(OnlinePaymentsGatewayWebhooksController.class);
    }
}

