/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.managefinantialinstitution;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialInstitutionController;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.SeriesController$callable$createSeries;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Component(value="org.fenixedu.treasury.ui.administration.manageFinantialInstitution.series")
@BennuSpringController(value=FinantialInstitutionController.class)
@RequestMapping(value={"/treasury/administration/managefinantialinstitution/series"})
public class SeriesController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/managefinantialinstitution/series";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/managefinantialinstitution/series/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/managefinantialinstitution/series/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/managefinantialinstitution/series/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/managefinantialinstitution/series/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/managefinantialinstitution/series/delete/";
    public static final Advice advice$createSeries = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        if (model.containsAttribute("finantialInstitutionId")) {
            return "forward:/treasury/administration/managefinantialinstitution/finantialinstitution/read/" + model.asMap().get("finantialInstitutionId");
        }
        return "forward:/treasury/administration/managefinantialinstitution/finantialinstitution/";
    }

    private Series getSeries(Model model) {
        return (Series)model.asMap().get("series");
    }

    private void setSeries(Series series, Model model) {
        model.addAttribute("series", (Object)series);
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") Series series, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + series.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") Series series, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(series.getFinantialInstitution(), model);
            this.setSeries(series, model);
            return "treasury/administration/managefinantialinstitution/series/read";
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/read/" + series.getFinantialInstitution().getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") Series series, Model model, RedirectAttributes redirectAttributes) {
        this.setSeries(series, model);
        try {
            FinantialInstitution finantialInstitution = series.getFinantialInstitution();
            super.assertUserIsBackOfficeMember(finantialInstitution, model);
            series.delete();
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/read/" + finantialInstitution.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + series.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(@RequestParam(value="finantialInstitutionId", required=false) FinantialInstitution finantialInstitution, Model model) {
        model.addAttribute("finantialInstitutionId", (Object)finantialInstitution.getExternalId());
        return "treasury/administration/managefinantialinstitution/series/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="finantialInstitutionId", required=false) FinantialInstitution finantialInstitution, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, @RequestParam(value="externseries", required=false) boolean externSeries, @RequestParam(value="certificated", required=false) boolean certificated, @RequestParam(value="legacy", required=false) boolean legacy, @RequestParam(value="selectable", required=false) boolean selectable, Model model, RedirectAttributes redirectAttributes) {
        try {
            super.assertUserIsBackOfficeMember(finantialInstitution, model);
            Series series = this.createSeries(finantialInstitution, code, name, externSeries, certificated, legacy, selectable);
            model.addAttribute("series", (Object)series);
            return this.redirect(READ_URL + this.getSeries(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(finantialInstitution, model);
    }

    public Series createSeries(FinantialInstitution finantialInstitution, String string, LocalizedString localizedString, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        return (Series)advice$createSeries.perform((Callable)new SeriesController$callable$createSeries(this, finantialInstitution, string, localizedString, bl, bl2, bl3, bl4));
    }

    static /* synthetic */ Series advised$createSeries(SeriesController this_, FinantialInstitution finantialInstitution, String code, LocalizedString name, boolean externSeries, boolean certificated, boolean legacy, boolean selectableForPayments) {
        boolean defaultSeries = finantialInstitution.getSeriesSet().size() == 0;
        return Series.create((FinantialInstitution)finantialInstitution, (String)code, (LocalizedString)name, (boolean)externSeries, (boolean)certificated, (boolean)legacy, (boolean)defaultSeries, (boolean)selectableForPayments);
    }

    @RequestMapping(value={"/search/edit/{oid}"})
    public String processSearchToEditAction(@PathVariable(value="oid") Series series, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(UPDATE_URL + series.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/search/editDefault/{oid}"})
    public String processSearchToEditDefaultAction(@PathVariable(value="oid") Series series, Model model, RedirectAttributes redirectAttributes) {
        this.setSeries(series, model);
        this.setSeriesDefault(model);
        return this.redirect("/treasury/administration/managefinantialinstitution/finantialinstitution/read/" + series.getFinantialInstitution().getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") Series series, Model model, RedirectAttributes redirectAttributes) {
        this.setSeries(series, model);
        try {
            super.assertUserIsBackOfficeMember(series.getFinantialInstitution(), model);
            return "treasury/administration/managefinantialinstitution/series/update";
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            return this.redirect(READ_URL + series.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") Series series, @RequestParam(value="code", required=true) String code, @RequestParam(value="name", required=true) LocalizedString name, @RequestParam(value="externseries", required=true) boolean externSeries, @RequestParam(value="certificated", required=false) boolean certificated, @RequestParam(value="legacy", required=true) boolean legacy, @RequestParam(value="active", required=true) boolean active, @RequestParam(value="selectable", required=false) boolean selectable, Model model, RedirectAttributes redirectAttributes) {
        this.setSeries(series, model);
        try {
            super.assertUserIsBackOfficeMember(series.getFinantialInstitution(), model);
            this.updateSeries(code, name, externSeries, certificated, legacy, active, selectable, model);
            return this.redirect(READ_URL + this.getSeries(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(series, model, redirectAttributes);
    }

    public void updateSeries(String code, LocalizedString name, boolean externSeries, boolean certificated, boolean legacy, boolean active, boolean selectable, Model model) {
        this.getSeries(model).edit(code, name, externSeries, certificated, legacy, active, selectable);
    }

    public void setSeriesDefault(Model model) {
        this.getSeries(model).getFinantialInstitution().markSeriesAsDefault(this.getSeries(model));
    }
}

