/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.managetreasuryexemption;

import java.math.BigDecimal;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.exemption.TreasuryExemptionType;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.TreasuryExemptionBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/managetreasuryexemption/treasuryexemption"})
public class TreasuryExemptionController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/managetreasuryexemption/treasuryexemption";
    private static final String JSP_PATH = "treasury/managetreasuryexemption/treasuryexemption";
    private static final String _CREATE_URI = "/create/";
    public static final String CREATE_URL = "/treasury/managetreasuryexemption/treasuryexemption/create/";
    private static final String _CREATEPOSTBACK_URI = "/createPostBack/";
    public static final String CREATEPOSTBACK_URL = "/treasury/managetreasuryexemption/treasuryexemption/createPostBack/";

    private TreasuryExemptionBean getTreasuryExemptionBean(Model model) {
        return (TreasuryExemptionBean)model.asMap().get("treasuryExemptionBean");
    }

    private void setTreasuryExemptionBean(TreasuryExemptionBean bean, Model model) {
        model.addAttribute("treasuryExemptionBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        model.addAttribute("treasuryExemptionBean", (Object)bean);
    }

    private TreasuryExemption getTreasuryExemption(Model m) {
        return (TreasuryExemption)m.asMap().get("treasuryExemption");
    }

    private void setTreasuryExemption(TreasuryExemption treasuryExemption, Model m) {
        m.addAttribute("treasuryExemption", (Object)treasuryExemption);
    }

    private TreasuryEvent getTreasuryEvent(Model m) {
        return (TreasuryEvent)m.asMap().get("treasuryEvent");
    }

    private void setTreasuryEvent(TreasuryEvent treasuryEvent, Model m) {
        m.addAttribute("treasuryEvent", (Object)treasuryEvent);
    }

    private String treasuryEventUrl(DebtAccount debtAccount, TreasuryEvent treasuryEvent) {
        return String.format("%s/%s/%s", "/treasury/accounting/managecustomer/treasuryevent/read/", debtAccount.getExternalId(), treasuryEvent.getExternalId());
    }

    @RequestMapping(value={"/create/{debtAccountId}/{treasuryEventId}"}, method={RequestMethod.GET})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="treasuryEventId") TreasuryEvent treasuryEvent, Model model) {
        this.setTreasuryEvent(treasuryEvent, model);
        this.setTreasuryExemptionBean(new TreasuryExemptionBean(treasuryEvent), model);
        model.addAttribute("debtAccount", (Object)debtAccount);
        return this.jspPage("create");
    }

    @RequestMapping(value={"/create/{debtAccountId}"}, method={RequestMethod.POST})
    public String create(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=true) TreasuryExemptionBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.setTreasuryExemptionBean(bean, model);
        try {
            this.assertUserIsFrontOfficeMember(model);
            if (!bean.getDebitEntry().getTreasuryExemptionsSet().isEmpty()) {
                throw new TreasuryDomainException("error.TreasuryExemption.debitEntry.already.exempted", new String[0]);
            }
            TreasuryExemption.create((TreasuryExemptionType)bean.getTreasuryExemptionType(), (TreasuryEvent)bean.getTreasuryEvent(), (String)bean.getReason(), (BigDecimal)bean.getNetAmountToExempt(), (DebitEntry)bean.getDebitEntry());
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.create", (String[])new String[0]), model);
            return this.redirect(this.treasuryEventUrl(debtAccount, bean.getTreasuryEvent()), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(debtAccount, bean.getTreasuryEvent(), model);
    }

    @RequestMapping(value={"/createPostBack/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String createpostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean", required=true) TreasuryExemptionBean bean, Model model) {
        if (bean.getDebitEntry() != null && bean.getTreasuryExemptionType() != null) {
            bean.getDebitEntry().getDebtAccount().getFinantialInstitution().getCurrency();
            BigDecimal defaultExemptionAmount = Currency.getValueWithScale((BigDecimal)bean.getDebitEntry().getNetAmount().multiply(TreasuryConstants.divide((BigDecimal)bean.getTreasuryExemptionType().getDefaultExemptionPercentage(), (BigDecimal)TreasuryConstants.HUNDRED_PERCENT)));
            BigDecimal amount = defaultExemptionAmount.min(bean.getDebitEntry().getUiPossibleMaximumAmountToExempt());
            bean.setNetAmountToExempt(amount);
            bean.setCurrencySymbol(bean.getDebitEntry().getDebtAccount().getFinantialInstitution().getCurrency().getSymbol());
        }
        this.setTreasuryExemptionBean(bean, model);
        return this.getBeanJson((ITreasuryBean)bean);
    }

    private String jspPage(String page) {
        return "treasury/managetreasuryexemption/treasuryexemption/" + page;
    }
}

