/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.base.managevatexemptionreason;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.VatExemptionReason;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.base.managevatexemptionreason.VatExemptionReasonController$callable$createVatExemptionReason;
import org.fenixedu.treasury.ui.administration.base.managevatexemptionreason.VatExemptionReasonController$callable$deleteVatExemptionReason;
import org.fenixedu.treasury.ui.administration.base.managevatexemptionreason.VatExemptionReasonController$callable$updateVatExemptionReason;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.base.manageVatExemptionReason", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/base/managevatexemptionreason/vatexemptionreason"})
public class VatExemptionReasonController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/base/managevatexemptionreason/vatexemptionreason";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/base/managevatexemptionreason/vatexemptionreason/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/base/managevatexemptionreason/vatexemptionreason/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/base/managevatexemptionreason/vatexemptionreason/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/base/managevatexemptionreason/vatexemptionreason/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/base/managevatexemptionreason/vatexemptionreason/delete/";
    private static final String SEARCH_VIEW_URI = "/search/view/";
    public static final String SEARCH_VIEW_URL = "/treasury/administration/base/managevatexemptionreason/vatexemptionreason/search/view/";
    public static final Advice advice$deleteVatExemptionReason = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createVatExemptionReason = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateVatExemptionReason = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/base/managevatexemptionreason/vatexemptionreason/";
    }

    private VatExemptionReason getVatExemptionReason(Model m) {
        return (VatExemptionReason)m.asMap().get("vatExemptionReason");
    }

    private void setVatExemptionReason(VatExemptionReason vatExemptionReason, Model m) {
        m.addAttribute("vatExemptionReason", (Object)vatExemptionReason);
    }

    public void deleteVatExemptionReason(VatExemptionReason vatExemptionReason) {
        Object object = advice$deleteVatExemptionReason.perform((Callable)new VatExemptionReasonController$callable$deleteVatExemptionReason(this, vatExemptionReason));
    }

    static /* synthetic */ void advised$deleteVatExemptionReason(VatExemptionReasonController this_, VatExemptionReason vatExemptionReason) {
        vatExemptionReason.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model) {
        List<VatExemptionReason> searchvatexemptionreasonResultsDataSet = this.filterSearchVatExemptionReason(code, name);
        model.addAttribute("searchvatexemptionreasonResultsDataSet", searchvatexemptionreasonResultsDataSet);
        return "treasury/administration/base/managevatexemptionreason/vatexemptionreason/search";
    }

    private List<VatExemptionReason> getSearchUniverseSearchVatExemptionReasonDataSet() {
        return VatExemptionReason.findAll().collect(Collectors.toList());
    }

    private List<VatExemptionReason> filterSearchVatExemptionReason(String code, LocalizedString name) {
        return this.getSearchUniverseSearchVatExemptionReasonDataSet().stream().filter(vatExemptionReason -> code == null || code.length() == 0 || vatExemptionReason.getCode() != null && vatExemptionReason.getCode().length() > 0 && vatExemptionReason.getCode().toLowerCase().contains(code.toLowerCase())).filter(vatExemptionReason -> name == null || name.isEmpty() || name.getLocales().stream().allMatch(locale -> vatExemptionReason.getName().getContent(locale) != null && vatExemptionReason.getName().getContent(locale).toLowerCase().contains(name.getContent(locale).toLowerCase()))).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") VatExemptionReason vatExemptionReason, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + vatExemptionReason.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") VatExemptionReason vatExemptionReason, Model model) {
        this.setVatExemptionReason(vatExemptionReason, model);
        return "treasury/administration/base/managevatexemptionreason/vatexemptionreason/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") VatExemptionReason vatExemptionReason, Model model, RedirectAttributes redirectAttributes) {
        this.setVatExemptionReason(vatExemptionReason, model);
        try {
            this.assertUserIsFrontOfficeMember(model);
            this.deleteVatExemptionReason(vatExemptionReason);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getVatExemptionReason(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        return "treasury/administration/base/managevatexemptionreason/vatexemptionreason/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(model);
            VatExemptionReason vatExemptionReason = this.createVatExemptionReason(code, name);
            model.addAttribute("vatExemptionReason", (Object)vatExemptionReason);
            return this.redirect(READ_URL + this.getVatExemptionReason(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    public VatExemptionReason createVatExemptionReason(String string, LocalizedString localizedString) {
        return (VatExemptionReason)advice$createVatExemptionReason.perform((Callable)new VatExemptionReasonController$callable$createVatExemptionReason(this, string, localizedString));
    }

    static /* synthetic */ VatExemptionReason advised$createVatExemptionReason(VatExemptionReasonController this_, String code, LocalizedString name) {
        return VatExemptionReason.create((String)code, (LocalizedString)name);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") VatExemptionReason vatExemptionReason, Model model) {
        this.setVatExemptionReason(vatExemptionReason, model);
        return "treasury/administration/base/managevatexemptionreason/vatexemptionreason/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") VatExemptionReason vatExemptionReason, @RequestParam(value="code", required=false) String code, @RequestParam(value="name", required=false) LocalizedString name, Model model, RedirectAttributes redirectAttributes) {
        this.setVatExemptionReason(vatExemptionReason, model);
        try {
            this.assertUserIsFrontOfficeMember(model);
            this.updateVatExemptionReason(code, name, model);
            return this.redirect(READ_URL + this.getVatExemptionReason(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.update(vatExemptionReason, model);
    }

    public void updateVatExemptionReason(String string, LocalizedString localizedString, Model model) {
        Object object = advice$updateVatExemptionReason.perform((Callable)new VatExemptionReasonController$callable$updateVatExemptionReason(this, string, localizedString, model));
    }

    static /* synthetic */ void advised$updateVatExemptionReason(VatExemptionReasonController this_, String code, LocalizedString name, Model m) {
        this_.getVatExemptionReason(m).edit(code, name);
    }
}

