/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.accounting.managecustomer;

import com.google.common.base.Strings;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.ui.accounting.managecustomer.TreasuryEventController$callable$deleteTreasuryEvent;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/accounting/managecustomer/treasuryevent"})
public class TreasuryEventController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/accounting/managecustomer/treasuryevent";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/accounting/managecustomer/treasuryevent/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/accounting/managecustomer/treasuryevent/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/accounting/managecustomer/treasuryevent/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/accounting/managecustomer/treasuryevent/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/accounting/managecustomer/treasuryevent/delete/";
    private static final String ANNULDEBITENTRY_URI = "/anulldebitentry/";
    public static final String ANNULDEBITENTRY_URL = "/treasury/accounting/managecustomer/treasuryevent/anulldebitentry/";
    private static final String REVERTANNULDEBITENTRY_URI = "/revertanulldebitentry/";
    public static final String REVERTANNULDEBITENTRY_URL = "/treasury/accounting/managecustomer/treasuryevent/revertanulldebitentry/";
    private static final String ANNULALLDEBITENTRIES_URI = "/annulalldebitentries/";
    public static final String ANNULALLDEBITENTRIES_URL = "/treasury/accounting/managecustomer/treasuryevent/annulalldebitentries/";
    private static final String _SEARCH_TO_DELETE_ACTION_URI = "/treasuryexemption/delete/";
    public static final String SEARCH_TO_DELETE_ACTION_URL = "/treasury/accounting/managecustomer/treasuryevent/treasuryexemption/delete/";
    public static final Advice advice$deleteTreasuryEvent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/accounting/managecustomer/treasuryevent/";
    }

    private TreasuryEvent getTreasuryEvent(Model model) {
        return (TreasuryEvent)model.asMap().get("treasuryEvent");
    }

    private void setTreasuryEvent(TreasuryEvent treasuryEvent, Model model) {
        model.addAttribute("treasuryEvent", (Object)treasuryEvent);
    }

    public void deleteTreasuryEvent(TreasuryEvent treasuryEvent) {
        Object object = advice$deleteTreasuryEvent.perform((Callable)new TreasuryEventController$callable$deleteTreasuryEvent(this, treasuryEvent));
    }

    static /* synthetic */ void advised$deleteTreasuryEvent(TreasuryEventController this_, TreasuryEvent treasuryEvent) {
    }

    @RequestMapping(value={"/"})
    public String searchTreasuryEvents(@RequestParam(value="debtaccount", required=true) DebtAccount debtAccount, Model model) {
        List<? extends TreasuryEvent> searchtreasuryeventsResultsDataSet = this.filterSearchTreasuryEvents(debtAccount);
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("searchtreasuryeventsResultsDataSet", searchtreasuryeventsResultsDataSet);
        return "treasury/accounting/managecustomer/treasuryevent/search";
    }

    private List<? extends TreasuryEvent> filterSearchTreasuryEvents(DebtAccount debtAccount) {
        return TreasuryEvent.find((Customer)debtAccount.getCustomer()).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{debtAccountId}/{oid}"})
    public String processSearchTreasuryEventsToViewAction(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="oid") TreasuryEvent treasuryEvent, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(String.format("/treasury/accounting/managecustomer/treasuryevent/read/%s/%s", debtAccount.getExternalId(), treasuryEvent.getExternalId()), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{debtAccountId}/{oid}"})
    public String read(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="oid") TreasuryEvent treasuryEvent, Model model) {
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("allActiveDebitEntriesDataSet", DebitEntry.find((TreasuryEvent)treasuryEvent).sorted(DebitEntry.COMPARE_BY_EVENT_ANNULED_AND_DUE_DATE).collect(Collectors.toList()));
        model.addAttribute("allActiveCreditEntriesDataSet", CreditEntry.find((TreasuryEvent)treasuryEvent).collect(Collectors.toList()));
        this.setTreasuryEvent(treasuryEvent, model);
        return "treasury/accounting/managecustomer/treasuryevent/read";
    }

    @RequestMapping(value={"/anulldebitentry/{debtAccountId}/{treasuryEventId}/{debitEntryId}"})
    public String anullDebitEntry(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="treasuryEventId") TreasuryEvent treasuryEvent, @PathVariable(value="debitEntryId") DebitEntry debitEntry, Model model) {
        try {
            this.assertUserIsFrontOfficeMember(debitEntry.getDebtAccount().getFinantialInstitution(), model);
            if (!debitEntry.isEventAnnuled()) {
                debitEntry.annulOnEvent();
            }
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.read(debtAccount, treasuryEvent, model);
    }

    @RequestMapping(value={"/revertanulldebitentry/{debtAccountId}/{treasuryEventId}/{debitEntryId}"})
    public String revertAnullDebitEntry(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="treasuryEventId") TreasuryEvent treasuryEvent, @PathVariable(value="debitEntryId") DebitEntry debitEntry, Model model) {
        try {
            this.assertUserIsFrontOfficeMember(debitEntry.getDebtAccount().getFinantialInstitution(), model);
            if (debitEntry.isEventAnnuled()) {
                debitEntry.revertEventAnnuled();
            }
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.read(debtAccount, treasuryEvent, model);
    }

    @RequestMapping(value={"/annulalldebitentries/{debtAccountId}/{treasuryEventId}"})
    public String annulAllDebitEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="treasuryEventId") TreasuryEvent treasuryEvent, @RequestParam(value="treasuryEventAnullDebitEntriesReason", required=false) String reason, Model model) {
        try {
            this.assertUserIsFrontOfficeMember(model);
            if (Strings.isNullOrEmpty((String)reason)) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.TreasuryEvent.annulAllDebitEntries.reason.required", (String[])new String[0]), model);
            }
            treasuryEvent.annulAllDebitEntries(reason);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.TreasuryEvent.annulAllDebitEntries.success", (String[])new String[0]), model);
        }
        catch (Exception e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        return this.read(debtAccount, treasuryEvent, model);
    }

    @RequestMapping(value={"/treasuryexemption/delete/{debtAccountId}/{oid}"}, method={RequestMethod.POST})
    public String processSearchToDeleteAction(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="oid") TreasuryExemption treasuryExemption, Model model, RedirectAttributes redirectAttributes) {
        TreasuryEvent treasuryEvent = treasuryExemption.getDebitEntry().getTreasuryEvent();
        try {
            this.assertUserIsFrontOfficeMember(model);
            if (treasuryExemption.getDebitEntry().isAnnulled() || treasuryExemption.getDebitEntry().getTreasuryEvent() == null || treasuryExemption.getDebitEntry().isEventAnnuled()) {
                throw new TreasuryDomainException("error.TreasuryExemption.delete.impossible", new String[0]);
            }
            treasuryExemption.revertExemption();
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.read(debtAccount, treasuryEvent, model);
        }
        return this.redirect(this.treasuryEventUrl(debtAccount, treasuryEvent), model, redirectAttributes);
    }

    private String treasuryEventUrl(DebtAccount debtAccount, TreasuryEvent treasuryEvent) {
        return String.format("%s/%s/%s", READ_URL, debtAccount.getExternalId(), treasuryEvent.getExternalId());
    }
}

