/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.accesscontrol.spi;

import com.google.common.base.Strings;
import java.util.Set;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.domain.User;
import org.fenixedu.bennu.core.groups.DynamicGroup;
import org.fenixedu.treasury.domain.FinantialEntity;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.FiscalYear;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.accesscontrol.spi.ITreasuryAccessControlExtension;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;

public class TreasuryUIAccessControlExtension
implements ITreasuryAccessControlExtension {
    private static final String TREASURY_MANAGERS = "treasuryManagers";
    private static final String TREASURY_BACK_OFFICE = "treasuryBackOffice";
    private static final String TREASURY_FRONT_OFFICE = "treasuryFrontOffice";
    private static final String TREASURY_ALLOW_TO_ANNUL_SETTLEMENT_NOTES_WITHOUT_RESTRICTIONS = "treasuryAllowAnnulSettlementsWithoutAnyRestriction";

    public boolean isFrontOfficeMember(String username) {
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
    }

    public boolean isFrontOfficeMember(String username, FinantialInstitution finantialInstitution) {
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
    }

    public boolean isBackOfficeMember(String username) {
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).isMember(user);
    }

    public boolean isBackOfficeMember(String username, FinantialInstitution finantialInstitution) {
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).isMember(user);
    }

    public boolean isBackOfficeMember(String username, FinantialEntity finantialEntity) {
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).isMember(user);
    }

    public boolean isManager(String username) {
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_MANAGERS).isMember(user);
    }

    public boolean isAllowToModifySettlements(String username, FinantialInstitution finantialInstitution) {
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
    }

    public boolean isAllowToModifyInvoices(String username, FinantialInstitution finantialInstitution) {
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).isMember(user);
    }

    public boolean isAllowToConditionallyAnnulSettlementNote(String username, SettlementNote settlementNote) {
        int year;
        FinantialInstitution finantialInstitution = settlementNote.getDebtAccount().getFinantialInstitution();
        if (!TreasuryAccessControlAPI.isAllowToModifySettlements((String)username, (FinantialInstitution)finantialInstitution)) {
            return false;
        }
        if (settlementNote.getPaymentTransaction() != null && !TreasuryAccessControlAPI.isManager((String)username)) {
            return false;
        }
        LocalDate annulmentControlDate = settlementNote.getErpCertificationDate();
        if (annulmentControlDate == null) {
            if (settlementNote.isExportedInLegacyERP()) {
                return false;
            }
            if (settlementNote.isDocumentToExport()) {
                return true;
            }
            if (settlementNote.getClearDocumentToExportDate() != null) {
                annulmentControlDate = settlementNote.getClearDocumentToExportDate().toLocalDate();
            } else {
                return false;
            }
        }
        if (!FiscalYear.findUnique((FinantialInstitution)finantialInstitution, (int)(year = annulmentControlDate.getYear())).isPresent()) {
            return false;
        }
        FiscalYear fiscalYear = (FiscalYear)FiscalYear.findUnique((FinantialInstitution)finantialInstitution, (int)year).get();
        if (fiscalYear.getSettlementAnnulmentLimitDate() == null) {
            return false;
        }
        DateTime limitDateTime = fiscalYear.getSettlementAnnulmentLimitDate().toDateTimeAtStartOfDay().plusDays(1).minusSeconds(1);
        return !new DateTime().isAfter((ReadableInstant)limitDateTime);
    }

    public boolean isAllowToAnnulSettlementNoteWithoutAnyRestriction(String username, SettlementNote settlementNote) {
        User user = User.findByUsername((String)username);
        return this.getOrCreateDynamicGroup(TREASURY_ALLOW_TO_ANNUL_SETTLEMENT_NOTES_WITHOUT_RESTRICTIONS).isMember(user);
    }

    private DynamicGroup getOrCreateDynamicGroup(String dynamicGroupName) {
        DynamicGroup dynamicGroup = DynamicGroup.get((String)dynamicGroupName);
        if (!dynamicGroup.isDefined()) {
            User manager = User.findByUsername((String)"manager");
            if (manager != null) {
                dynamicGroup.mutator().grant(manager);
            } else {
                dynamicGroup.toPersistentGroup();
            }
        }
        return dynamicGroup;
    }

    public Set<String> getFrontOfficeMemberUsernames() {
        return this.getOrCreateDynamicGroup(TREASURY_FRONT_OFFICE).getMembers().filter(m -> !Strings.isNullOrEmpty((String)m.getUsername())).map(m -> m.getUsername()).collect(Collectors.toSet());
    }

    public Set<String> getBackOfficeMemberUsernames() {
        return this.getOrCreateDynamicGroup(TREASURY_BACK_OFFICE).getMembers().filter(m -> !Strings.isNullOrEmpty((String)m.getUsername())).map(m -> m.getUsername()).collect(Collectors.toSet());
    }

    public Set<String> getTreasuryManagerMemberUsernames() {
        return this.getOrCreateDynamicGroup(TREASURY_MANAGERS).getMembers().filter(m -> !Strings.isNullOrEmpty((String)m.getUsername())).map(m -> m.getUsername()).collect(Collectors.toSet());
    }
}

