/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.integration.erp;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.Series;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialInstitutionController;
import org.fenixedu.treasury.ui.integration.erp.ERPConfigurationController$callable$updateERPConfiguration;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=FinantialInstitutionController.class)
@RequestMapping(value={"/treasury/integration/erp/erpconfiguration"})
public class ERPConfigurationController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/integration/erp/erpconfiguration";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/integration/erp/erpconfiguration/read/";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/integration/erp/erpconfiguration/update/";
    public static final Advice advice$updateERPConfiguration = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/integration/erp/erpconfiguration/";
    }

    private ERPConfiguration getERPConfiguration(Model model) {
        return (ERPConfiguration)model.asMap().get("eRPConfiguration");
    }

    private void setERPConfiguration(ERPConfiguration eRPConfiguration, Model model) {
        model.addAttribute("eRPConfiguration", (Object)eRPConfiguration);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") ERPConfiguration eRPConfiguration, Model model) {
        this.setERPConfiguration(eRPConfiguration, model);
        return "treasury/integration/erp/erpconfiguration/read";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") ERPConfiguration eRPConfiguration, Model model) {
        model.addAttribute("ERPConfiguration_paymentsIntegrationSeries_options", Series.find((FinantialInstitution)eRPConfiguration.getFinantialInstitution()).stream().filter(x -> x.getExternSeries()).filter(x -> x.getActive()).collect(Collectors.toList()));
        this.setERPConfiguration(eRPConfiguration, model);
        return "treasury/integration/erp/erpconfiguration/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") ERPConfiguration eRPConfiguration, @RequestParam(value="active", required=false) boolean active, @RequestParam(value="exportannulledrelateddocuments", required=false) boolean exportAnnulledRelatedDocuments, @RequestParam(value="exportonlyrelateddocumentsperexport", required=false) boolean exportOnlyRelatedDocumentsPerExport, @RequestParam(value="externalurl", required=false) String externalURL, @RequestParam(value="username", required=false) String username, @RequestParam(value="password", required=false) String password, @RequestParam(value="paymentsintegrationseries", required=false) Series paymentsIntegrationSeries, @RequestParam(value="implementationclassname", required=false) String implementationClassName, @RequestParam(value="maxsizebytestoexportonlineModel", required=false) Long maxSizeBytesToExportOnline, @RequestParam(value="erpidprocess", required=false) String erpIdProcess, Model model, RedirectAttributes redirectAttributes) {
        this.setERPConfiguration(eRPConfiguration, model);
        try {
            this.assertUserIsBackOfficeMember(eRPConfiguration.getFinantialInstitution(), model);
            this.updateERPConfiguration(active, exportOnlyRelatedDocumentsPerExport, exportAnnulledRelatedDocuments, externalURL, username, password, paymentsIntegrationSeries, implementationClassName, maxSizeBytesToExportOnline, erpIdProcess, model);
            return this.redirect(READ_URL + this.getERPConfiguration(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(eRPConfiguration, model);
    }

    public void updateERPConfiguration(boolean bl, boolean bl2, boolean bl3, String string, String string2, String string3, Series series, String string4, Long l, String string5, Model model) {
        Object object = advice$updateERPConfiguration.perform((Callable)new ERPConfigurationController$callable$updateERPConfiguration(this, bl, bl2, bl3, string, string2, string3, series, string4, l, string5, model));
    }

    static /* synthetic */ void advised$updateERPConfiguration(ERPConfigurationController this_, boolean active, boolean exportOnlyRelatedDocumentsPerExport, boolean exportAnnulledRelatedDocuments, String externalURL, String username, String password, Series paymentsIntegrationSeries, String implementationClassName, Long maxSizeBytesToExportOnline, String erpIdProcess, Model model) {
        this_.getERPConfiguration(model).edit(active, paymentsIntegrationSeries, externalURL, username, password, exportAnnulledRelatedDocuments, exportOnlyRelatedDocumentsPerExport, implementationClassName, maxSizeBytesToExportOnline, erpIdProcess);
    }

    @RequestMapping(value={"/update/{oid}/test"})
    public String processUpdateToTest(@PathVariable(value="oid") ERPConfiguration eRPConfiguration, Model model, RedirectAttributes redirectAttributes) {
        this.setERPConfiguration(eRPConfiguration, model);
        try {
            IERPExporter erpExporter = eRPConfiguration.getERPExternalServiceImplementation().getERPExporter();
            erpExporter.testExportToIntegration(eRPConfiguration.getFinantialInstitution());
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.sucess.erpconfiguration.test", (String[])new String[0]), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getERPConfiguration(model).getExternalId(), model, redirectAttributes);
    }
}

