/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.payments.onlinepaymentsgateway;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.onlinepaymentsgateway.api.PaymentStateBean;
import org.fenixedu.onlinepaymentsgateway.api.SIBSOnlinePaymentsGatewayService;
import org.fenixedu.onlinepaymentsgateway.exceptions.OnlinePaymentsGatewayCommunicationException;
import org.fenixedu.onlinepaymentsgateway.sibs.sdk.PaymentType;
import org.fenixedu.onlinepaymentsgateway.util.Decryption;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.MbwayPaymentRequest;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGateway;
import org.fenixedu.treasury.domain.sibsonlinepaymentsgateway.SibsOnlinePaymentsGatewayLog;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.document.payments.onlinepaymentsgateway.OnlinePaymentsGatewayWebhooksController$callable$createLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.FenixFramework;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(title="label.OnlinePaymentsGatewayWebhooksController.title", app=TreasuryController.class)
@RequestMapping(value={"/treasury/document/payments/onlinepaymentsgateway"})
public class OnlinePaymentsGatewayWebhooksController
extends TreasuryBaseController {
    private static final Logger logger;
    public static final String CONTROLLER_URL = "/treasury/document/payments/onlinepaymentsgateway";
    private static final String NOTIFICATION_URI = "/notification";
    public static final String NOTIFICATION_URL = "/treasury/document/payments/onlinepaymentsgateway/notification";
    public static final Advice advice$createLog;

    @RequestMapping(path={"/notification"}, method={RequestMethod.POST})
    @ResponseBody
    public void notification(HttpServletRequest request, HttpServletResponse response) {
        SibsOnlinePaymentsGatewayLog log = this.createLog();
        try {
            String notificationInitializationVector = SIBSOnlinePaymentsGatewayService.notificationInitializationVector((HttpServletRequest)request);
            String notificationAuthenticationTag = SIBSOnlinePaymentsGatewayService.notificationAuthenticationTag((HttpServletRequest)request);
            String notificationEncryptedPayload = SIBSOnlinePaymentsGatewayService.notificationEncryptedPayload((HttpServletRequest)request);
            FenixFramework.atomic(() -> log.saveWebhookNotificationData(notificationInitializationVector, notificationAuthenticationTag, notificationEncryptedPayload));
            if (this.isTestPayloadForWebhookActivation(notificationInitializationVector, notificationAuthenticationTag, notificationEncryptedPayload)) {
                response.setStatus(200);
                return;
            }
            PaymentStateBean bean = ((SibsOnlinePaymentsGateway)SibsOnlinePaymentsGateway.findAll().iterator().next()).handleWebhookNotificationRequest(notificationInitializationVector, notificationAuthenticationTag, notificationEncryptedPayload);
            FenixFramework.atomic(() -> {
                log.logRequestReceiveDateAndData(bean.getTransactionId(), bean.isOperationSuccess(), bean.isPaid(), bean.getPaymentGatewayResultCode(), bean.getPaymentGatewayResultDescription());
                log.saveRequestAndResponsePayload(bean.getRequestLog(), null);
                log.savePaymentTypeAndBrand(bean.getPaymentType(), bean.getPaymentBrand());
            });
            if (!bean.isOperationSuccess()) {
                response.setStatus(200);
                return;
            }
            if (!"PAYMENT".equals(bean.getNotificationType())) {
                response.setStatus(200);
                return;
            }
            FenixFramework.atomic(() -> {
                log.saveMerchantTransactionId(bean.getMerchantTransactionId());
                log.saveReferenceId(bean.getReferencedId());
            });
            if (PaymentType.PA.name().equals(bean.getPaymentType()) && "SIBS_MULTIBANCO".equals(bean.getPaymentBrand())) {
                response.setStatus(200);
                return;
            }
            Optional referenceCodeOptional = bean.getReferencedId() != null ? PaymentReferenceCode.findUniqueBySibsReferenceId((String)bean.getReferencedId()) : Optional.empty();
            Optional mbwayPaymentRequestOptional = MbwayPaymentRequest.findUniqueBySibsMerchantTransactionId((String)bean.getMerchantTransactionId());
            if (referenceCodeOptional.isPresent()) {
                if (!PaymentType.RC.name().equals(bean.getPaymentType())) {
                    throw new TreasuryDomainException("error.OnlinePaymentsGatewayWebhooksController.unrecognized.payment.type.for.payment.reference.code", new String[0]);
                }
                if (!bean.isPaid()) {
                    throw new TreasuryDomainException("error.OnlinePaymentsGatewayWebhooksController.notificationBean.not.paid.check", new String[0]);
                }
                PaymentReferenceCode paymentReferenceCode = (PaymentReferenceCode)referenceCodeOptional.get();
                paymentReferenceCode.processPaymentReferenceCodeTransaction(log, bean);
            } else {
                if (mbwayPaymentRequestOptional.isPresent()) {
                    if (!PaymentType.DB.name().equals(bean.getPaymentType())) {
                        throw new TreasuryDomainException("error.OnlinePaymentsGatewayWebhooksController.unrecognized.payment.type.for.mbway.payment.request", new String[0]);
                    }
                    if (bean.isPaid()) {
                        MbwayPaymentRequest mbwayPaymentRequest = (MbwayPaymentRequest)mbwayPaymentRequestOptional.get();
                        mbwayPaymentRequest.processMbwayTransaction(log, bean);
                    }
                    response.setStatus(200);
                    return;
                }
                boolean isForwardPayment = ForwardPayment.findAll().filter(p -> p.getSibsMerchantTransactionId() != null).filter(p -> p.getSibsMerchantTransactionId().equals(bean.getMerchantTransactionId())).findFirst().isPresent();
                if (!isForwardPayment) {
                    throw new TreasuryDomainException("error.OnlinePaymentsGatewayWebhooksController.notificationBean.paymentReferenceCode.not.found.by.referenceId", new String[0]);
                }
            }
            response.setStatus(200);
        }
        catch (Exception e) {
            if (log != null) {
                FenixFramework.atomic(() -> log.markExceptionOccuredAndSaveLog(e));
                if (e instanceof OnlinePaymentsGatewayCommunicationException) {
                    OnlinePaymentsGatewayCommunicationException oe = (OnlinePaymentsGatewayCommunicationException)e;
                    FenixFramework.atomic(() -> log.saveRequestAndResponsePayload(oe.getRequestLog(), oe.getResponseLog()));
                }
            }
            logger.error(e.getLocalizedMessage(), (Throwable)e);
            response.setStatus(500);
        }
    }

    private boolean isTestPayloadForWebhookActivation(String notificationInitializationVector, String notificationAuthenticationTag, String notificationEncryptedPayload) {
        try {
            String aesKey = ((SibsOnlinePaymentsGateway)SibsOnlinePaymentsGateway.findAll().iterator().next()).getAesKey();
            Decryption notification = new Decryption(aesKey, notificationInitializationVector, notificationAuthenticationTag, notificationEncryptedPayload);
            String decryptedPayload = notification.decryptPayload();
            ObjectMapper mapper = new ObjectMapper();
            Map map = (Map)mapper.readValue(decryptedPayload, (TypeReference)new TypeReference<Map<String, Object>>(){});
            if (map.containsKey("type") && map.containsKey("action")) {
                String typeValue = (String)map.get("type");
                String actionValue = (String)map.get("action");
                return "test".equals(typeValue) && "webhook activation".equals(actionValue);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private SibsOnlinePaymentsGatewayLog createLog() {
        return (SibsOnlinePaymentsGatewayLog)advice$createLog.perform((Callable)new OnlinePaymentsGatewayWebhooksController$callable$createLog(this));
    }

    static /* synthetic */ SibsOnlinePaymentsGatewayLog advised$createLog(OnlinePaymentsGatewayWebhooksController this_) {
        return SibsOnlinePaymentsGatewayLog.createLogForWebhookNotification();
    }

    static {
        advice$createLog = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.WRITE, true));
        logger = LoggerFactory.getLogger(OnlinePaymentsGatewayWebhooksController.class);
    }
}

