/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.managesettlementannulment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.FiscalYear;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.joda.time.LocalDate;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@SpringFunctionality(app=TreasuryController.class, title="label.ManageSettlementAnnulmentLimitDateController.title", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/document/managesettlementannulmentlimitdate"})
public class ManageSettlementAnnulmentLimitDateController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/document/managesettlementannulmentlimitdate";
    private static final String JSP_PATH = "treasury/document/managesettlementannulmentlimitdate";
    private static final String _SEARCH_URI = "/search";
    public static final String SEARCH_URL = "/treasury/document/managesettlementannulmentlimitdate/search";
    private static final String _UPDATE_URI = "/update";
    public static final String UPDATE_URL = "/treasury/document/managesettlementannulmentlimitdate/update";

    @RequestMapping
    public String home(Model model, RedirectAttributes redirectAttributes) {
        if (FinantialInstitution.findAll().count() == 1L) {
            FinantialInstitution institution = (FinantialInstitution)FinantialInstitution.findAll().iterator().next();
            return this.redirect("/treasury/document/managesettlementannulmentlimitdate/search/" + institution.getExternalId(), model, redirectAttributes);
        }
        return this.redirect(SEARCH_URL, model, redirectAttributes);
    }

    @RequestMapping(value={"/search"})
    public String search(Model model, RedirectAttributes redirectAttributes) {
        if (FinantialInstitution.findAll().count() == 1L) {
            FinantialInstitution institution = (FinantialInstitution)FinantialInstitution.findAll().iterator().next();
            return this.redirect("/treasury/document/managesettlementannulmentlimitdate/search/" + institution.getExternalId(), model, redirectAttributes);
        }
        return this.jspPage(_SEARCH_URI);
    }

    @RequestMapping(value={"/search/{finantialInstitutionId}"})
    public String search(@PathVariable(value="finantialInstitutionId") FinantialInstitution finantialInstitution, Model model, RedirectAttributes redirectAttributes) {
        model.addAttribute("finantialInstitutionOptions", FinantialInstitution.findAll().collect(Collectors.toSet()));
        model.addAttribute("finantialInstitution", (Object)finantialInstitution);
        ArrayList result = Lists.newArrayList((Iterable)finantialInstitution.getFiscalYearsSet());
        Collections.sort(result, FiscalYear.COMPARE_BY_YEAR.reversed());
        model.addAttribute("result", (Object)result);
        return this.jspPage(_SEARCH_URI);
    }

    @RequestMapping(value={"/update/{finantialInstitutionId}/{fiscalYearId}"})
    public String update(@PathVariable(value="finantialInstitutionId") FinantialInstitution finantialInstitution, @PathVariable(value="fiscalYearId") FiscalYear fiscalYear, Model model) {
        model.addAttribute("finantialInstitution", (Object)finantialInstitution);
        model.addAttribute("fiscalYear", (Object)fiscalYear);
        return this.jspPage(_UPDATE_URI);
    }

    @RequestMapping(value={"/update/{finantialInstitutionId}/{fiscalYearId}"}, method={RequestMethod.POST})
    public String updatepost(@PathVariable(value="finantialInstitutionId") FinantialInstitution finantialInstitution, @PathVariable(value="fiscalYearId") FiscalYear fiscalYear, @RequestParam(value="settlementAnnulmentLimitDate") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE) LocalDate settlementAnnulmentLimitDate, Model model, RedirectAttributes redirectAttributes) {
        try {
            fiscalYear.editSettlementAnnulmentLimitDate(settlementAnnulmentLimitDate);
            return this.redirect("/treasury/document/managesettlementannulmentlimitdate/search/" + finantialInstitution.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.jspPage(_UPDATE_URI);
        }
    }

    private String jspPage(String mapping) {
        return JSP_PATH + mapping;
    }
}

