/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.managepayments;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.qubit.terra.docs.util.ReportGenerationException;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletResponse;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.commons.StringNormalizer;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.AdvancedPaymentCreditNote;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentStateType;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.PaymentEntry;
import org.fenixedu.treasury.domain.document.PaymentEntry_Base;
import org.fenixedu.treasury.domain.document.ReimbursementEntry;
import org.fenixedu.treasury.domain.document.ReimbursementEntry_Base;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.SettlementNoteBean;
import org.fenixedu.treasury.services.accesscontrol.TreasuryAccessControlAPI;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager;
import org.fenixedu.treasury.services.integration.erp.IERPExporter;
import org.fenixedu.treasury.services.reports.DocumentPrinter;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.document.managepayments.SettlementNoteController$callable$deleteSettlementNote;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.document.managePayments", accessGroup="treasuryFrontOffice")
@RequestMapping(value={"/treasury/document/managepayments/settlementnote"})
public class SettlementNoteController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/document/managepayments/settlementnote";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/document/managepayments/settlementnote/";
    private static final String UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/document/managepayments/settlementnote/update/";
    private static final String CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/document/managepayments/settlementnote/create";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/document/managepayments/settlementnote/read/";
    private static final String DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/document/managepayments/settlementnote/delete/";
    private static final String CHOOSE_INVOICE_ENTRIES_URI = "/chooseInvoiceEntries/";
    public static final String CHOOSE_INVOICE_ENTRIES_URL = "/treasury/document/managepayments/settlementnote/chooseInvoiceEntries/";
    private static final String CALCULATE_INTEREST_URI = "/calculateInterest/";
    public static final String CALCULATE_INTEREST_URL = "/treasury/document/managepayments/settlementnote/calculateInterest/";
    private static final String CREATE_DEBIT_NOTE_URI = "/createDebitNote/";
    public static final String CREATE_DEBIT_NOTE_URL = "/treasury/document/managepayments/settlementnote/createDebitNote/";
    private static final String INSERT_PAYMENT_URI = "/insertpayment/";
    public static final String INSERT_PAYMENT_URL = "/treasury/document/managepayments/settlementnote/insertpayment/";
    private static final String SUMMARY_URI = "/summary/";
    public static final String SUMMARY_URL = "/treasury/document/managepayments/settlementnote/summary/";
    private static final String TRANSACTIONS_SUMMARY_URI = "/transactions/summary/";
    public static final String TRANSACTIONS_SUMMARY_URL = "/treasury/document/managepayments/settlementnote/transactions/summary/";
    public static final long SEARCH_LIMIT_SIZE = 500L;
    public static final long SEARCH_SETTLEMENT_ENTRY_LIMIT_DAYS_PERIOD = 30L;
    private static final String CONTINUE_TO_INSERT_PAYMENT_URI = "/continueToInsertPayment/";
    public static final String CONTINUE_TO_INSERT_PAYMENT_URL = "/treasury/document/managepayments/settlementnote/continueToInsertPayment/";
    private static final String _DOWNLOAD_CERTIFIED_DOCUMENT_PRINT_URI = "/downloadcertifieddocumentprint";
    public static final String DOWNLOAD_CERTIFIED_DOCUMENT_PRINT_URL = "/treasury/document/managepayments/settlementnote/downloadcertifieddocumentprint";
    private static final String _UPDATE_REIMBURSEMENT_STATE_URI = "/updatereimbursementstate";
    public static final String UPDATE_REIMBURSEMENT_STATE_URL = "/treasury/document/managepayments/settlementnote/updatereimbursementstate";
    public static final Advice advice$deleteSettlementNote = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/document/managepayments/settlementnote/";
    }

    private void setSettlementNoteBean(SettlementNoteBean bean, Model model) {
        model.addAttribute("settlementNoteBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        model.addAttribute("settlementNoteBean", (Object)bean);
    }

    private SettlementNote getSettlementNote(Model model) {
        return (SettlementNote)model.asMap().get("settlementNote");
    }

    private void setSettlementNote(SettlementNote settlementNote, Model model) {
        model.addAttribute("settlementNote", (Object)settlementNote);
    }

    public void deleteSettlementNote(SettlementNote settlementNote) {
        Object object = advice$deleteSettlementNote.perform((Callable)new SettlementNoteController$callable$deleteSettlementNote(this, settlementNote));
    }

    static /* synthetic */ void advised$deleteSettlementNote(SettlementNoteController this_, SettlementNote settlementNote) {
        settlementNote.delete(true);
    }

    @RequestMapping(value={"/chooseInvoiceEntries/{debtAccountId}/{reimbursementNote}"})
    public String chooseInvoiceEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @PathVariable(value="reimbursementNote") boolean reimbursementNote, @RequestParam(value="bean", required=false) SettlementNoteBean bean, Model model) {
        this.assertUserIsAllowToModifySettlements(debtAccount.getFinantialInstitution(), model);
        if (bean == null) {
            bean = new SettlementNoteBean(debtAccount, reimbursementNote, false);
        }
        this.setSettlementNoteBean(bean, model);
        return "treasury/document/managepayments/settlementnote/chooseInvoiceEntries";
    }

    @RequestMapping(value={"/chooseInvoiceEntries/"}, method={RequestMethod.POST})
    public String chooseInvoiceEntries(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model) {
        int i;
        BigDecimal debitSum = BigDecimal.ZERO;
        BigDecimal creditSum = BigDecimal.ZERO;
        boolean error = false;
        this.assertUserIsAllowToModifySettlements(bean.getDebtAccount().getFinantialInstitution(), model);
        HashSet invoiceEntriesSet = Sets.newHashSet();
        for (i = 0; i < bean.getDebitEntries().size(); ++i) {
            SettlementNoteBean.DebitEntryBean debitEntryBean = (SettlementNoteBean.DebitEntryBean)bean.getDebitEntries().get(i);
            if (debitEntryBean.isIncluded()) {
                invoiceEntriesSet.add(debitEntryBean.getDebitEntry());
                if (debitEntryBean.getDebtAmountWithVat() == null || debitEntryBean.getDebtAmountWithVat().compareTo(BigDecimal.ZERO) <= 0) {
                    debitEntryBean.setNotValid(true);
                    error = true;
                    this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.DebitEntry.debtAmount.equal.zero", (String[])new String[]{Integer.toString(i + 1)}), model);
                } else if (debitEntryBean.getDebtAmountWithVat().compareTo(debitEntryBean.getDebitEntry().getOpenAmount()) > 0) {
                    debitEntryBean.setNotValid(true);
                    error = true;
                    this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.DebitEntry.exceeded.openAmount", (String[])new String[]{Integer.toString(i + 1)}), model);
                } else {
                    debitEntryBean.setNotValid(false);
                }
                if (debitEntryBean.isNotValid()) continue;
                debitSum = debitSum.add(debitEntryBean.getDebtAmountWithVat());
                continue;
            }
            debitEntryBean.setNotValid(false);
        }
        for (i = 0; i < bean.getCreditEntries().size(); ++i) {
            SettlementNoteBean.CreditEntryBean creditEntryBean = (SettlementNoteBean.CreditEntryBean)bean.getCreditEntries().get(i);
            if (creditEntryBean.isIncluded()) {
                invoiceEntriesSet.add(creditEntryBean.getCreditEntry());
                if (creditEntryBean.getCreditAmountWithVat() == null || creditEntryBean.getCreditAmountWithVat().compareTo(BigDecimal.ZERO) <= 0) {
                    creditEntryBean.setNotValid(true);
                    error = true;
                    this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.CreditEntry.creditAmount.equal.zero", (String[])new String[]{Integer.toString(i + 1)}), model);
                } else if (creditEntryBean.getCreditAmountWithVat().compareTo(creditEntryBean.getCreditEntry().getOpenAmount()) > 0) {
                    creditEntryBean.setNotValid(true);
                    error = true;
                    this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.CreditEntry.exceeded.openAmount", (String[])new String[]{Integer.toString(i + 1)}), model);
                } else {
                    creditEntryBean.setNotValid(false);
                }
                if (creditEntryBean.isNotValid()) continue;
                creditSum = creditSum.add(creditEntryBean.getCreditAmountWithVat());
                continue;
            }
            creditEntryBean.setNotValid(false);
        }
        if (bean.isReimbursementNote() && creditSum.compareTo(debitSum) < 0) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.SettlementNote.positive.payment.value", (String[])new String[0]), model);
        }
        if (!bean.isReimbursementNote() && creditSum.compareTo(debitSum) > 0) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.SettlementNote.negative.payment.value", (String[])new String[0]), model);
        }
        if (bean.isReimbursementNote() && creditSum.compareTo(BigDecimal.ZERO) == 0) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.CreditEntry.no.creditEntries.selected", (String[])new String[0]), model);
        }
        if (!bean.isReimbursementNote() && !bean.isAdvancePayment() && debitSum.compareTo(BigDecimal.ZERO) == 0) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.DebiEntry.no.debitEntries.selected", (String[])new String[0]), model);
        }
        if (bean.getDate().isAfter((ReadablePartial)new LocalDate())) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.SettlementNote.date.is.after", (String[])new String[0]), model);
        }
        if (bean.getDocNumSeries() == null) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.SettlementNote.need.documentSeries", (String[])new String[0]), model);
        }
        if (bean.getReferencedCustomers().size() > 1) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.SettlementNote.referencedCustomers.only.one.allowed", (String[])new String[0]), model);
        }
        if (!error && bean.isReimbursementNote() && bean.getCreditEntries().stream().filter(ce -> ce.isIncluded()).count() != 1L) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.SettlementNote.reimbursement.supports.only.one.settlement.entry", (String[])new String[0]), model);
        }
        if (!bean.isReimbursementNote() && !bean.checkAdvancePaymentCreditsWithPaymentDate()) {
            SettlementNote settlementNote = (SettlementNote)bean.getLastPaidAdvancedCreditSettlementNote().get();
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.SettlementNote.advancedPaymentCredit.originSettlementNote.payment.date.after", (String[])new String[]{settlementNote.getAdvancedPaymentCreditNote().getUiDocumentNumber(), settlementNote.getPaymentDate().toLocalDate().toString("yyyy-MM-dd")}), model);
        }
        try {
            SettlementNote.checkMixingOfInvoiceEntriesExportedInLegacyERP((Set)invoiceEntriesSet);
        }
        catch (TreasuryDomainException e) {
            error = true;
            this.addErrorMessage(e.getLocalizedMessage(), model);
        }
        if (error) {
            this.setSettlementNoteBean(bean, model);
            return "treasury/document/managepayments/settlementnote/chooseInvoiceEntries";
        }
        bean.calculateInterestDebitEntries();
        if (bean.getInterestEntries().size() == 0) {
            return this.calculateInterest(bean, model);
        }
        this.setSettlementNoteBean(bean, model);
        return "treasury/document/managepayments/settlementnote/calculateInterest";
    }

    @RequestMapping(value={"/calculateInterest/"}, method={RequestMethod.POST})
    public String calculateInterest(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model) {
        try {
            this.assertUserIsAllowToModifySettlements(bean.getDebtAccount().getFinantialInstitution(), model);
            SettlementNote.checkMixingOfInvoiceEntriesExportedInLegacyERP((List)bean.getIncludedInvoiceEntryBeans());
            for (SettlementNoteBean.DebitEntryBean debitEntryBean : bean.getDebitEntries()) {
                if (!debitEntryBean.isIncluded() || debitEntryBean.getDebitEntry().getFinantialDocument() != null) continue;
                this.setSettlementNoteBean(bean, model);
                return "treasury/document/managepayments/settlementnote/createDebitNote";
            }
            for (SettlementNoteBean.InterestEntryBean interestEntryBean : bean.getInterestEntries()) {
                if (!interestEntryBean.isIncluded()) continue;
                this.setSettlementNoteBean(bean, model);
                return "treasury/document/managepayments/settlementnote/createDebitNote";
            }
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(tde.getLocalizedMessage(), model);
            this.setSettlementNoteBean(bean, model);
            return "treasury/document/managepayments/settlementnote/calculateInterest";
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            this.setSettlementNoteBean(bean, model);
            return "treasury/document/managepayments/settlementnote/calculateInterest";
        }
        return this.createDebitNote(bean, model);
    }

    @RequestMapping(value={"/createDebitNote/"}, method={RequestMethod.POST})
    public String createDebitNote(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model) {
        if (!bean.isAdvancePayment() && bean.getDebtAmountWithVat().compareTo(BigDecimal.ZERO) == 0) {
            return this.insertPayment(bean, model);
        }
        this.setSettlementNoteBean(bean, model);
        if (bean.isReimbursementWithCompensation()) {
            return "treasury/document/managepayments/settlementnote/reimbursementWithCompensation";
        }
        return "treasury/document/managepayments/settlementnote/insertPayment";
    }

    @RequestMapping(value={"/continueToInsertPayment/"}, method={RequestMethod.POST})
    public String continueToInsertPayment(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model) {
        this.setSettlementNoteBean(bean, model);
        return "treasury/document/managepayments/settlementnote/insertPayment";
    }

    @RequestMapping(value={"/insertpayment/"}, method={RequestMethod.POST})
    public String insertPayment(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model) {
        String errorMessage;
        this.assertUserIsAllowToModifySettlements(bean.getDebtAccount().getFinantialInstitution(), model);
        BigDecimal debitSum = bean.isReimbursementNote() ? bean.getDebtAmountWithVat().negate() : bean.getDebtAmountWithVat();
        BigDecimal paymentSum = bean.getPaymentAmount();
        boolean error = false;
        if (bean.getPaymentEntries().size() > 1) {
            error = true;
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.SettlementNote.only.one.payment.method.is.supported", (String[])new String[0]), model);
        }
        if (bean.getPaymentEntries().stream().anyMatch(peb -> TreasuryConstants.isZero((BigDecimal)peb.getPaymentAmount()))) {
            error = true;
            errorMessage = bean.isReimbursementNote() ? "error.SettlementNote.reimbursement.equal.zero" : "error.SettlementNote.payment.equal.zero";
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)errorMessage, (String[])new String[0]), model);
        }
        if (bean.isAdvancePayment() && TreasuryConstants.isLessThan((BigDecimal)paymentSum, (BigDecimal)debitSum)) {
            error = true;
            errorMessage = bean.isReimbursementNote() ? "error.SettlementNote.no.match.reimbursement.credit" : "error.SettlementNote.no.match.payment.debit";
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)errorMessage, (String[])new String[0]), model);
        } else if (!bean.isAdvancePayment() && !TreasuryConstants.isEqual((BigDecimal)paymentSum, (BigDecimal)debitSum)) {
            error = true;
            errorMessage = bean.isReimbursementNote() ? "error.SettlementNote.no.match.reimbursement.credit" : "error.SettlementNote.no.match.payment.debit";
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)errorMessage, (String[])new String[0]), model);
        }
        if (error) {
            this.setSettlementNoteBean(bean, model);
            return "treasury/document/managepayments/settlementnote/insertPayment";
        }
        this.setSettlementNoteBean(bean, model);
        return "treasury/document/managepayments/settlementnote/summary";
    }

    @RequestMapping(value={"/summary/"}, method={RequestMethod.POST})
    public String summary(@RequestParam(value="bean", required=true) SettlementNoteBean bean, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsAllowToModifySettlements(bean.getDebtAccount().getFinantialInstitution(), model);
            SettlementNote settlementNote = SettlementNote.createSettlementNote((SettlementNoteBean)bean);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.SettlementNote.create.success", (String[])new String[0]), model);
            return this.redirect(READ_URL + settlementNote.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(tde.getLocalizedMessage(), model);
            this.setSettlementNoteBean(bean, model);
            return "treasury/document/managepayments/settlementnote/summary";
        }
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="debtaccount", required=false) DebtAccount debtAccount, @RequestParam(value="documentnumber", required=false) String documentNumber, @RequestParam(value="documentdatefrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDateFrom, @RequestParam(value="documentdateto", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDateTo, @RequestParam(value="origindocumentnumber", required=false) String originDocumentNumber, @RequestParam(value="state", required=false) FinantialDocumentStateType state, Model model) {
        List<SettlementNote> result = this.filterSearch(debtAccount, documentNumber, documentDateFrom, documentDateTo, originDocumentNumber, state);
        model.addAttribute("limit_exceeded", (Object)((long)result.size() > 500L ? 1 : 0));
        model.addAttribute("searchsettlementnoteResultsDataSet_totalCount", (Object)result.size());
        model.addAttribute("searchsettlementnoteResultsDataSet", result.stream().limit(500L).collect(Collectors.toList()));
        model.addAttribute("stateValues", (Object)FinantialDocumentStateType.findAll());
        return "treasury/document/managepayments/settlementnote/search";
    }

    private static List<SettlementNote> getSearchUniverse(DebtAccount debtAccount) {
        Stream result = debtAccount == null ? SettlementNote.findAll() : SettlementNote.findByDebtAccount((DebtAccount)debtAccount);
        return result.collect(Collectors.toList());
    }

    private List<SettlementNote> filterSearch(DebtAccount debtAccount, String documentNumber, LocalDate documentDateFrom, LocalDate documentDateTo, String originDocumentNumber, FinantialDocumentStateType state) {
        ArrayList result = Lists.newArrayList();
        boolean filter = false;
        Predicate<SettlementNote> predicate = i -> FinantialDocumentType.findForSettlementNote() == i.getFinantialDocumentType() || FinantialDocumentType.findForReimbursementNote() == i.getFinantialDocumentType();
        if (debtAccount != null) {
            filter = true;
        }
        if (!Strings.isNullOrEmpty((String)documentNumber)) {
            filter = true;
            predicate = predicate.and(i -> !Strings.isNullOrEmpty((String)i.getDocumentNumber()) && i.getUiDocumentNumber().toLowerCase().contains(documentNumber.toLowerCase()));
        }
        if (documentDateFrom != null) {
            filter = true;
            predicate = predicate.and(i -> i.getDocumentDate().toLocalDate().isEqual((ReadablePartial)documentDateFrom) || i.getDocumentDate().toLocalDate().isAfter((ReadablePartial)documentDateFrom));
        }
        if (documentDateTo != null) {
            filter = true;
            predicate = predicate.and(i -> i.getDocumentDate().toLocalDate().isEqual((ReadablePartial)documentDateTo) || i.getDocumentDate().toLocalDate().isBefore((ReadablePartial)documentDateTo));
        }
        if (!StringUtils.isEmpty((Object)originDocumentNumber)) {
            filter = true;
            predicate = predicate.and(i -> !StringUtils.isEmpty((Object)i.getOriginDocumentNumber()) && i.getOriginDocumentNumber().toLowerCase().contains(originDocumentNumber.trim().toLowerCase()));
        }
        if (state != null) {
            filter = true;
            predicate = predicate.and(i -> state == i.getState());
        }
        if (filter) {
            SettlementNoteController.getSearchUniverse(debtAccount).stream().filter(predicate).collect(Collectors.toCollection(() -> result));
        }
        return result;
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") SettlementNote settlementNote, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + settlementNote.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") SettlementNote settlementNote, Model model) {
        this.setSettlementNote(settlementNote, model);
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        boolean allowToConditionallyAnnulSettlementNote = TreasuryAccessControlAPI.isAllowToConditionallyAnnulSettlementNote((String)loggedUsername, (SettlementNote)settlementNote);
        boolean allowToAnnulSettlementNoteWithoutAnyRestriction = TreasuryAccessControlAPI.isAllowToAnnulSettlementNoteWithoutAnyRestriction((String)loggedUsername, (SettlementNote)settlementNote);
        model.addAttribute("allowToConditionallyAnnulSettlementNote", (Object)allowToConditionallyAnnulSettlementNote);
        model.addAttribute("allowToAnnulSettlementNoteWithoutAnyRestriction", (Object)allowToAnnulSettlementNoteWithoutAnyRestriction);
        return "treasury/document/managepayments/settlementnote/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") SettlementNote settlementNote, Model model, RedirectAttributes redirectAttributes) {
        this.setSettlementNote(settlementNote, model);
        try {
            DebtAccount debtAccount = settlementNote.getDebtAccount();
            this.assertUserIsAllowToModifySettlements(debtAccount.getFinantialInstitution(), model);
            this.deleteSettlementNote(settlementNote);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + debtAccount.getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getSettlementNote(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") SettlementNote settlementNote, Model model) {
        model.addAttribute("SettlementNote_finantialDocumentType_options", (Object)FinantialDocumentType.findAll());
        model.addAttribute("SettlementNote_debtAccount_options", new ArrayList());
        model.addAttribute("SettlementNote_documentNumberSeries_options", (Object)DocumentNumberSeries.findAll());
        model.addAttribute("SettlementNote_currency_options", (Object)Currency.findAll());
        model.addAttribute("stateValues", (Object)FinantialDocumentStateType.values());
        this.setSettlementNote(settlementNote, model);
        return "treasury/document/managepayments/settlementnote/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") SettlementNote settlementNote, @RequestParam(value="origindocumentnumber", required=false) String originDocumentNumber, @RequestParam(value="documentobservations", required=false) String documentObservations, Model model, RedirectAttributes redirectAttributes) {
        this.setSettlementNote(settlementNote, model);
        try {
            this.assertUserIsAllowToModifySettlements(settlementNote.getDebtAccount().getFinantialInstitution(), model);
            this.getSettlementNote(model).updateSettlementNote(originDocumentNumber, documentObservations);
            return this.redirect(READ_URL + this.getSettlementNote(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(settlementNote, model);
    }

    @RequestMapping(value={"/read/{oid}/anullsettlement"}, method={RequestMethod.POST})
    public String processReadToAnullSettlementNote(@PathVariable(value="oid") SettlementNote settlementNote, @RequestParam(value="anullReason") String anullReason, Model model, RedirectAttributes redirectAttributes) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        this.setSettlementNote(settlementNote, model);
        try {
            if (settlementNote.isReimbursement()) {
                throw new TreasuryDomainException("error.SettlementNote.reimbursement.must.be.rejected.in.erp", new String[0]);
            }
            this.assertUserIsAllowToAnnulSettlementNote(settlementNote, model);
            anullReason = anullReason + " - [" + loggedUsername + "] " + new DateTime().toString("YYYY-MM-dd HH:mm");
            settlementNote.anullDocument(anullReason, true);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.document.managepayments.SettlementNote.document.anulled.sucess", (String[])new String[0]), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getSettlementNote(model).getExternalId(), model, redirectAttributes);
    }

    protected void assertUserIsAllowToAnnulSettlementNote(SettlementNote settlementNote, Model model) {
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        if (TreasuryAccessControlAPI.isAllowToConditionallyAnnulSettlementNote((String)loggedUsername, (SettlementNote)settlementNote)) {
            return;
        }
        if (TreasuryAccessControlAPI.isAllowToAnnulSettlementNoteWithoutAnyRestriction((String)loggedUsername, (SettlementNote)settlementNote)) {
            return;
        }
        this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.annul.settlements", (String[])new String[0]), model);
        throw new SecurityException(TreasuryConstants.treasuryBundle((String)"error.authorization.not.allow.to.annul.settlements", (String[])new String[0]));
    }

    @RequestMapping(value={"/read/{oid}/exportintegrationfile"}, produces={"text/xml;charset=Windows-1252"})
    public void processReadToExportIntegrationFile(@PathVariable(value="oid") SettlementNote settlementNote, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            this.assertUserIsFrontOfficeMember(settlementNote.getDebtAccount().getFinantialInstitution(), model);
            String saftEncoding = ERPExporterManager.saftEncoding((FinantialInstitution)settlementNote.getDebtAccount().getFinantialInstitution());
            String output = ERPExporterManager.exportFinantialDocumentToXML((FinantialDocument)settlementNote);
            response.setContentType("text/xml");
            response.setCharacterEncoding(saftEncoding);
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)(settlementNote.getDebtAccount().getFinantialInstitution().getFiscalNumber() + "_" + settlementNote.getUiDocumentNumber() + ".xml").replaceAll(SEARCH_URI, "_").replaceAll("\\s", "_").replaceAll(" ", "_")), saftEncoding);
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(output.getBytes(saftEncoding));
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            try {
                response.sendRedirect(this.redirect(READ_URL + settlementNote.getExternalId(), model, redirectAttributes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @RequestMapping(value={"/read/{oid}/printdocument"}, produces={"application/pdf"})
    public Object processReadToPrintDocument(@PathVariable(value="oid") SettlementNote settlementNote, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            this.assertUserIsFrontOfficeMember(settlementNote.getDebtAccount().getFinantialInstitution(), model);
            byte[] report = DocumentPrinter.printFinantialDocument((FinantialDocument)settlementNote, (String)"application/pdf");
            return new ResponseEntity((Object)report, HttpStatus.OK);
        }
        catch (ReportGenerationException rex) {
            this.addErrorMessage(rex.getLocalizedMessage(), model);
            this.addErrorMessage(rex.getCause().getLocalizedMessage(), model);
            return this.redirect(READ_URL + settlementNote.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
            return this.redirect(READ_URL + settlementNote.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/read/{oid}/closesettlementnote"}, method={RequestMethod.POST})
    public String processReadToCloseSettlementtNote(@PathVariable(value="oid") SettlementNote settlementNote, Model model, RedirectAttributes redirectAttributes) {
        this.setSettlementNote(settlementNote, model);
        try {
            this.assertUserIsFrontOfficeMember(settlementNote.getDebtAccount().getFinantialInstitution(), model);
            settlementNote.closeDocument();
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.document.manageinvoice.Settlement.document.closed.sucess", (String[])new String[0]), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getSettlementNote(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/transactions/summary/"}, method={RequestMethod.GET})
    public String processSearchToTransactionsSummary(Model model) {
        model.addAttribute("finantial_institutions_options", FinantialInstitution.findAll().collect(Collectors.toList()));
        return "treasury/document/managepayments/settlementnote/transactionsSummary";
    }

    @RequestMapping(value={"/transactions/summary/"}, method={RequestMethod.POST})
    public String processSearchToTransactionsSummary(@RequestParam(value="finantialInstitution", required=true) FinantialInstitution finantialInstitution, @RequestParam(value="documentdatefrom", required=true) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDateFrom, @RequestParam(value="documentdateto", required=true) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate documentDateTo, Model model) {
        List<SettlementNote> notes = this.filterSearchSettlementNote(finantialInstitution, documentDateFrom, documentDateTo, false);
        model.addAttribute("settlementEntriesDataSet", this.getSettlementEntriesDataSet(notes));
        model.addAttribute("advancedPaymentEntriesDataSet", this.getAdvancedPaymentEntriesDataSet(notes));
        model.addAttribute("advancedPaymentTotal", (Object)this.getAdvancedPaymentTotal(notes));
        model.addAttribute("finantialInstitution", (Object)finantialInstitution);
        this.populateSummaryTransactions(model, notes, documentDateFrom, documentDateTo);
        model.addAttribute("finantial_institutions_options", FinantialInstitution.findAll().collect(Collectors.toList()));
        return "treasury/document/managepayments/settlementnote/transactionsSummary";
    }

    private BigDecimal getAdvancedPaymentTotal(List<SettlementNote> notes) {
        BigDecimal val = BigDecimal.ZERO;
        for (SettlementNote note : notes) {
            if (note.getAdvancedPaymentCreditNote() == null) continue;
            val = val.add(note.getAdvancedPaymentCreditNote().getTotalAmount());
        }
        return val;
    }

    private List<CreditNote> getAdvancedPaymentEntriesDataSet(List<SettlementNote> notes) {
        ArrayList<AdvancedPaymentCreditNote> val = new ArrayList<AdvancedPaymentCreditNote>();
        for (SettlementNote note : notes) {
            if (note.getAdvancedPaymentCreditNote() == null) continue;
            val.add(note.getAdvancedPaymentCreditNote());
        }
        return val.stream().sorted((x, y) -> x.getDocumentDate().compareTo((ReadableInstant)y.getDocumentDate())).collect(Collectors.toList());
    }

    private void populateSummaryTransactions(Model model, List<SettlementNote> notes, LocalDate beginDate, LocalDate endDate) {
        Map<PaymentMethod, BigDecimal> payments = this.getPaymentEntriesDataSet(notes).stream().collect(Collectors.groupingBy(PaymentEntry_Base::getPaymentMethod, Collectors.reducing(BigDecimal.ZERO, PaymentEntry_Base::getPayedAmount, BigDecimal::add)));
        Map<PaymentMethod, BigDecimal> reimbursements = this.getReimbursementEntriesDataSet(notes).stream().collect(Collectors.groupingBy(ReimbursementEntry_Base::getPaymentMethod, Collectors.reducing(BigDecimal.ZERO, ReimbursementEntry_Base::getReimbursedAmount, BigDecimal::add)));
        Map<PaymentMethod, BigDecimal> paymentsOutOfTimeWindow = this.getPaymentEntriesDataSet(notes).stream().filter(x -> x.getSettlementNote().getPaymentDate().toLocalDate().isBefore((ReadablePartial)beginDate)).collect(Collectors.groupingBy(PaymentEntry_Base::getPaymentMethod, Collectors.reducing(BigDecimal.ZERO, PaymentEntry_Base::getPayedAmount, BigDecimal::add)));
        Map<PaymentMethod, BigDecimal> reimbursementsOutOfTimeWindow = this.getReimbursementEntriesDataSet(notes).stream().filter(x -> x.getSettlementNote().getPaymentDate().toLocalDate().isBefore((ReadablePartial)beginDate)).collect(Collectors.groupingBy(ReimbursementEntry_Base::getPaymentMethod, Collectors.reducing(BigDecimal.ZERO, ReimbursementEntry_Base::getReimbursedAmount, BigDecimal::add)));
        PaymentMethod.findAll().forEach(pm -> {
            if (payments.get(pm) == null) {
                payments.put((PaymentMethod)pm, BigDecimal.ZERO);
            }
            if (reimbursements.get(pm) == null) {
                reimbursements.put((PaymentMethod)pm, BigDecimal.ZERO);
            }
        });
        model.addAttribute("paymentsDataSet", payments);
        model.addAttribute("paymentsOutOfTimeWindowDataSet", paymentsOutOfTimeWindow);
        model.addAttribute("reimbursementsDataSet", reimbursements);
        model.addAttribute("reimbursementsOutOfTimeWindowDataSet", reimbursementsOutOfTimeWindow);
    }

    private List<SettlementNote> filterSearchSettlementNote(FinantialInstitution finantialInstitution, LocalDate documentDateFrom, LocalDate documentDateTo, boolean filterInternalSeriesOnly) {
        Stream<SettlementNote> streamFilter = SettlementNote.findAll().filter(note -> note.isClosed()).filter(note -> note.getDebtAccount().getFinantialInstitution().equals((Object)finantialInstitution)).filter(note -> note.getDocumentDate().toLocalDate().isAfter((ReadablePartial)documentDateFrom) || note.getDocumentDate().toLocalDate().isEqual((ReadablePartial)documentDateFrom)).filter(note -> note.getDocumentDate().toLocalDate().isBefore((ReadablePartial)documentDateTo) || note.getDocumentDate().toLocalDate().isEqual((ReadablePartial)documentDateTo));
        if (filterInternalSeriesOnly) {
            streamFilter = streamFilter.filter(note -> !note.getDocumentNumberSeries().getSeries().getExternSeries() && !note.getDocumentNumberSeries().getSeries().getLegacy());
        }
        return streamFilter.collect(Collectors.toList());
    }

    private List<SettlementEntry> getSettlementEntriesDataSet(List<SettlementNote> notes) {
        return notes.stream().filter(x -> TreasuryConstants.isPositive((BigDecimal)x.getTotalPayedAmount()) || TreasuryConstants.isPositive((BigDecimal)x.getTotalReimbursementAmount())).map(note -> note.getSettlemetEntries().collect(Collectors.toList())).reduce(new ArrayList(), (t, u) -> {
            t.addAll(u);
            return t;
        });
    }

    private List<PaymentEntry> getPaymentEntriesDataSet(List<SettlementNote> notes) {
        return notes.stream().map(note -> note.getPaymentEntriesSet().stream().collect(Collectors.toList())).reduce(new ArrayList(), (t, u) -> {
            t.addAll(u);
            return t;
        });
    }

    private List<ReimbursementEntry> getReimbursementEntriesDataSet(List<SettlementNote> notes) {
        return notes.stream().map(note -> note.getReimbursementEntriesSet().stream().collect(Collectors.toList())).reduce(new ArrayList(), (t, u) -> {
            t.addAll(u);
            return t;
        });
    }

    @RequestMapping(value={"/read/{oid}/exportintegrationonline"})
    public String processReadToExportIntegrationOnline(@PathVariable(value="oid") SettlementNote settlementNote, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(settlementNote.getDebtAccount().getFinantialInstitution(), model);
            try {
                IERPExporter erpExporter = settlementNote.getDebtAccount().getFinantialInstitution().getErpIntegrationConfiguration().getERPExternalServiceImplementation().getERPExporter();
                erpExporter.checkIntegrationDocumentStatus((FinantialDocument)settlementNote);
            }
            catch (Exception erpExporter) {
                // empty catch block
            }
            ERPExportOperation output = ERPExporterManager.exportSettlementNote((SettlementNote)settlementNote);
            if (output == null) {
                this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.integration.erp.document.not.exported", (String[])new String[0]), model);
                return this.read(settlementNote, model);
            }
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.integration.erp.exportoperation.success", (String[])new String[0]), model);
            return this.redirect("/treasury/integration/erp/erpexportoperation/read/" + output.getExternalId(), model, redirectAttributes);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.integration.erp.exportoperation.error", (String[])new String[0]) + ex.getLocalizedMessage(), model);
            return this.read(settlementNote, model);
        }
    }

    @RequestMapping(value={"/read/{oid}/cleardocumenttoexport"}, method={RequestMethod.POST})
    public String cleardocumenttoexport(@PathVariable(value="oid") SettlementNote settlementNote, @RequestParam(value="reason", required=false) String reason, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (!settlementNote.isDocumentToExport()) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.FinantialDocument.document.not.marked.to.export", (String[])new String[0]), model);
                return this.redirect(READ_URL + settlementNote.getExternalId(), model, redirectAttributes);
            }
            if (Strings.isNullOrEmpty((String)reason)) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.FinantialDocument.clear.document.to.export.requires.reason", (String[])new String[0]), model);
                return this.redirect(READ_URL + settlementNote.getExternalId(), model, redirectAttributes);
            }
            this.assertUserIsBackOfficeMember(model);
            settlementNote.clearDocumentToExport(reason);
            return this.redirect(READ_URL + settlementNote.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.redirect(READ_URL + settlementNote.getExternalId(), model, redirectAttributes);
        }
    }

    @RequestMapping(value={"/downloadcertifieddocumentprint/{oid}"}, method={RequestMethod.GET})
    public String downloadcertifieddocumentprint(@PathVariable(value="oid") SettlementNote settlementNote, Model model, RedirectAttributes redirectAttributes, HttpServletResponse response) {
        try {
            byte[] contents = ERPExporterManager.downloadCertifiedDocumentPrint((FinantialDocument)settlementNote);
            response.setContentType("application/pdf");
            String filename = URLEncoder.encode(StringNormalizer.normalizePreservingCapitalizedLetters((String)(settlementNote.getDebtAccount().getFinantialInstitution().getFiscalNumber() + "_" + settlementNote.getUiDocumentNumber() + ".pdf").replaceAll(SEARCH_URI, "_").replaceAll("\\s", "_").replaceAll(" ", "_")), "Windows-1252");
            response.setHeader("Content-disposition", "attachment; filename=" + filename);
            response.getOutputStream().write(contents);
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.read(settlementNote, model);
        }
    }

    @RequestMapping(value={"/updatereimbursementstate/{oid}"}, method={RequestMethod.POST})
    public String updatereimbursementstate(@PathVariable(value="oid") SettlementNote settlementNote, Model model, RedirectAttributes redirectAttributes) {
        try {
            ERPExporterManager.updateReimbursementState((SettlementNote)settlementNote);
            return this.redirect(READ_URL + settlementNote.getExternalId(), model, redirectAttributes);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.read(settlementNote, model);
        }
    }
}

