/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.document.manageinvoice;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.VatType;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.tariff.FixedTariff;
import org.fenixedu.treasury.domain.tariff.Tariff;
import org.fenixedu.treasury.dto.CreditEntryBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.document.manageinvoice.CreditEntryController$callable$createCreditEntry;
import org.fenixedu.treasury.ui.document.manageinvoice.CreditEntryController$callable$updateCreditEntry;
import org.fenixedu.treasury.ui.document.manageinvoice.CreditNoteController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@BennuSpringController(value=CreditNoteController.class)
@RequestMapping(value={"/treasury/document/manageinvoice/creditentry"})
public class CreditEntryController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/document/manageinvoice/creditentry";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/document/manageinvoice/creditentry/create";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/document/manageinvoice/creditentry/read/";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/document/manageinvoice/creditentry/update/";
    public static final Advice advice$createCreditEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updateCreditEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/document/manageinvoice/creditentry/";
    }

    private CreditEntry getCreditEntryBean(Model model) {
        return (CreditEntry)model.asMap().get("creditEntryBean");
    }

    private void setCreditEntryBean(CreditEntryBean bean, Model model) {
        model.addAttribute("creditEntryBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        model.addAttribute("creditEntryBean", (Object)bean);
    }

    private CreditEntry getCreditEntry(Model model) {
        return (CreditEntry)model.asMap().get("creditEntry");
    }

    private void setCreditEntry(CreditEntry creditEntry, Model model) {
        model.addAttribute("creditEntry", (Object)creditEntry);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(@RequestParam(value="creditnote") CreditNote creditNote, Model model, RedirectAttributes redirectAttributes) {
        try {
            DebtAccount debtAccount = creditNote.getDebtAccount();
            if (creditNote != null && !creditNote.isPreparing()) {
                this.addWarningMessage(TreasuryConstants.treasuryBundle((String)"label.error.document.manageinvoice.creditentry.invalid.state.add.creditentry", (String[])new String[0]), model);
                this.redirect("/treasury/document/manageinvoice/creditnote/read/" + creditNote.getExternalId(), model, redirectAttributes);
            }
            this.assertUserIsAllowToModifyInvoices(debtAccount.getFinantialInstitution(), model);
            CreditEntryBean bean = new CreditEntryBean();
            bean.setProductDataSource(Product.findAllActive().collect(Collectors.toList()));
            bean.setDebtAccount(debtAccount);
            bean.setFinantialDocument(creditNote);
            bean.setCurrency(debtAccount.getFinantialInstitution().getCurrency());
            this.setCreditEntryBean(bean, model);
        }
        catch (Exception ex) {
            this.addErrorMessage(ex.getLocalizedMessage(), model);
        }
        return "treasury/document/manageinvoice/creditentry/create";
    }

    @RequestMapping(value={"/createpostback"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createpostback(@RequestParam(value="bean", required=true) CreditEntryBean bean, Model model) {
        Product product = bean.getProduct();
        if (product != null) {
            bean.setVat(bean.getDebtAccount().getFinantialInstitution().getActiveVat(product.getVatType(), new DateTime()));
            Tariff tariff = product.getActiveTariffs(bean.getDebtAccount().getFinantialInstitution(), new DateTime()).findFirst().orElse(null);
            if (tariff != null) {
                bean.setTariff(tariff);
                if (tariff instanceof FixedTariff) {
                    bean.setAmount(bean.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(((FixedTariff)tariff).getAmount()));
                } else {
                    bean.setAmount(bean.getDebtAccount().getFinantialInstitution().getCurrency().getValueWithScale(BigDecimal.ZERO));
                }
            } else {
                return new ResponseEntity((Object)TreasuryConstants.treasuryBundle((String)"label.Tariff.no.valid.fixed", (String[])new String[0]), HttpStatus.BAD_REQUEST);
            }
            bean.setDescription(product.getName().getContent());
        }
        return new ResponseEntity((Object)this.getBeanJson((ITreasuryBean)bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/create{oid}"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="bean", required=false) CreditEntryBean bean, @PathVariable(value="oid") DebtAccount debtAccount, Model model, RedirectAttributes redirectAttributes) {
        try {
            if (bean.getFinantialDocument() != null && !bean.getFinantialDocument().isPreparing()) {
                this.addWarningMessage(BundleUtil.getString((String)"resources.FenixeduTreasuryResources", (String)"label.error.document.manageinvoice.creditentry.invalid.state.add.creditentry", (String[])new String[0]), model);
                this.redirect("/treasury/document/manageinvoice/creditnote/read/" + bean.getFinantialDocument().getExternalId(), model, redirectAttributes);
            }
            if (debtAccount == null) {
                debtAccount = bean.getDebtAccount();
            }
            this.assertUserIsAllowToModifyInvoices(debtAccount.getFinantialInstitution(), model);
            CreditEntry creditEntry = this.createCreditEntry(bean.getFinantialDocument(), bean.getDebtAccount(), bean.getDescription(), bean.getProduct(), bean.getAmount(), bean.getFinantialDocument().getDocumentDueDate());
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.create", (String[])new String[0]), model);
            this.setCreditEntry(creditEntry, model);
            if (this.getCreditEntry(model).getFinantialDocument() != null) {
                return this.redirect("/treasury/document/manageinvoice/creditnote/read/" + this.getCreditEntry(model).getFinantialDocument().getExternalId(), model, redirectAttributes);
            }
            return this.redirect("/treasury/accounting/managecustomer/debtaccount/read/" + this.getCreditEntry(model).getDebtAccount().getExternalId(), model, redirectAttributes);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
            this.setCreditEntryBean(bean, model);
            return "treasury/document/manageinvoice/creditentry/create";
        }
    }

    public CreditEntry createCreditEntry(CreditNote creditNote, DebtAccount debtAccount, String string, Product product, BigDecimal bigDecimal, LocalDate localDate) {
        return (CreditEntry)advice$createCreditEntry.perform((Callable)new CreditEntryController$callable$createCreditEntry(this, creditNote, debtAccount, string, product, bigDecimal, localDate));
    }

    static /* synthetic */ CreditEntry advised$createCreditEntry(CreditEntryController this_, CreditNote creditNote, DebtAccount debtAccount, String description, Product product, BigDecimal amount, LocalDate dueDate) {
        Optional activeVat = Vat.findActiveUnique((VatType)product.getVatType(), (FinantialInstitution)debtAccount.getFinantialInstitution(), (DateTime)new DateTime());
        CreditEntry creditEntry = CreditEntry.create((FinantialDocument)creditNote, (String)description, (Product)product, (Vat)activeVat.orElse(null), (BigDecimal)amount, (DateTime)new DateTime(), null, (BigDecimal)BigDecimal.ONE);
        return creditEntry;
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") CreditEntry creditEntry, Model model) {
        this.setCreditEntry(creditEntry, model);
        return "treasury/document/manageinvoice/creditentry/read";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") CreditEntry creditEntry, Model model) {
        this.setCreditEntry(creditEntry, model);
        return "treasury/document/manageinvoice/creditentry/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") CreditEntry creditEntry, @RequestParam(value="description", required=true) String description, Model model, RedirectAttributes redirectAttributes) {
        this.setCreditEntry(creditEntry, model);
        try {
            this.assertUserIsAllowToModifyInvoices(creditEntry.getDebtAccount().getFinantialInstitution(), model);
            this.updateCreditEntry(description, model);
            return this.redirect("/treasury/document/manageinvoice/creditnote/read/" + this.getCreditEntry(model).getFinantialDocument().getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.update(creditEntry, model);
    }

    public void updateCreditEntry(String string, Model model) {
        Object object = advice$updateCreditEntry.perform((Callable)new CreditEntryController$callable$updateCreditEntry(this, string, model));
    }

    static /* synthetic */ void advised$updateCreditEntry(CreditEntryController this_, String description, Model model) {
        this_.getCreditEntry(model).edit(description);
    }
}

