/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.tasks;

import com.google.common.base.Strings;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager;
import pt.ist.fenixframework.FenixFramework;

@Task(englishTitle="Export Single Doument to ERP Integration", readOnly=true)
public class ERPExportSingleDocumentsTask
extends CronTask {
    private String externalId;

    public ERPExportSingleDocumentsTask(String documentExternalId) {
        this.externalId = documentExternalId;
    }

    public void runTask() throws Exception {
        if (Strings.isNullOrEmpty((String)this.externalId)) {
            this.taskLog("External ID empty, not exporting any document", new Object[0]);
            return;
        }
        FinantialDocument document = (FinantialDocument)FenixFramework.getDomainObject((String)this.externalId);
        if (document == null) {
            return;
        }
        if (document.isPreparing()) {
            this.taskLog("Ignored, trying to export a PREPARING document, oid: " + this.externalId, new Object[0]);
            return;
        }
        if (document.isCreditNote()) {
            this.taskLog("Ignored, credit note is exported with settlement note, oid: " + this.externalId, new Object[0]);
            return;
        }
        FinantialInstitution finantialInstitution = document.getDocumentNumberSeries().getSeries().getFinantialInstitution();
        if (!finantialInstitution.getErpIntegrationConfiguration().getActive()) {
            return;
        }
        try {
            ERPExportOperation exportOperation = ERPExporterManager.exportSingleDocument((FinantialDocument)document);
            if (exportOperation == null) {
                return;
            }
            this.taskLog(String.format("Exported document: %s => %s", document.getUiDocumentNumber(), exportOperation.getSuccess() ? "OK" : "NOK"), new Object[0]);
        }
        catch (Exception ex) {
            this.taskLog("Error exporting document: " + ex.getMessage(), new Object[0]);
            for (StackTraceElement el : ex.getStackTrace()) {
                this.taskLog(el.toString(), new Object[0]);
            }
        }
    }
}

