/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.payments.sibs.managesibsconfiguration;

import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.SibsConfiguration;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.administration.managefinantialinstitution.FinantialInstitutionController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@BennuSpringController(value=FinantialInstitutionController.class)
@RequestMapping(value={"/treasury/administration/sibs/managesibsconfiguration/sibsconfiguration"})
public class SibsConfigurationController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/sibs/managesibsconfiguration/sibsconfiguration";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/sibs/managesibsconfiguration/sibsconfiguration/read/";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/sibs/managesibsconfiguration/sibsconfiguration/update/";

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/sibs/managesibsconfiguration/sibsconfiguration/";
    }

    private SibsConfiguration getSibsConfiguration(Model model) {
        return (SibsConfiguration)model.asMap().get("sibsConfiguration");
    }

    private void setSibsConfiguration(SibsConfiguration sibsConfiguration, Model model) {
        model.addAttribute("sibsConfiguration", (Object)sibsConfiguration);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") SibsConfiguration sibsConfiguration, Model model) {
        this.assertUserIsBackOfficeMember(sibsConfiguration.getFinantialInstitution(), model);
        this.setSibsConfiguration(sibsConfiguration, model);
        return "treasury/administration/payments/sibs/managesibsconfiguration/sibsconfiguration/read";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") SibsConfiguration sibsConfiguration, Model model) {
        this.assertUserIsBackOfficeMember(sibsConfiguration.getFinantialInstitution(), model);
        this.setSibsConfiguration(sibsConfiguration, model);
        return "treasury/administration/payments/sibs/managesibsconfiguration/sibsconfiguration/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") SibsConfiguration sibsConfiguration, @RequestParam(value="entityreferencecode", required=false) String entityReferenceCode, @RequestParam(value="sourceinstitutionid", required=false) String sourceInstitutionId, @RequestParam(value="destinationinstitutionid", required=false) String destinationInstitutionId, @RequestParam(value="sibsPaymentsBrokerUrl", required=false) String sibsPaymentsBrokerUrl, @RequestParam(value="sibsPaymentsBrokerSharedKey", required=false) String sibsPaymentsBrokerSharedKey, Model model, RedirectAttributes redirectAttributes) {
        this.setSibsConfiguration(sibsConfiguration, model);
        try {
            this.assertUserIsFrontOfficeMember(sibsConfiguration.getFinantialInstitution(), model);
            this.assertUserIsBackOfficeMember(sibsConfiguration.getFinantialInstitution(), model);
            this.getSibsConfiguration(model).edit(entityReferenceCode, sourceInstitutionId, destinationInstitutionId, sibsPaymentsBrokerUrl, sibsPaymentsBrokerSharedKey);
            return this.redirect(READ_URL + this.getSibsConfiguration(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tde) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tde.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(sibsConfiguration, model);
    }
}

