/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.payments.sibs.managepaymentreferencecode;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCodeStateType;
import org.fenixedu.treasury.domain.paymentcodes.SibsTransactionDetail;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.payments.sibs.managepaymentreferencecode.PaymentReferenceCodeController$callable$createPaymentReferenceCode;
import org.fenixedu.treasury.ui.administration.payments.sibs.managepaymentreferencecode.PaymentReferenceCodeController$callable$deletePaymentReferenceCode;
import org.fenixedu.treasury.ui.administration.payments.sibs.managepaymentreferencecode.PaymentReferenceCodeController$callable$updatePaymentReferenceCode;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@Component(value="org.fenixedu.treasury.ui.administration.payments.sibs.managePaymentReferenceCode")
@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.payments.sibs.managePaymentReferenceCode", accessGroup="treasuryFrontOffice")
@RequestMapping(value={"/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode"})
public class PaymentReferenceCodeController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/search/view/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/read/";
    private static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/delete/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/create";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/update/";
    public static final Advice advice$deletePaymentReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$createPaymentReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$updatePaymentReferenceCode = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/";
    }

    private PaymentReferenceCode getPaymentReferenceCode(Model model) {
        return (PaymentReferenceCode)model.asMap().get("paymentReferenceCode");
    }

    private void setPaymentReferenceCode(PaymentReferenceCode paymentReferenceCode, Model model) {
        model.addAttribute("paymentReferenceCode", (Object)paymentReferenceCode);
    }

    public void deletePaymentReferenceCode(PaymentReferenceCode paymentReferenceCode) {
        Object object = advice$deletePaymentReferenceCode.perform((Callable)new PaymentReferenceCodeController$callable$deletePaymentReferenceCode(this, paymentReferenceCode));
    }

    static /* synthetic */ void advised$deletePaymentReferenceCode(PaymentReferenceCodeController this_, PaymentReferenceCode paymentReferenceCode) {
        paymentReferenceCode.delete();
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="referencecode", required=false) String referenceCode, @RequestParam(value="begindate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") DateTime beginDate, @RequestParam(value="enddate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") DateTime endDate, @RequestParam(value="state", required=false) PaymentReferenceCodeStateType state, Model model) {
        List<PaymentReferenceCode> searchpaymentreferencecodeResultsDataSet = this.filterSearchPaymentReferenceCode(referenceCode, beginDate, endDate, state);
        if (searchpaymentreferencecodeResultsDataSet.size() > 500) {
            searchpaymentreferencecodeResultsDataSet = searchpaymentreferencecodeResultsDataSet.subList(0, 499);
        }
        model.addAttribute("searchpaymentreferencecodeResultsDataSet", searchpaymentreferencecodeResultsDataSet);
        model.addAttribute("stateValues", (Object)PaymentReferenceCodeStateType.values());
        return "treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/search";
    }

    private Stream<PaymentReferenceCode> getSearchUniverseSearchPaymentReferenceCodeDataSet() {
        return PaymentReferenceCode.findAll();
    }

    private List<PaymentReferenceCode> filterSearchPaymentReferenceCode(String referenceCode, DateTime beginDate, DateTime endDate, PaymentReferenceCodeStateType state) {
        return this.getSearchUniverseSearchPaymentReferenceCodeDataSet().filter(paymentReferenceCode -> referenceCode == null || referenceCode.length() == 0 || paymentReferenceCode.getReferenceCode() != null && paymentReferenceCode.getReferenceCode().length() > 0 && paymentReferenceCode.getReferenceCode().toLowerCase().contains(referenceCode.toLowerCase())).filter(paymentReferenceCode -> beginDate == null || beginDate.equals((Object)paymentReferenceCode.getBeginDate())).filter(paymentReferenceCode -> endDate == null || endDate.equals((Object)paymentReferenceCode.getEndDate())).filter(paymentReferenceCode -> state == null || state.equals((Object)paymentReferenceCode.getState())).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") PaymentReferenceCode paymentReferenceCode, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + paymentReferenceCode.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") PaymentReferenceCode paymentReferenceCode, Model model) {
        this.setPaymentReferenceCode(paymentReferenceCode, model);
        model.addAttribute("sibsTransactionDetails", SibsTransactionDetail.findBySibsEntityAndReferenceCode((String)paymentReferenceCode.getPaymentCodePool().getEntityReferenceCode(), (String)paymentReferenceCode.getReferenceCode()).collect(Collectors.toSet()));
        return "treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") PaymentReferenceCode paymentReferenceCode, Model model, RedirectAttributes redirectAttributes) {
        this.setPaymentReferenceCode(paymentReferenceCode, model);
        try {
            this.assertUserIsFrontOfficeMember(paymentReferenceCode.getPaymentCodePool().getFinantialInstitution(), model);
            this.assertUserIsBackOfficeMember(paymentReferenceCode.getPaymentCodePool().getFinantialInstitution(), model);
            this.deletePaymentReferenceCode(paymentReferenceCode);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + this.getPaymentReferenceCode(model).getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("stateValues", (Object)PaymentReferenceCodeStateType.values());
        return "treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="referencecode", required=false) String referenceCode, @RequestParam(value="begindate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate beginDate, @RequestParam(value="enddate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate endDate, @RequestParam(value="state", required=false) PaymentReferenceCodeStateType state, @RequestParam(value="paymentcodepool", required=false) PaymentCodePool pool, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsFrontOfficeMember(pool.getFinantialInstitution(), model);
            this.assertUserIsBackOfficeMember(pool.getFinantialInstitution(), model);
            PaymentReferenceCode paymentReferenceCode = this.createPaymentReferenceCode(referenceCode, beginDate, endDate, state, pool);
            model.addAttribute("paymentReferenceCode", (Object)paymentReferenceCode);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.create", (String[])new String[0]), model);
            return this.redirect(READ_URL + this.getPaymentReferenceCode(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    public PaymentReferenceCode createPaymentReferenceCode(String string, LocalDate localDate, LocalDate localDate2, PaymentReferenceCodeStateType paymentReferenceCodeStateType, PaymentCodePool paymentCodePool) {
        return (PaymentReferenceCode)advice$createPaymentReferenceCode.perform((Callable)new PaymentReferenceCodeController$callable$createPaymentReferenceCode(this, string, localDate, localDate2, paymentReferenceCodeStateType, paymentCodePool));
    }

    static /* synthetic */ PaymentReferenceCode advised$createPaymentReferenceCode(PaymentReferenceCodeController this_, String referenceCode, LocalDate beginDate, LocalDate endDate, PaymentReferenceCodeStateType state, PaymentCodePool pool) {
        PaymentReferenceCode paymentReferenceCode = PaymentReferenceCode.create((String)referenceCode, (LocalDate)beginDate, (LocalDate)endDate, (PaymentReferenceCodeStateType)state, (PaymentCodePool)pool, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
        return paymentReferenceCode;
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") PaymentReferenceCode paymentReferenceCode, Model model) {
        model.addAttribute("stateValues", (Object)PaymentReferenceCodeStateType.values());
        this.setPaymentReferenceCode(paymentReferenceCode, model);
        return "treasury/administration/payments/sibs/managepaymentreferencecode/paymentreferencecode/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") PaymentReferenceCode paymentReferenceCode, @RequestParam(value="referencecode", required=false) String referenceCode, @RequestParam(value="begindate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate beginDate, @RequestParam(value="enddate", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate endDate, @RequestParam(value="state", required=false) PaymentReferenceCodeStateType state, Model model, RedirectAttributes redirectAttributes) {
        this.setPaymentReferenceCode(paymentReferenceCode, model);
        try {
            this.assertUserIsFrontOfficeMember(paymentReferenceCode.getPaymentCodePool().getFinantialInstitution(), model);
            this.assertUserIsBackOfficeMember(paymentReferenceCode.getPaymentCodePool().getFinantialInstitution(), model);
            this.updatePaymentReferenceCode(referenceCode, beginDate, endDate, state, model);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.update", (String[])new String[0]), model);
            return this.redirect(READ_URL + this.getPaymentReferenceCode(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.update(paymentReferenceCode, model);
    }

    public void updatePaymentReferenceCode(String string, LocalDate localDate, LocalDate localDate2, PaymentReferenceCodeStateType paymentReferenceCodeStateType, Model model) {
        Object object = advice$updatePaymentReferenceCode.perform((Callable)new PaymentReferenceCodeController$callable$updatePaymentReferenceCode(this, string, localDate, localDate2, paymentReferenceCodeStateType, model));
    }

    static /* synthetic */ void advised$updatePaymentReferenceCode(PaymentReferenceCodeController this_, String referenceCode, LocalDate beginDate, LocalDate endDate, PaymentReferenceCodeStateType state, Model model) {
        this_.getPaymentReferenceCode(model).edit(referenceCode, beginDate, endDate, state);
    }

    @RequestMapping(value={"/read/{oid}/anull"}, method={RequestMethod.POST})
    public String processReadToAnull(@PathVariable(value="oid") PaymentReferenceCode paymentReferenceCode, Model model, RedirectAttributes redirectAttributes) {
        try {
            paymentReferenceCode.anullPaymentReferenceCode();
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.update", (String[])new String[0]), model);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return this.redirect(READ_URL + paymentReferenceCode.getExternalId(), model, redirectAttributes);
    }
}

