/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.administration.payments.sibs.managepaymentcodepool;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.PaymentMethod;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodeGeneratorInstance;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.administration.payments.sibs.managepaymentcodepool.PaymentCodePoolController$callable$deletePaymentCodePool;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.LocalDate;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.administration.payments.sibs.managePaymentCodePool", accessGroup="treasuryManagers")
@RequestMapping(value={"/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool"})
public class PaymentCodePoolController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool";
    private static final String _SEARCH_URI = "/";
    public static final String SEARCH_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/";
    private static final String _SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String SEARCH_TO_VIEW_ACTION_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/search/view/";
    private static final String _READ_URI = "/read/";
    public static final String READ_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/read/";
    private static final String _DELETE_URI = "/delete/";
    public static final String DELETE_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/delete/";
    private static final String _CREATE_URI = "/create";
    public static final String CREATE_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/create";
    private static final String _UPDATE_URI = "/update/";
    public static final String UPDATE_URL = "/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/update/";
    public static final Advice advice$deletePaymentCodePool = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/";
    }

    private PaymentCodePool getPaymentCodePool(Model model) {
        return (PaymentCodePool)model.asMap().get("paymentCodePool");
    }

    private void setPaymentCodePool(PaymentCodePool paymentCodePool, Model model) {
        model.addAttribute("paymentCodePool", (Object)paymentCodePool);
    }

    public void deletePaymentCodePool(PaymentCodePool paymentCodePool) {
        Object object = advice$deletePaymentCodePool.perform((Callable)new PaymentCodePoolController$callable$deletePaymentCodePool(this, paymentCodePool));
    }

    static /* synthetic */ void advised$deletePaymentCodePool(PaymentCodePoolController this_, PaymentCodePool paymentCodePool) {
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="finantialinstitution", required=false) FinantialInstitution finantialInstitution, Model model) {
        List<PaymentCodePool> searchpaymentcodepoolResultsDataSet = this.filterSearchPaymentCodePool(finantialInstitution);
        model.addAttribute("searchpaymentcodepoolResultsDataSet", searchpaymentcodepoolResultsDataSet);
        model.addAttribute("PaymentCodePool_finantialInstitution_options", FinantialInstitution.findAll().collect(Collectors.toList()));
        return "treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/search";
    }

    private Stream<PaymentCodePool> getSearchUniverseSearchPaymentCodePoolDataSet() {
        return PaymentCodePool.findAll();
    }

    private List<PaymentCodePool> filterSearchPaymentCodePool(FinantialInstitution finantialInstitution) {
        return this.getSearchUniverseSearchPaymentCodePoolDataSet().filter(paymentCodePool -> finantialInstitution == null || finantialInstitution == paymentCodePool.getFinantialInstitution()).collect(Collectors.toList());
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") PaymentCodePool paymentCodePool, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + paymentCodePool.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") PaymentCodePool paymentCodePool, Model model) {
        this.setPaymentCodePool(paymentCodePool, model);
        return "treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/read";
    }

    @RequestMapping(value={"/delete/{oid}"}, method={RequestMethod.POST})
    public String delete(@PathVariable(value="oid") PaymentCodePool paymentCodePool, Model model, RedirectAttributes redirectAttributes) {
        this.setPaymentCodePool(paymentCodePool, model);
        try {
            this.assertUserIsManager(model);
            this.deletePaymentCodePool(paymentCodePool);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.success.delete", (String[])new String[0]), model);
            return this.redirect(SEARCH_URL, model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception ex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.delete", (String[])new String[0]) + ex.getLocalizedMessage(), model);
        }
        return "treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/read/" + this.getPaymentCodePool(model).getExternalId();
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.GET})
    public String create(Model model) {
        model.addAttribute("finantialInstitutionList", FinantialInstitution.findAll().collect(Collectors.toList()));
        model.addAttribute("PaymentCodePool_documentSeriesForPayments_options", DocumentNumberSeries.findAll().filter(x -> x.getFinantialDocumentType().equals((Object)FinantialDocumentType.findForSettlementNote())).filter(x -> x.getSeries().getActive()).collect(Collectors.toList()));
        model.addAttribute("PaymentCodePool_paymentCodeGeneratorInstance_options", PaymentCodeGeneratorInstance.findAll().collect(Collectors.toSet()));
        model.addAttribute("PaymentCodePool_paymentMethod_options", PaymentMethod.findAll().collect(Collectors.toList()));
        return "treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/create";
    }

    @RequestMapping(value={"/create"}, method={RequestMethod.POST})
    public String create(@RequestParam(value="finantialinstitution") FinantialInstitution finantialInstitution, @RequestParam(value="name") String name, @RequestParam(value="entityreferencecode", required=false) String entityReferenceCode, @RequestParam(value="minreferencecode", required=false) Long minReferenceCode, @RequestParam(value="maxreferencecode", required=false) Long maxReferenceCode, @RequestParam(value="minamount", required=false) BigDecimal minAmount, @RequestParam(value="maxamount", required=false) BigDecimal maxAmount, @RequestParam(value="validfrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate validFrom, @RequestParam(value="validto", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate validTo, @RequestParam(value="active", required=false) Boolean active, @RequestParam(value="usecheckdigit", required=false) Boolean useCheckDigit, @RequestParam(value="documentnumberseries") DocumentNumberSeries documentNumberSeries, @RequestParam(value="paymentmethod") PaymentMethod paymentMethod, @RequestParam(value="paymentcodegeneratorinstance") PaymentCodeGeneratorInstance paymentCodeGeneratorInstance, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.assertUserIsManager(model);
            PaymentCodePool paymentCodePool = PaymentCodePool.create((String)name, (String)entityReferenceCode, (Long)minReferenceCode, (Long)maxReferenceCode, (BigDecimal)minAmount, (BigDecimal)maxAmount, (LocalDate)validFrom, (LocalDate)validTo, (Boolean)active, (Boolean)useCheckDigit, (FinantialInstitution)finantialInstitution, (DocumentNumberSeries)documentNumberSeries, (PaymentMethod)paymentMethod, (PaymentCodeGeneratorInstance)paymentCodeGeneratorInstance);
            model.addAttribute("paymentCodePool", (Object)paymentCodePool);
            return this.redirect(READ_URL + this.getPaymentCodePool(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.create", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.create(model);
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.GET})
    public String update(@PathVariable(value="oid") PaymentCodePool paymentCodePool, Model model) {
        model.addAttribute("finantialInstitutionList", FinantialInstitution.findAll().collect(Collectors.toList()));
        model.addAttribute("PaymentCodePool_documentSeriesForPayments_options", DocumentNumberSeries.findAll().filter(x -> x.getFinantialDocumentType().equals((Object)FinantialDocumentType.findForSettlementNote())).collect(Collectors.toList()));
        model.addAttribute("PaymentCodePool_paymentMethod_options", PaymentMethod.findAll().collect(Collectors.toList()));
        this.setPaymentCodePool(paymentCodePool, model);
        return "treasury/administration/payments/sibs/managepaymentcodepool/paymentcodepool/update";
    }

    @RequestMapping(value={"/update/{oid}"}, method={RequestMethod.POST})
    public String update(@PathVariable(value="oid") PaymentCodePool paymentCodePool, @RequestParam(value="finantialinstitution", required=false) FinantialInstitution finantialInstitution, @RequestParam(value="name", required=false) String name, @RequestParam(value="entityreferencecode", required=false) String entityReferenceCode, @RequestParam(value="minreferencecode", required=false) Long minReferenceCode, @RequestParam(value="maxreferencecode", required=false) Long maxReferenceCode, @RequestParam(value="minamount", required=false) BigDecimal minAmount, @RequestParam(value="maxamount", required=false) BigDecimal maxAmount, @RequestParam(value="validfrom", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate validFrom, @RequestParam(value="validto", required=false) @DateTimeFormat(pattern="yyyy-MM-dd") LocalDate validTo, @RequestParam(value="active", required=false) Boolean active, @RequestParam(value="usecheckdigit", required=false) Boolean useCheckDigit, @RequestParam(value="documentnumberseries") DocumentNumberSeries documentNumberSeries, @RequestParam(value="paymentmethod") PaymentMethod paymentMethod, Model model, RedirectAttributes redirectAttributes) {
        this.setPaymentCodePool(paymentCodePool, model);
        try {
            this.assertUserIsManager(model);
            paymentCodePool.update(finantialInstitution, name, entityReferenceCode, minReferenceCode, maxReferenceCode, minAmount, maxAmount, validFrom, validTo, active, useCheckDigit, documentNumberSeries, paymentMethod);
            return this.redirect(READ_URL + this.getPaymentCodePool(model).getExternalId(), model, redirectAttributes);
        }
        catch (TreasuryDomainException tex) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + tex.getLocalizedMessage(), model);
        }
        catch (Exception de) {
            this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"label.error.update", (String[])new String[0]) + de.getLocalizedMessage(), model);
        }
        return this.update(paymentCodePool, model);
    }
}

