/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.accounting.managecustomer;

import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.DebitEntry;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.paymentcodes.PaymentReferenceCode;
import org.fenixedu.treasury.domain.paymentcodes.pool.PaymentCodePool;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.dto.document.managepayments.PaymentReferenceCodeBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Component(value="org.fenixedu.treasury.ui.accounting.managecustomer")
@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/accounting/managecustomer/paymentreferencecode"})
public class PaymentReferenceCodeController
extends TreasuryBaseController {
    public static final String CONTROLLER_URL = "/treasury/accounting/managecustomer/paymentreferencecode";
    private static final String JSP_PATH = "treasury/accounting/managecustomer/paymentreferencecode";
    private static final String _CREATEPAYMENTCODEFORSEVERALDEBITENTRIES_URI = "/createpaymentcodeforseveraldebitentries";
    public static final String CREATEPAYMENTCODEFORSEVERALDEBITENTRIES_URL = "/treasury/accounting/managecustomer/paymentreferencecode/createpaymentcodeforseveraldebitentries";
    private static final String _CREATEPAYMENTCODEFORSEVERALDEBITENTRIESPOSTBACK_URI = "/createpaymentcodeforseveraldebitentriespostback";
    public static final String CREATEPAYMENTCODEFORSEVERALDEBITENTRIESPOSTBACK_URL = "/treasury/accounting/managecustomer/paymentreferencecode/createpaymentcodeforseveraldebitentriespostback";

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/accounting/managecustomer/paymentreferencecode/";
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentries/{debtAccountId}"}, method={RequestMethod.GET})
    public String createPaymentCodeForSeveralDebitEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, Model model) {
        this.assertUserIsFrontOfficeMember(debtAccount.getFinantialInstitution(), model);
        PaymentReferenceCodeBean bean = new PaymentReferenceCodeBean((PaymentCodePool)PaymentCodePool.findByActive((Boolean)true, (FinantialInstitution)debtAccount.getFinantialInstitution()).findFirst().orElse(null), debtAccount);
        return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
    }

    private String _createPaymentCodeForSeveralDebitEntries(DebtAccount debtAccount, PaymentReferenceCodeBean bean, Model model) {
        model.addAttribute("debtAccount", (Object)debtAccount);
        model.addAttribute("bean", (Object)bean);
        model.addAttribute("beanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        return this.jspPage("createpaymentcodeforseveraldebitentries");
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentriespostback/{debtAccountId}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public ResponseEntity<String> createPaymentCodeForSeveralDebitEntriesPostback(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model) {
        bean.updateAmountOnSelectedDebitEntries();
        return new ResponseEntity((Object)this.getBeanJson((ITreasuryBean)bean), HttpStatus.OK);
    }

    @RequestMapping(value={"/createpaymentcodeforseveraldebitentries/{debtAccountId}"}, method={RequestMethod.POST})
    public String createPaymentCodeForSeveralDebitEntries(@PathVariable(value="debtAccountId") DebtAccount debtAccount, @RequestParam(value="bean") PaymentReferenceCodeBean bean, Model model, RedirectAttributes redirectAttributes) {
        this.assertUserIsFrontOfficeMember(debtAccount.getFinantialInstitution(), model);
        try {
            if (bean.getSelectedDebitEntries() == null || bean.getSelectedDebitEntries().isEmpty()) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.MultipleEntriesPaymentCode.select.at.least.one.debit.entry", (String[])new String[0]), model);
                return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
            }
            if (bean.getPaymentCodePool() == null) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.MultipleEntriesPaymentCode.payment.code.pool.required", (String[])new String[0]), model);
                return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
            }
            this.assertUserIsFrontOfficeMember(((DebitEntry)bean.getSelectedDebitEntries().iterator().next()).getDebtAccount().getFinantialInstitution(), model);
            bean.setUsePaymentAmountWithInterests(false);
            PaymentReferenceCode.createPaymentReferenceCodeForMultipleDebitEntries((DebtAccount)debtAccount, (PaymentReferenceCodeBean)bean);
            this.addInfoMessage(TreasuryConstants.treasuryBundle((String)"label.document.managepayments.success.create.reference.code.selected.debit.entries", (String[])new String[0]), model);
            return this.redirect(String.format("/treasury/accounting/managecustomer/debtaccount/read//%s", debtAccount.getExternalId()), model, redirectAttributes);
        }
        catch (TreasuryDomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._createPaymentCodeForSeveralDebitEntries(debtAccount, bean, model);
        }
    }

    private String jspPage(String page) {
        return "treasury/accounting/managecustomer/paymentreferencecode/" + page;
    }
}

