/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.accounting.managecustomer;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.SpringFunctionality;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.CustomerType;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.TreasuryController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController$callable$delete;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController$callable$deleteCustomer;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

@SpringFunctionality(app=TreasuryController.class, title="label.title.accounting.manageCustomer", accessGroup="treasuryFrontOffice")
@RequestMapping(value={"/treasury/accounting/managecustomer/customer"})
public class CustomerController
extends TreasuryBaseController {
    public static final String CONTROLLER_URI = "/treasury/accounting/managecustomer/customer";
    private static final String SEARCH_URI = "/";
    public static final String SEARCH_FULL_URI = "/treasury/accounting/managecustomer/customer/";
    private static final String READ_URI = "/read/";
    public static final String READ_URL = "/treasury/accounting/managecustomer/customer/read/";
    public static final long SEARCH_LIMIT_SIZE = 500L;
    public static final String SEARCH_TO_VIEW_ACTION_URI = "/search/view/";
    public static final String _DELETE_URI = "/delete/";
    public static final Advice advice$deleteCustomer = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
    public static final Advice advice$delete = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

    @RequestMapping
    public String home(Model model) {
        return "forward:/treasury/accounting/managecustomer/customer/";
    }

    private Customer getCustomer(Model model) {
        return (Customer)model.asMap().get("customer");
    }

    private void setCustomer(Customer customer, Model model) {
        model.addAttribute("customer", (Object)customer);
    }

    public void deleteCustomer(Customer customer) {
        Object object = advice$deleteCustomer.perform((Callable)new CustomerController$callable$deleteCustomer(this, customer));
    }

    static /* synthetic */ void advised$deleteCustomer(CustomerController this_, Customer customer) {
    }

    @RequestMapping(value={"/"})
    public String search(@RequestParam(value="finantialInstitution", required=false) FinantialInstitution institution, @RequestParam(value="customertype", required=false) CustomerType customerType, @RequestParam(value="customer", required=false) String customer, Model model) {
        List<Customer> result = CustomerController.filterSearch(institution, customerType, customer);
        model.addAttribute("limit_exceeded", (Object)((long)result.size() > 500L ? 1 : 0));
        model.addAttribute("searchcustomerResultsDataSet_totalCount", (Object)result.size());
        model.addAttribute("searchcustomerResultsDataSet", result.stream().limit(500L).collect(Collectors.toList()));
        model.addAttribute("Customer_customerType_options", CustomerType.findAll().collect(Collectors.toList()));
        model.addAttribute("finantialinstitution_options", FinantialInstitution.findAll().collect(Collectors.toList()));
        return "treasury/accounting/managecustomer/customer/search";
    }

    private static Stream<? extends Customer> getSearchUniverse(FinantialInstitution institution) {
        return institution == null ? Customer.findAll() : Customer.find((FinantialInstitution)institution);
    }

    private static List<Customer> filterSearch(FinantialInstitution institution, CustomerType customerType, String customerString) {
        ArrayList result = Lists.newArrayList();
        boolean search = false;
        Predicate<Customer> predicate = i -> true;
        if (institution != null) {
            search = true;
        }
        if (customerType != null) {
            search = true;
            predicate = predicate.and(i -> customerType == i.getCustomerType());
        }
        if (!Strings.isNullOrEmpty((String)customerString)) {
            search = true;
            predicate = predicate.and(i -> i.matchesMultiFilter(customerString.trim()));
        }
        if (search) {
            CustomerController.getSearchUniverse(institution).filter(predicate).collect(Collectors.toCollection(() -> result));
        }
        return result;
    }

    @RequestMapping(value={"/search/view/{oid}"})
    public String processSearchToViewAction(@PathVariable(value="oid") Customer customer, Model model, RedirectAttributes redirectAttributes) {
        return this.redirect(READ_URL + customer.getExternalId(), model, redirectAttributes);
    }

    @RequestMapping(value={"/read/{oid}"})
    public String read(@PathVariable(value="oid") Customer customer, Model model, RedirectAttributes redirectAttributes) {
        if (!customer.isActive() && customer.isUiOtherRelatedCustomerActive()) {
            return this.redirect(customer.uiRedirectToActiveCustomer(READ_URL), model, redirectAttributes);
        }
        this.setCustomer(customer, model);
        ArrayList pendingInvoiceEntries = new ArrayList();
        for (DebtAccount debtAccount : customer.getDebtAccountsSet()) {
            pendingInvoiceEntries.addAll(debtAccount.getPendingInvoiceEntriesSet());
        }
        model.addAttribute("pendingDocumentsDataSet", pendingInvoiceEntries.stream().sorted(InvoiceEntry.COMPARE_BY_ENTRY_DATE.reversed().thenComparing(InvoiceEntry.COMPARE_BY_DUE_DATE.reversed())).collect(Collectors.toList()));
        return "treasury/accounting/managecustomer/customer/read";
    }

    @RequestMapping(value={"/delete/{oid}"})
    public String delete(@PathVariable(value="oid") Customer customer, Model model, RedirectAttributes redirectAttributes) {
        try {
            this.delete(customer);
            return this.redirect(SEARCH_FULL_URI, model, redirectAttributes);
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this.read(customer, model, redirectAttributes);
        }
    }

    private void delete(Customer customer) {
        Object object = advice$delete.perform((Callable)new CustomerController$callable$delete(this, customer));
    }

    static /* synthetic */ void advised$delete(CustomerController this_, Customer customer) {
        customer.delete();
    }
}

