/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.ui.accounting.managecustomer;

import com.google.common.base.Strings;
import org.fenixedu.bennu.core.domain.exceptions.DomainException;
import org.fenixedu.bennu.spring.portal.BennuSpringController;
import org.fenixedu.treasury.domain.AdhocCustomer;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.dto.AdhocCustomerBean;
import org.fenixedu.treasury.dto.ITreasuryBean;
import org.fenixedu.treasury.ui.TreasuryBaseController;
import org.fenixedu.treasury.ui.accounting.managecustomer.CustomerController;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@BennuSpringController(value=CustomerController.class)
@RequestMapping(value={"/treasury/accounting/managecustomer/changefiscalnumber"})
public class ChangeAdhocCustomerFiscalNumberController
extends TreasuryBaseController {
    public static final String CONTROLLER_URI = "/treasury/accounting/managecustomer/changefiscalnumber";
    private static final String JSP_PATH = "/treasury/accounting/managecustomer/changefiscalnumber";
    private static final String CHANGE_FISCAL_NUMBER_ACTION_CONFIRM_URI = "/changefiscalnumberactionconfirm";
    public static final String CHANGE_FISCAL_NUMBER_ACTION_CONFIRM_URL = "/treasury/accounting/managecustomer/changefiscalnumber/changefiscalnumberactionconfirm";
    private static final String CHANGE_FISCAL_NUMBER_FORM_URI = "/changefiscalnumberform";
    public static final String CHANGE_FISCAL_NUMBER_FORM_URL = "/treasury/accounting/managecustomer/changefiscalnumber/changefiscalnumberform";
    private static final String CHANGE_POSTBACK_URI = "/changepostback";
    public static final String CHANGE_POSTBACK_URL = "/treasury/accounting/managecustomer/changefiscalnumber/changepostback";
    private static final String CHANGE_FISCAL_NUMBER_URI = "/change";
    public static final String CHANGE_FISCAL_NUMBER_URL = "/treasury/accounting/managecustomer/changefiscalnumber/change";

    protected String getControllerURI() {
        return "/treasury/accounting/managecustomer/changefiscalnumber";
    }

    @RequestMapping(value={"/changefiscalnumberactionconfirm/{oid}"}, method={RequestMethod.GET})
    public String changefiscalnumberactionconfirm(@PathVariable(value="oid") AdhocCustomer customer, Model model) {
        this.assertUserIsBackOfficeMember(model);
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("changeFiscalNumberActionFormURI", (Object)this.getControllerURI());
        if (customer.isFiscalValidated() && customer.isFiscalCodeValid()) {
            model.addAttribute("fiscalNumberValid", (Object)true);
        }
        return this.jspPage(CHANGE_FISCAL_NUMBER_ACTION_CONFIRM_URI);
    }

    @RequestMapping(value={"/changefiscalnumberform/{oid}"}, method={RequestMethod.POST})
    public String changefiscalnumberform(@PathVariable(value="oid") Customer customer, Model model) {
        this.assertUserIsBackOfficeMember(model);
        AdhocCustomerBean bean = new AdhocCustomerBean(customer);
        return this._changefiscalnumberactionconfirm(customer, model, bean);
    }

    private String _changefiscalnumberactionconfirm(Customer customer, Model model, AdhocCustomerBean bean) {
        model.addAttribute("customer", (Object)customer);
        model.addAttribute("customerBean", (Object)bean);
        model.addAttribute("customerBeanJson", (Object)this.getBeanJson((ITreasuryBean)bean));
        return this.jspPage(CHANGE_FISCAL_NUMBER_FORM_URI);
    }

    @RequestMapping(value={"/changepostback/{oid}"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public String changepostback(@PathVariable(value="oid") AdhocCustomer customer, @RequestParam(value="bean") AdhocCustomerBean bean, Model model) {
        bean.update();
        return this.getBeanJson((ITreasuryBean)bean);
    }

    @RequestMapping(value={"/change/{oid}"}, method={RequestMethod.POST})
    public String change(@PathVariable(value="oid") AdhocCustomer adhocCustomer, @RequestParam(value="bean") AdhocCustomerBean bean, Model model) {
        this.assertUserIsBackOfficeMember(model);
        try {
            if (!bean.isChangeFiscalNumberConfirmed()) {
                throw new TreasuryDomainException("message.Customer.changeFiscalNumber.confirmation", new String[0]);
            }
            if (Strings.isNullOrEmpty((String)bean.getAddressCountryCode())) {
                this.addErrorMessage(TreasuryConstants.treasuryBundle((String)"error.Customer.addressCountryCode.required", (String[])new String[0]), model);
                return this._changefiscalnumberactionconfirm((Customer)adhocCustomer, model, bean);
            }
            if (!bean.isAddressValid()) {
                throw new TreasuryDomainException("error.AdhocCustomer.fill.required.address.fields", new String[0]);
            }
            adhocCustomer.changeFiscalNumber(bean);
            return "forward:/treasury/accounting/managecustomer/customer/read/" + adhocCustomer.getExternalId();
        }
        catch (DomainException e) {
            this.addErrorMessage(e.getLocalizedMessage(), model);
            return this._changefiscalnumberactionconfirm((Customer)adhocCustomer, model, bean);
        }
    }

    private String jspPage(String page) {
        return "/treasury/accounting/managecustomer/changefiscalnumber" + page;
    }
}

