/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration.erp.tasks;

import java.util.List;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.annotation.Task;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.integration.ERPExportOperation;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager;

@Task(englishTitle="Export Pending Documents to ERP Integration", readOnly=true)
public class ERPExportPendingDocumentsTask
extends CronTask {
    public void runTask() throws Exception {
        FinantialInstitution.findAll().forEach(x -> {
            this.taskLog("Start Exporting Pending Documents for : " + x.getName(), new Object[0]);
            try {
                if (!x.getErpIntegrationConfiguration().getActive()) {
                    return;
                }
                List exportPendingDocumentsForFinantialInstitution = ERPExporterManager.exportPendingDocumentsForFinantialInstitution((FinantialInstitution)x);
                for (ERPExportOperation exportOperation : exportPendingDocumentsForFinantialInstitution) {
                    for (FinantialDocument doc : exportOperation.getFinantialDocumentsSet()) {
                        this.taskLog(String.format("Exported document: %s => %s", doc.getUiDocumentNumber(), exportOperation.getSuccess() ? "OK" : "NOK"), new Object[0]);
                    }
                }
                int documentsCount = exportPendingDocumentsForFinantialInstitution.stream().mapToInt(oper -> oper.getFinantialDocumentsSet().size()).sum();
                this.taskLog("Finished Exporting %d Pending Documents for : %s", new Object[]{documentsCount, x.getName()});
            }
            catch (Exception ex) {
                this.taskLog("Error exporting pending documents: " + ex.getMessage(), new Object[0]);
                for (StackTraceElement el : ex.getStackTrace()) {
                    this.taskLog(el.toString(), new Object[0]);
                }
            }
        });
    }
}

