/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.services.integration;

import com.qubit.solution.fenixedu.bennu.webservices.domain.webservice.WebServiceClientConfiguration;
import com.qubit.solution.fenixedu.bennu.webservices.domain.webservice.WebServiceConfiguration;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.LocaleUtils;
import org.fenixedu.bennu.core.i18n.BundleUtil;
import org.fenixedu.bennu.core.security.Authenticate;
import org.fenixedu.bennu.core.util.CoreConfiguration;
import org.fenixedu.bennu.io.domain.GenericFile;
import org.fenixedu.bennu.io.domain.IGenericFile;
import org.fenixedu.bennu.scheduler.CronTask;
import org.fenixedu.bennu.scheduler.TaskRunner;
import org.fenixedu.bennu.scheduler.domain.SchedulerSystem;
import org.fenixedu.commons.i18n.LocalizedString;
import org.fenixedu.treasury.domain.TreasuryFile;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.integration.ERPConfiguration;
import org.fenixedu.treasury.services.integration.FenixEDUTreasuryPlatformDependentServices$1$callable$run;
import org.fenixedu.treasury.services.integration.FenixEDUTreasuryPlatformDependentServices$2$callable$run;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.erp.ERPExporterManager;
import org.fenixedu.treasury.services.integration.erp.IERPExternalService;
import org.fenixedu.treasury.services.integration.erp.tasks.ERPExportSingleDocumentsTask;
import org.joda.time.DateTime;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class FenixEDUTreasuryPlatformDependentServices
implements ITreasuryPlatformDependentServices {
    private static final int WAIT_TRANSACTION_TO_FINISH_MS = 500;

    public void scheduleSingleDocument(FinantialDocument finantialDocument) {
        List documentsToExport = ERPExporterManager.filterDocumentsToExport(Collections.singletonList(finantialDocument).stream());
        if (documentsToExport.isEmpty()) {
            return;
        }
        final String externalId = ((FinantialDocument)documentsToExport.iterator().next()).getExternalId();
        new Thread(){
            public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

            @Override
            public void run() {
                Object object = advice$run.perform((Callable)new FenixEDUTreasuryPlatformDependentServices$1$callable$run(this));
            }

            static /* synthetic */ void advised$run(1 this_) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SchedulerSystem.queue((TaskRunner)new TaskRunner((CronTask)new ERPExportSingleDocumentsTask(this_.externalId)));
            }
        }.start();
    }

    public IERPExternalService getERPExternalServiceImplementation(ERPConfiguration erpConfiguration) {
        String className = erpConfiguration.getImplementationClassName();
        try {
            Class<?> cl = Class.forName(className);
            WebServiceClientConfiguration clientConfiguration = (WebServiceClientConfiguration)WebServiceConfiguration.readByImplementationClass((String)className);
            IERPExternalService client = (IERPExternalService)clientConfiguration.getClient();
            return client;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TreasuryDomainException("error.ERPConfiguration.invalid.external.service", new String[0]);
        }
    }

    public byte[] getFileContent(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getContent();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public long getFileSize(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getSize();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DateTime getFileCreationDate(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getCreationDate();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getFilename(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getFilename();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream getFileStream(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getStream();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getFileContentType(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            return file.getContentType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void createFile(IGenericFile genericFile, String fileName, String contentType, byte[] content) {
        try {
            TreasuryFile file = TreasuryFile.create(fileName, contentType, content);
            PropertyUtils.setProperty((Object)genericFile, (String)"treasuryFile", (Object)((Object)file));
            genericFile.setFileId(file.getExternalId());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteFile(IGenericFile genericFile) {
        try {
            GenericFile file = (GenericFile)PropertyUtils.getProperty((Object)genericFile, (String)"treasuryFile");
            file.delete();
            PropertyUtils.setProperty((Object)genericFile, (String)"treasuryFile", null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getLoggedUsername() {
        if (Authenticate.getUser() == null) {
            return null;
        }
        return Authenticate.getUser().getUsername();
    }

    public Locale defaultLocale() {
        return LocaleUtils.toLocale((String)CoreConfiguration.getConfiguration().defaultLocale());
    }

    public Set<Locale> availableLocales() {
        return CoreConfiguration.supportedLocales();
    }

    public String bundle(String bundleName, String key, String ... args) {
        return BundleUtil.getString((String)bundleName, (String)key, (String[])args);
    }

    public String bundle(Locale locale, String bundleName, String key, String ... args) {
        return BundleUtil.getString((String)bundleName, (Locale)locale, (String)key, (String[])args);
    }

    public LocalizedString bundleI18N(String bundleName, String key, String ... args) {
        return BundleUtil.getLocalizedString((String)bundleName, (String)key, (String[])args);
    }

    public <T> String versioningCreatorUsername(T obj) {
        return FenixEDUTreasuryPlatformDependentServices.readVersioningCreatorUsername(obj);
    }

    public <T> DateTime versioningCreationDate(T obj) {
        return FenixEDUTreasuryPlatformDependentServices.readVersioningCreationDate(obj);
    }

    public <T> String versioningUpdatorUsername(T obj) {
        return FenixEDUTreasuryPlatformDependentServices.readVersioningUpdatorUsername(obj);
    }

    public <T> DateTime versioningUpdateDate(T obj) {
        return FenixEDUTreasuryPlatformDependentServices.readVersioningUpdateDate(obj);
    }

    public static <T> String readVersioningCreatorUsername(T obj) {
        try {
            String username = (String)PropertyUtils.getProperty(obj, (String)"versioningCreator");
            return username;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> DateTime readVersioningCreationDate(T obj) {
        try {
            DateTime creationDate = (DateTime)PropertyUtils.getProperty(obj, (String)"versioningCreationDate");
            return creationDate;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> String readVersioningUpdatorUsername(T obj) {
        try {
            Object versioningUpdatedBy = PropertyUtils.getProperty(obj, (String)"versioningUpdatedBy");
            if (versioningUpdatedBy == null) {
                return null;
            }
            return (String)PropertyUtils.getProperty((Object)versioningUpdatedBy, (String)"username");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> DateTime readVersioningUpdateDate(T obj) {
        try {
            Object versioningUpdateDate = PropertyUtils.getProperty(obj, (String)"versioningUpdateDate");
            if (versioningUpdateDate == null) {
                return null;
            }
            return (DateTime)PropertyUtils.getProperty((Object)versioningUpdateDate, (String)"date");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] getFileContent(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFileContent(String): not supported");
    }

    public long getFileSize(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFileSize(String): not supported");
    }

    public String getFilename(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFilename(String): not supported");
    }

    public InputStream getFileStream(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFileStream(String): not supported");
    }

    public DateTime getFileCreationDate(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFileCreationDate(String): not supported");
    }

    public String getFileContentType(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.getFileContentType(String): not supported");
    }

    public String createFile(String fileName, String contentType, byte[] content) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.createFile(): not supported");
    }

    public void deleteFile(String fileId) {
        throw new RuntimeException("FenixEDUTreasuryPlatformDependentServices.deleteFile(String): not supported");
    }

    public void scheduleDocumentForExportation(FinantialDocument finantialDocument) {
        List documentsToExport = ERPExporterManager.filterDocumentsToExport(Collections.singletonList(finantialDocument).stream());
        if (documentsToExport.isEmpty()) {
            return;
        }
        final String externalId = ((FinantialDocument)documentsToExport.iterator().next()).getExternalId();
        new Thread(){
            public static final Advice advice$run = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));

            @Override
            public void run() {
                Object object = advice$run.perform((Callable)new FenixEDUTreasuryPlatformDependentServices$2$callable$run(this));
            }

            static /* synthetic */ void advised$run(2 this_) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SchedulerSystem.queue((TaskRunner)new TaskRunner((CronTask)new ERPExportSingleDocumentsTask(this_.externalId)));
            }
        }.start();
    }
}

