/*
 * Decompiled with CFR 0.152.
 */
package org.fenixedu.treasury.domain.document;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.fenixedu.treasury.domain.Currency;
import org.fenixedu.treasury.domain.Customer;
import org.fenixedu.treasury.domain.FinantialInstitution;
import org.fenixedu.treasury.domain.Product;
import org.fenixedu.treasury.domain.Vat;
import org.fenixedu.treasury.domain.debt.DebtAccount;
import org.fenixedu.treasury.domain.document.CreditEntry;
import org.fenixedu.treasury.domain.document.CreditNote;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$annulDebitEntry;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$annulOnEvent;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$clearInterestRate;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$createInterestRateDebitEntry;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$creditDebitEntry;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$markAcademicalActBlockingSuspension;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$markBlockAcademicActsOnDebt;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$removeFromDocument;
import org.fenixedu.treasury.domain.document.DebitEntry$callable$revertEventAnnuled;
import org.fenixedu.treasury.domain.document.DebitEntry_Base;
import org.fenixedu.treasury.domain.document.DebitNote;
import org.fenixedu.treasury.domain.document.DocumentNumberSeries;
import org.fenixedu.treasury.domain.document.FinantialDocument;
import org.fenixedu.treasury.domain.document.FinantialDocumentEntry;
import org.fenixedu.treasury.domain.document.FinantialDocumentType;
import org.fenixedu.treasury.domain.document.FinantialEntryType;
import org.fenixedu.treasury.domain.document.Invoice;
import org.fenixedu.treasury.domain.document.InvoiceEntry;
import org.fenixedu.treasury.domain.document.InvoiceEntry_Base;
import org.fenixedu.treasury.domain.document.SettlementEntry;
import org.fenixedu.treasury.domain.document.SettlementNote;
import org.fenixedu.treasury.domain.document.SettlementNote_Base;
import org.fenixedu.treasury.domain.event.TreasuryEvent;
import org.fenixedu.treasury.domain.exceptions.TreasuryDomainException;
import org.fenixedu.treasury.domain.exemption.TreasuryExemption;
import org.fenixedu.treasury.domain.forwardpayments.ForwardPayment;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentEntry;
import org.fenixedu.treasury.domain.paymentPlan.InstallmentSettlementEntry;
import org.fenixedu.treasury.domain.paymentPlan.PaymentPlan;
import org.fenixedu.treasury.domain.paymentcodes.SibsPaymentRequest;
import org.fenixedu.treasury.domain.settings.TreasurySettings;
import org.fenixedu.treasury.domain.tariff.InterestRate;
import org.fenixedu.treasury.domain.treasurydebtprocess.TreasuryDebtProcessMainService;
import org.fenixedu.treasury.dto.InterestRateBean;
import org.fenixedu.treasury.services.integration.ITreasuryPlatformDependentServices;
import org.fenixedu.treasury.services.integration.TreasuryPlataformDependentServicesFactory;
import org.fenixedu.treasury.services.integration.erp.sap.SAPExporter;
import org.fenixedu.treasury.util.TreasuryConstants;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import pt.ist.esw.advice.Advice;
import pt.ist.esw.advice.pt.ist.fenixframework.AtomicInstance;
import pt.ist.fenixframework.Atomic;
import pt.ist.fenixframework.atomic.AtomicContextFactory;

public class DebitEntry
extends DebitEntry_Base {
    public static final Comparator<DebitEntry> COMPARE_BY_OPEN_AMOUNT_WITH_VAT;
    public static final Comparator<DebitEntry> COMPARE_BY_DUE_DATE;
    public static final Comparator<DebitEntry> COMPARE_BY_EVENT_ANNULED_AND_BY_DATE;
    public static final Comparator<DebitEntry> COMPARE_BY_EVENT_ANNULED_AND_DUE_DATE;
    public static final Comparator<DebitEntry> COMPARE_DEBIT_ENTRY_IN_SAME_PAYMENT_PLAN;
    public static Comparator<DebitEntry> COMPARE_BY_EXTERNAL_ID;
    public static final Advice advice$createInterestRateDebitEntry;
    public static final Advice advice$markAcademicalActBlockingSuspension;
    public static final Advice advice$markBlockAcademicActsOnDebt;
    public static final Advice advice$annulOnEvent;
    public static final Advice advice$revertEventAnnuled;
    public static final Advice advice$clearInterestRate;
    public static final Advice advice$annulDebitEntry;
    public static final Advice advice$creditDebitEntry;
    public static final Advice advice$removeFromDocument;

    protected DebitEntry(DebitNote debitNote, DebtAccount debtAccount, TreasuryEvent treasuryEvent, Vat vat, BigDecimal amount, LocalDate dueDate, Map<String, String> propertiesMap, Product product, String description, BigDecimal quantity, InterestRate interestRate, DateTime entryDateTime) {
        this.init(debitNote, debtAccount, treasuryEvent, product, vat, amount, dueDate, propertiesMap, description, quantity, interestRate, entryDateTime);
    }

    public boolean isDebitNoteEntry() {
        return true;
    }

    public boolean isDeletable() {
        ArrayList blockers = Lists.newArrayList();
        this.checkForDeletionBlockers(blockers);
        return blockers.isEmpty();
    }

    protected void checkForDeletionBlockers(Collection<String> blockers) {
        super.checkForDeletionBlockers(blockers);
        this.getInterestDebitEntriesSet().stream().forEach(ide -> ide.checkForDeletionBlockers(blockers));
        if (!this.getCreditEntriesSet().isEmpty()) {
            blockers.add(TreasuryConstants.treasuryBundle("error.DebitEntry.cannot.delete.has.creditentries", new String[0]));
        }
    }

    public void delete() {
        TreasuryDomainException.throwWhenDeleteBlocked(this.getDeletionBlockers());
        if (!this.getTreasuryExemptionsSet().isEmpty()) {
            this.getTreasuryExemptionsSet().forEach(exemption -> {
                exemption.setDebitEntry(null);
                exemption.delete();
            });
        }
        if (this.getInterestRate() != null) {
            InterestRate oldRate = this.getInterestRate();
            this.setInterestRate(null);
            oldRate.delete();
        }
        this.setDebitEntry(null);
        this.setTreasuryEvent(null);
        this.getPaymentCodesSet().clear();
        super.delete();
    }

    protected void init(FinantialDocument finantialDocument, DebtAccount debtAccount, Product product, FinantialEntryType finantialEntryType, Vat vat, BigDecimal amount, String description, BigDecimal quantity, DateTime entryDateTime) {
        throw new RuntimeException("error.CreditEntry.use.init.without.finantialEntryType");
    }

    protected void init(DebitNote debitNote, DebtAccount debtAccount, TreasuryEvent treasuryEvent, Product product, Vat vat, BigDecimal amount, LocalDate dueDate, Map<String, String> propertiesMap, String description, BigDecimal quantity, InterestRate interestRate, DateTime entryDateTime) {
        super.init((FinantialDocument)((Object)debitNote), debtAccount, product, FinantialEntryType.DEBIT_ENTRY, vat, amount, description, quantity, entryDateTime);
        this.setTreasuryEvent(treasuryEvent);
        this.setDueDate(dueDate);
        this.setPropertiesJsonMap(TreasuryConstants.propertiesMapToJson(propertiesMap));
        this.setNetExemptedAmount(BigDecimal.ZERO);
        this.setInterestRate(interestRate);
        this.setAcademicalActBlockingSuspension(false);
        this.setBlockAcademicActsOnDebt(false);
        this.recalculateAmountValues();
        this.checkRules();
    }

    protected BigDecimal calculateNetAmount() {
        BigDecimal netAmount = Currency.getValueWithScale(this.getQuantity().multiply(this.getAmount()));
        netAmount = netAmount.subtract(this.getNetExemptedAmount());
        return netAmount;
    }

    public InterestRateBean calculateAllInterestValue(LocalDate whenToCalculate) {
        if (this.getInterestRate() == null) {
            return new InterestRateBean();
        }
        if (!this.toCalculateInterests(whenToCalculate)) {
            return new InterestRateBean();
        }
        return this.getInterestRate().calculateInterests(whenToCalculate, true);
    }

    public InterestRateBean calculateAllInterestsByLockingAtDate(LocalDate lockDate) {
        if (this.getInterestRate() == null) {
            return new InterestRateBean();
        }
        if (!this.toCalculateInterests(lockDate)) {
            return new InterestRateBean();
        }
        return this.getInterestRate().calculateAllInterestsByLockingAtDate(lockDate);
    }

    public InterestRateBean calculateUndebitedInterestValue(LocalDate whenToCalculate) {
        if (!this.isApplyInterests()) {
            return new InterestRateBean();
        }
        if (this.isInOpenPaymentPlan() && this.getOpenPaymentPlan().isCompliant(whenToCalculate)) {
            return new InterestRateBean();
        }
        if (!this.toCalculateInterests(whenToCalculate)) {
            return new InterestRateBean();
        }
        InterestRateBean calculateInterest = this.getInterestRate().calculateInterests(whenToCalculate, false);
        calculateInterest.setDescription(TreasuryConstants.treasuryBundle(TreasuryConstants.DEFAULT_LANGUAGE, "label.InterestRateBean.interest.designation", this.getDescription()));
        return calculateInterest;
    }

    public boolean isApplyInterests() {
        return this.getInterestRate() != null;
    }

    private boolean toCalculateInterests(LocalDate whenToCalculate) {
        return !whenToCalculate.isBefore((ReadablePartial)this.getDueDate().plusDays(this.getInterestRate().getNumberOfDaysAfterDueDate()));
    }

    protected void checkRules() {
        super.checkRules();
        if (this.getFinantialDocument() != null && !(this.getFinantialDocument() instanceof DebitNote)) {
            throw new TreasuryDomainException("error.DebitEntry.finantialDocument.not.debit.entry.type", new String[0]);
        }
        if (this.getDebtAccount() == null) {
            throw new TreasuryDomainException("error.DebitEntry.debtAccount.required", new String[0]);
        }
        if (this.getDueDate() == null) {
            throw new TreasuryDomainException("error.DebitEntry.dueDate.required", new String[0]);
        }
        if (this.getEntryDateTime() != null && this.getDueDate().isBefore((ReadablePartial)this.getEntryDateTime().toLocalDate())) {
            throw new TreasuryDomainException("error.DebitEntry.dueDate.invalid", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)this.getDescription())) {
            throw new TreasuryDomainException("error.DebitEntry.description.required", new String[0]);
        }
        if (this.getTreasuryEvent() != null && this.getProduct().isTransferBalanceProduct()) {
            throw new TreasuryDomainException("error.DebitEntry.transferBalanceProduct.cannot.be.associated.to.academic.event", new String[0]);
        }
        if (this.isBlockAcademicActsOnDebt() && this.isAcademicalActBlockingSuspension()) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.suspend.and.also.block.academical.acts.on.debt", new String[0]);
        }
    }

    public boolean isFinantialDocumentRequired() {
        return false;
    }

    public boolean isEventAnnuled() {
        return this.isAnnulled() || this.getEventAnnuled();
    }

    public boolean isIncludedInEvent() {
        return !this.isEventAnnuled();
    }

    public BigDecimal getPendingInterestAmount() {
        return this.getPendingInterestAmount(new LocalDate());
    }

    public BigDecimal getPendingInterestAmount(LocalDate whenToCalculate) {
        return this.calculateUndebitedInterestValue(whenToCalculate).getInterestAmount();
    }

    public boolean isInDebt() {
        return TreasuryConstants.isPositive(this.getOpenAmount());
    }

    public boolean isDueDateExpired(LocalDate when) {
        return this.getDueDate().isBefore((ReadablePartial)when);
    }

    public DebitEntry createInterestRateDebitEntry(InterestRateBean interestRateBean, DateTime dateTime, Optional<DebitNote> optional) {
        return (DebitEntry)((Object)advice$createInterestRateDebitEntry.perform((Callable)new DebitEntry$callable$createInterestRateDebitEntry(this, interestRateBean, dateTime, optional)));
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    static /* synthetic */ DebitEntry advised$createInterestRateDebitEntry(DebitEntry this_, InterestRateBean interest, DateTime when, Optional debitNote) {
        Product product = TreasurySettings.getInstance().getInterestProduct();
        if (product == null) {
            throw new TreasuryDomainException("error.SettlementNote.need.interest.product", new String[0]);
        }
        FinantialInstitution finantialInstitution = this_.getDebtAccount().getFinantialInstitution();
        Vat vat = Vat.findActiveUnique(product.getVatType(), finantialInstitution, new DateTime()).orElse(null);
        String entryDescription = interest.getDescription();
        if (Strings.isNullOrEmpty((String)entryDescription)) {
            entryDescription = product.getName().getContent() + "-" + this_.getDescription();
        }
        DebitEntry interestEntry = DebitEntry._create(debitNote, this_.getDebtAccount(), this_.getTreasuryEvent(), vat, interest.getInterestAmount(), when.toLocalDate(), TreasuryConstants.propertiesJsonToMap(this_.getPropertiesJsonMap()), product, entryDescription, BigDecimal.ONE, null, when);
        this_.addInterestDebitEntries(interestEntry);
        return interestEntry;
    }

    public void edit(String description, TreasuryEvent treasuryEvent, LocalDate dueDate, boolean academicalActBlockingSuspension, boolean blockAcademicActsOnDebt) {
        this.setDescription(description);
        this.setTreasuryEvent(treasuryEvent);
        this.setDueDate(dueDate);
        this.setAcademicalActBlockingSuspension(academicalActBlockingSuspension);
        this.setBlockAcademicActsOnDebt(blockAcademicActsOnDebt);
        this.checkRules();
    }

    public boolean isAcademicalActBlockingSuspension() {
        return this.getAcademicalActBlockingSuspension();
    }

    public boolean getAcademicalActBlockingAfterDueDate() {
        return !this.isAcademicalActBlockingSuspension();
    }

    public boolean isAcademicalActBlockingAfterDueDate() {
        return this.getAcademicalActBlockingAfterDueDate();
    }

    public void setAcademicalActBlockingAfterDueDate(boolean value) {
        this.setAcademicalActBlockingSuspension(!value);
    }

    public boolean isBlockAcademicActsOnDebt() {
        return this.getBlockAcademicActsOnDebt();
    }

    public boolean exempt(TreasuryExemption treasuryExemption) {
        if (treasuryExemption.getTreasuryEvent() != this.getTreasuryEvent()) {
            throw new RuntimeException("wrong call");
        }
        if (treasuryExemption.getProduct() != this.getProduct()) {
            throw new RuntimeException("wrong call");
        }
        if (this.isEventAnnuled()) {
            throw new RuntimeException("error.DebitEntry.is.event.annuled.cannot.be.exempted");
        }
        if (TreasuryDebtProcessMainService.isFinantialDocumentEntryAnnullmentActionBlocked((FinantialDocumentEntry)((Object)this))) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.annul.or.credit.due.to.existing.active.debt.process", new String[0]);
        }
        if (TreasuryConstants.isGreaterThan(treasuryExemption.getNetExemptedAmount(), this.getAvailableNetAmountForCredit())) {
            throw new TreasuryDomainException("error.DebitEntry.exemptedAmount.cannot.be.greater.than.availableAmount", new String[0]);
        }
        if (this.isProcessedInClosedDebitNote()) {
            BigDecimal netExemptedAmount = treasuryExemption.getNetExemptedAmount();
            DateTime now = new DateTime();
            String reason = TreasuryConstants.treasuryBundle("label.TreasuryExemption.credit.entry.exemption.description", this.getDescription(), treasuryExemption.getTreasuryExemptionType().getName().getContent());
            CreditEntry creditEntryFromExemption = this.createCreditEntry(now, this.getDescription(), null, null, netExemptedAmount, treasuryExemption, null);
            this.closeCreditEntryIfPossible(reason, now, creditEntryFromExemption);
            creditEntryFromExemption.getFinantialDocument().setDocumentObservations(String.format("[%s] - %s", treasuryExemption.getTreasuryExemptionType().getName().getContent(), treasuryExemption.getReason()));
        } else {
            BigDecimal netExemptedAmount = treasuryExemption.getNetExemptedAmount();
            this.setNetExemptedAmount(this.getNetExemptedAmount().add(netExemptedAmount));
            BigDecimal oldNetAmount = this.getNetAmount();
            this.recalculateAmountValues();
            if (!TreasuryConstants.isEqual(oldNetAmount, this.getNetAmount().add(netExemptedAmount))) {
                throw new IllegalStateException("The sum of netAmount and netExemptedAmount is not equal to the netAmount before applying the exemption");
            }
            if (this.getNetExemptedAmount().scale() > this.getDebtAccount().getFinantialInstitution().getCurrency().getDecimalPlacesForCents()) {
                throw new IllegalStateException("The netExemptedAmount has scale above the currency decimal places for cents");
            }
            if (this.getTreasuryEvent() != null) {
                this.getTreasuryEvent().invokeSettlementCallbacks();
            }
        }
        this.checkRules();
        return true;
    }

    public CreditEntry createCreditEntry(DateTime documentDate, String description, String documentObservations, String documentTermsAndConditions, BigDecimal netAmountForCredit, TreasuryExemption treasuryExemption, CreditNote creditNote) {
        boolean isToCloseCreditNoteWhenCreated = this.getDebtAccount().getFinantialInstitution().isToCloseCreditNoteWhenCreated();
        boolean isInvoiceRegistrationByTreasuryCertification = this.getDebtAccount().getFinantialInstitution().isInvoiceRegistrationByTreasuryCertification();
        DebitNote finantialDocument = (DebitNote)((Object)this.getFinantialDocument());
        if (finantialDocument == null) {
            throw new TreasuryDomainException("error.DebitEntry.createCreditEntry.requires.finantial.document", new String[0]);
        }
        if (creditNote != null && !creditNote.isPreparing()) {
            throw new TreasuryDomainException("error.DebitEntry.createCreditEntry.creditNote.is.not.preparing", new String[0]);
        }
        DocumentNumberSeries documentNumberSeries = DocumentNumberSeries.find(FinantialDocumentType.findForCreditNote(), finantialDocument.getDocumentNumberSeries().getSeries());
        if (creditNote == null) {
            creditNote = CreditNote.create(this.getDebtAccount(), documentNumberSeries, documentDate, finantialDocument, finantialDocument.getUiDocumentNumber());
        }
        if (!Strings.isNullOrEmpty((String)documentObservations)) {
            creditNote.setDocumentObservations(documentObservations);
        }
        if (!Strings.isNullOrEmpty((String)documentTermsAndConditions)) {
            creditNote.setDocumentTermsAndConditions(documentTermsAndConditions);
        }
        if (!TreasuryConstants.isPositive(netAmountForCredit)) {
            throw new TreasuryDomainException("error.DebitEntry.createCreditEntry.amountForCredit.not.positive", new String[0]);
        }
        CreditEntry creditEntry = null;
        creditEntry = treasuryExemption != null ? CreditEntry.createFromExemption(treasuryExemption, (FinantialDocument)((Object)creditNote), description, netAmountForCredit, new DateTime(), this, BigDecimal.ONE) : CreditEntry.create((FinantialDocument)((Object)creditNote), description, this.getProduct(), this.getVat(), netAmountForCredit, documentDate, this, BigDecimal.ONE);
        if (!isInvoiceRegistrationByTreasuryCertification && isToCloseCreditNoteWhenCreated) {
            creditNote.closeDocument();
        }
        return creditEntry;
    }

    public void closeCreditEntryIfPossible(String reason, DateTime now, CreditEntry creditEntry) {
        DocumentNumberSeries documentNumberSeriesSettlementNote = DocumentNumberSeries.find(FinantialDocumentType.findForSettlementNote(), this.getFinantialDocument().getDocumentNumberSeries().getSeries());
        boolean isToCloseCreditNoteWhenCreated = this.getDebtAccount().getFinantialInstitution().isToCloseCreditNoteWhenCreated();
        boolean isInvoiceRegistrationByTreasuryCertification = this.getDebtAccount().getFinantialInstitution().isInvoiceRegistrationByTreasuryCertification();
        if (creditEntry.getFinantialDocument().isAnnulled()) {
            throw new TreasuryDomainException("error.DebitEntry.closeCreditEntryIfPossible.creditEntry.is.annulled", new String[0]);
        }
        if (!(isInvoiceRegistrationByTreasuryCertification || creditEntry.getFinantialDocument().isPreparing() || isToCloseCreditNoteWhenCreated)) {
            return;
        }
        BigDecimal minimumOpenAmount = creditEntry.getOpenAmount();
        if (TreasuryConstants.isLessThan(this.getOpenAmount(), creditEntry.getOpenAmount())) {
            minimumOpenAmount = this.getOpenAmount();
        }
        if (!TreasuryConstants.isPositive(minimumOpenAmount)) {
            return;
        }
        if (!isInvoiceRegistrationByTreasuryCertification && TreasuryConstants.isLessThan(minimumOpenAmount, creditEntry.getOpenAmount()) && creditEntry.getFinantialDocument().isPreparing()) {
            creditEntry.splitCreditEntry(creditEntry.getOpenAmount().subtract(minimumOpenAmount));
        }
        if (creditEntry.getFinantialDocument().isPreparing()) {
            creditEntry.getFinantialDocument().closeDocument();
        }
        String loggedUsername = TreasuryPlataformDependentServicesFactory.implementation().getLoggedUsername();
        String reasonDescription = TreasuryConstants.treasuryBundle(TreasuryConstants.DEFAULT_LANGUAGE, "label.TreasuryEvent.credit.by.annulAllDebitEntries.reason", new String[0]);
        SettlementNote settlementNote = SettlementNote.create(this.getDebtAccount(), documentNumberSeriesSettlementNote, now, now, "", null);
        settlementNote.setDocumentObservations(reason + " - [" + loggedUsername + "] " + new DateTime().toString("YYYY-MM-dd HH:mm"));
        SettlementEntry.create((InvoiceEntry)((Object)creditEntry), settlementNote, minimumOpenAmount, reasonDescription + ": " + creditEntry.getDescription(), now, false);
        SettlementEntry debitSettlementEntry = SettlementEntry.create((InvoiceEntry)((Object)this), settlementNote, minimumOpenAmount, reasonDescription + ": " + this.getDescription(), now, false);
        InstallmentSettlementEntry.settleInstallmentEntriesOfDebitEntry(debitSettlementEntry);
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && this.getFinantialDocument().isExportedInLegacyERP() != creditEntry.getFinantialDocument().isExportedInLegacyERP()) {
            throw new TreasuryDomainException("error.DebitEntry.closeCreditEntryIfPossible.exportedInLegacyERP.not.same", new String[0]);
        }
        if (((Invoice)((Object)this.getFinantialDocument())).getPayorDebtAccount() != ((Invoice)((Object)this.getFinantialDocument())).getPayorDebtAccount()) {
            throw new TreasuryDomainException("error.DebitEntry.closeCreditEntryIfPossible.payorDebtAccount.not.same", new String[0]);
        }
        if (TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && this.getFinantialDocument().isExportedInLegacyERP()) {
            settlementNote.setExportedInLegacyERP(true);
            settlementNote.setCloseDate(SAPExporter.ERP_INTEGRATION_START_DATE.minusSeconds(1));
        }
        settlementNote.closeDocument();
    }

    public boolean isExportedInERPAndInRestrictedPaymentMixingLegacyInvoices() {
        return TreasurySettings.getInstance().isRestrictPaymentMixingLegacyInvoices() && this.getFinantialDocument() != null && this.getFinantialDocument().isExportedInLegacyERP();
    }

    public BigDecimal getAmountInDebt(LocalDate paymentDate) {
        TreeSet<SettlementEntry> entries = new TreeSet<SettlementEntry>(SettlementEntry.COMPARATOR_BY_ENTRY_DATE_TIME);
        entries.addAll(this.getSettlementEntriesSet());
        BigDecimal amountToPay = this.getAmountWithVat();
        for (SettlementEntry settlementEntry : entries) {
            if (settlementEntry.isAnnulled()) continue;
            if (settlementEntry.getEntryDateTime().toLocalDate().isAfter((ReadablePartial)paymentDate)) break;
            amountToPay = amountToPay.subtract(settlementEntry.getAmount());
        }
        return amountToPay;
    }

    public void revertExemptionIfPossibleInPreparingState(TreasuryExemption treasuryExemption) {
        if (this.isAnnulled()) {
            throw new TreasuryDomainException("error.TreasuryExemption.delete.impossible.due.to.processed.debit.or.credit.entry", new String[0]);
        }
        if (this.isProcessedInClosedDebitNote()) {
            throw new TreasuryDomainException("error.TreasuryExemption.delete.impossible.due.to.processed.debit.or.credit.entry", new String[0]);
        }
        if (!this.getCreditEntriesSet().isEmpty()) {
            throw new TreasuryDomainException("error.TreasuryExemption.delete.impossible.due.to.processed.debit.or.credit.entry", new String[0]);
        }
        BigDecimal netExemptedAmount = treasuryExemption.getNetExemptedAmount();
        this.setNetExemptedAmount(this.getNetExemptedAmount().subtract(netExemptedAmount));
        this.recalculateAmountValues();
        if (this.getNetExemptedAmount().scale() > this.getDebtAccount().getFinantialInstitution().getCurrency().getDecimalPlacesForCents()) {
            throw new IllegalStateException("The netExemptedAmount has scale above the currency decimal places for cents");
        }
        this.checkRules();
    }

    public BigDecimal getUiPossibleMaximumAmountToExempt() {
        return this.getNetAmount().min(this.getAvailableNetAmountForCredit());
    }

    public void markAcademicalActBlockingSuspension() {
        Object object = advice$markAcademicalActBlockingSuspension.perform((Callable)new DebitEntry$callable$markAcademicalActBlockingSuspension(this));
    }

    static /* synthetic */ void advised$markAcademicalActBlockingSuspension(DebitEntry this_) {
        this_.setAcademicalActBlockingSuspension(true);
    }

    public void markBlockAcademicActsOnDebt() {
        Object object = advice$markBlockAcademicActsOnDebt.perform((Callable)new DebitEntry$callable$markBlockAcademicActsOnDebt(this));
    }

    static /* synthetic */ void advised$markBlockAcademicActsOnDebt(DebitEntry this_) {
        this_.setBlockAcademicActsOnDebt(true);
    }

    public void annulOnEvent() {
        Object object = advice$annulOnEvent.perform((Callable)new DebitEntry$callable$annulOnEvent(this));
    }

    static /* synthetic */ void advised$annulOnEvent(DebitEntry this_) {
        this_.setEventAnnuled(true);
    }

    public void revertEventAnnuled() {
        Object object = advice$revertEventAnnuled.perform((Callable)new DebitEntry$callable$revertEventAnnuled(this));
    }

    static /* synthetic */ void advised$revertEventAnnuled(DebitEntry this_) {
        this_.setEventAnnuled(false);
    }

    public DateTime getLastSettlementDate() {
        Optional<SettlementNote> settlementNote = this.getSettlementEntriesSet().stream().filter(s -> !s.getFinantialDocument().isAnnulled()).map(s -> (SettlementNote)((Object)((Object)((Object)s.getFinantialDocument())))).max(Comparator.comparing(SettlementNote_Base::getPaymentDate));
        if (!settlementNote.isPresent()) {
            return null;
        }
        return settlementNote.get().getPaymentDate();
    }

    @Deprecated
    public BigDecimal getExemptedAmount() {
        return super.getExemptedAmount();
    }

    @Deprecated
    public void setExemptedAmount(BigDecimal exemptedAmount) {
        super.setExemptedAmount(exemptedAmount);
    }

    public BigDecimal getNetExemptedAmount() {
        return super.getExemptedAmount();
    }

    public void setNetExemptedAmount(BigDecimal exemptedAmount) {
        super.setExemptedAmount(exemptedAmount);
    }

    public DateTime getLastPaymentDate() {
        HashSet<SettlementNote> settlementNotesToConsiderSet = new HashSet<SettlementNote>();
        for (SettlementEntry debitEntrySettlementEntry : this.getSettlementEntriesSet()) {
            SettlementNote note = (SettlementNote)((Object)debitEntrySettlementEntry.getFinantialDocument());
            if (note.isAnnulled() || note.getSettlemetEntriesSet().stream().filter(se -> se != debitEntrySettlementEntry).filter(se -> se.getInvoiceEntry().isCreditNoteEntry()).filter(se -> ((CreditEntry)((Object)((Object)((Object)se.getInvoiceEntry())))).getDebitEntry() == this).anyMatch(se -> TreasuryConstants.isGreaterOrEqualThan(se.getAmount(), debitEntrySettlementEntry.getAmount()))) continue;
            settlementNotesToConsiderSet.add(note);
        }
        Optional<SettlementNote> settlementNote = settlementNotesToConsiderSet.stream().max(Comparator.comparing(SettlementNote_Base::getPaymentDate));
        if (!settlementNote.isPresent()) {
            return null;
        }
        return settlementNote.get().getPaymentDate();
    }

    @Deprecated
    public void editAmount(BigDecimal amount) {
        if (this.isProcessedInClosedDebitNote()) {
            throw new TreasuryDomainException("error.DebitEntry.editAmount.cannot.edit.amount.due.to.closed.in.debit.note", new String[0]);
        }
        if (this.isAnnulled()) {
            throw new TreasuryDomainException("error.DebitEntry.editAmount.cannot.edit.amount.due.to.annuled.state", new String[0]);
        }
        this.setAmount(amount);
        this.recalculateAmountValues();
    }

    public static DebitEntry copyDebitEntry(DebitEntry debitEntryToCopy, DebitNote debitNoteToAssociate, boolean applyExemption) {
        ITreasuryPlatformDependentServices services = TreasuryPlataformDependentServicesFactory.implementation();
        String loggedUsername = services.getLoggedUsername();
        HashMap propertiesMap = Maps.newHashMap((Map)(debitEntryToCopy.getPropertiesMap() != null ? debitEntryToCopy.getPropertiesMap() : Maps.newHashMap()));
        propertiesMap.put(TreasuryEvent.TreasuryEventKeys.COPIED_FROM_DEBIT_ENTRY_ID.getDescriptionI18N().getContent(TreasuryConstants.DEFAULT_LANGUAGE), debitEntryToCopy.getExternalId());
        propertiesMap.put(TreasuryEvent.TreasuryEventKeys.COPY_DEBIT_ENTRY_RESPONSIBLE.getDescriptionI18N().getContent(TreasuryConstants.DEFAULT_LANGUAGE), StringUtils.isNotEmpty((String)loggedUsername) ? loggedUsername : "");
        DebitEntry result = DebitEntry.create(Optional.ofNullable(debitNoteToAssociate), debitEntryToCopy.getDebtAccount(), debitEntryToCopy.getTreasuryEvent(), debitEntryToCopy.getVat(), debitEntryToCopy.getAmount().add(debitEntryToCopy.getNetExemptedAmount()), debitEntryToCopy.getDueDate(), propertiesMap, debitEntryToCopy.getProduct(), debitEntryToCopy.getDescription(), debitEntryToCopy.getQuantity(), debitEntryToCopy.getInterestRate(), debitEntryToCopy.getEntryDateTime());
        result.edit(result.getDescription(), result.getTreasuryEvent(), result.getDueDate(), debitEntryToCopy.getAcademicalActBlockingSuspension(), debitEntryToCopy.getBlockAcademicActsOnDebt());
        result.setEventAnnuled(false);
        result.setPayorDebtAccount(debitEntryToCopy.getPayorDebtAccount());
        if (applyExemption) {
            debitEntryToCopy.getTreasuryExemptionsSet().forEach(exemption -> TreasuryExemption.create(exemption.getTreasuryExemptionType(), exemption.getTreasuryEvent(), exemption.getReason(), exemption.getNetAmountToExempt(), result));
        }
        return result;
    }

    public static Stream<? extends DebitEntry> findAll() {
        return FinantialDocumentEntry.findAll().filter(f -> f instanceof DebitEntry).map(DebitEntry.class::cast);
    }

    public static Stream<? extends DebitEntry> find(Customer customer) {
        return customer.getDebtAccountsSet().stream().flatMap(d -> DebitEntry.find(d));
    }

    public static Stream<? extends DebitEntry> find(DebtAccount debtAccount) {
        return debtAccount.getInvoiceEntrySet().stream().filter(i -> i.isDebitNoteEntry()).map(DebitEntry.class::cast);
    }

    public static Stream<? extends DebitEntry> find(DebitNote debitNote) {
        return debitNote.getFinantialDocumentEntriesSet().stream().filter(f -> f instanceof DebitEntry).map(DebitEntry.class::cast);
    }

    public static Stream<? extends DebitEntry> find(TreasuryEvent treasuryEvent) {
        return treasuryEvent.getDebitEntriesSet().stream();
    }

    public static Stream<? extends DebitEntry> findActive(DebtAccount debtAccount, Product product) {
        return DebitEntry.find(debtAccount).filter(d -> d.getProduct() == product && !d.isEventAnnuled());
    }

    public static Stream<? extends DebitEntry> findActive(TreasuryEvent treasuryEvent) {
        return DebitEntry.find(treasuryEvent).filter(d -> !d.isEventAnnuled());
    }

    public static Stream<? extends DebitEntry> findActive(TreasuryEvent treasuryEvent, Product product) {
        return DebitEntry.findActive(treasuryEvent).filter(d -> d.getProduct() == product);
    }

    public static Stream<? extends DebitEntry> findActiveByDescription(TreasuryEvent treasuryEvent, String description, boolean trimmed) {
        return DebitEntry.findActive(treasuryEvent).filter(d -> !trimmed && d.getDescription().equals(description) || trimmed && d.getDescription().trim().equals(description));
    }

    public static Stream<? extends DebitEntry> findEventAnnuled(TreasuryEvent treasuryEvent) {
        return DebitEntry.find(treasuryEvent).filter(d -> d.isEventAnnuled());
    }

    public static Stream<? extends DebitEntry> findEventAnnuled(TreasuryEvent treasuryEvent, Product product) {
        return DebitEntry.findEventAnnuled(treasuryEvent).filter(d -> d.getProduct() == product);
    }

    public static BigDecimal payedAmount(TreasuryEvent treasuryEvent) {
        return DebitEntry.findActive(treasuryEvent).map(d -> d.getPayedAmount()).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
    }

    public static BigDecimal remainingAmountToPay(TreasuryEvent treasuryEvent) {
        return DebitEntry.findActive(treasuryEvent).map(d -> d.getOpenAmount()).reduce((x, y) -> x.add((BigDecimal)y)).orElse(BigDecimal.ZERO);
    }

    public static DebitEntry create(Optional<DebitNote> debitNote, DebtAccount debtAccount, TreasuryEvent treasuryEvent, Vat vat, BigDecimal amount, LocalDate dueDate, Map<String, String> propertiesMap, Product product, String description, BigDecimal quantity, InterestRate interestRate, DateTime entryDateTime) {
        if (!DebitEntry.isDebitEntryCreationAllowed(debtAccount, debitNote, product)) {
            throw new TreasuryDomainException("error.DebitEntry.customer.not.active", new String[0]);
        }
        return DebitEntry._create(debitNote, debtAccount, treasuryEvent, vat, amount, dueDate, propertiesMap, product, description, quantity, interestRate, entryDateTime);
    }

    public static DebitEntry createForImportationPurpose(Optional<DebitNote> debitNote, DebtAccount debtAccount, TreasuryEvent treasuryEvent, Vat vat, BigDecimal amount, LocalDate dueDate, Map<String, String> propertiesMap, Product product, String description, BigDecimal quantity, InterestRate interestRate, DateTime entryDateTime) {
        return DebitEntry._create(debitNote, debtAccount, treasuryEvent, vat, amount, dueDate, propertiesMap, product, description, quantity, interestRate, entryDateTime);
    }

    private static boolean isDebitEntryCreationAllowed(DebtAccount debtAccount, Optional<DebitNote> debitNote, Product product) {
        if (debtAccount.getCustomer().isActive()) {
            return true;
        }
        return debitNote.isPresent() && debitNote.get().getDocumentNumberSeries().getSeries().isRegulationSeries();
    }

    private static DebitEntry _create(Optional<DebitNote> debitNote, DebtAccount debtAccount, TreasuryEvent treasuryEvent, Vat vat, BigDecimal amount, LocalDate dueDate, Map<String, String> propertiesMap, Product product, String description, BigDecimal quantity, InterestRate interestRate, DateTime entryDateTime) {
        DebitEntry entry = new DebitEntry(debitNote.orElse(null), debtAccount, treasuryEvent, vat, amount, dueDate, propertiesMap, product, description, quantity, null, entryDateTime);
        if (interestRate != null) {
            InterestRate.createForDebitEntry(entry, interestRate);
        }
        return entry;
    }

    public void changeInterestRate(InterestRate oldInterestRate) {
        if (this.getInterestRate() != null && this.getInterestRate() != oldInterestRate) {
            oldInterestRate.delete();
        }
        this.checkRules();
    }

    @Deprecated
    public BigDecimal getTotalCreditedAmount() {
        BigDecimal totalCreditedAmount = BigDecimal.ZERO;
        for (CreditEntry credits : this.getCreditEntriesSet()) {
            if (credits.getFinantialDocument() != null && credits.getFinantialDocument().isAnnulled()) continue;
            totalCreditedAmount = totalCreditedAmount.add(credits.getTotalAmount());
        }
        this.getCurrency();
        return Currency.getValueWithScale(totalCreditedAmount);
    }

    public BigDecimal getTotalCreditedAmountWithVat() {
        return this.getTotalCreditedAmount();
    }

    @Deprecated
    public BigDecimal getAvailableAmountForCredit() {
        this.getCurrency();
        return Currency.getValueWithScale(this.getTotalAmount().subtract(this.getTotalCreditedAmount()));
    }

    public BigDecimal getAvailableAmountWithVatForCredit() {
        return this.getAvailableAmountForCredit();
    }

    public BigDecimal getAvailableNetAmountForCredit() {
        BigDecimal creditedNetAmount = this.getCreditEntriesSet().stream().filter(c -> c.getFinantialDocument() == null || !c.getFinantialDocument().isAnnulled()).map(InvoiceEntry_Base::getNetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        return this.getNetAmount().subtract(creditedNetAmount);
    }

    public BigDecimal getOpenAmountWithInterests() {
        if (this.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        if (TreasuryConstants.isEqual(this.getOpenAmount(), BigDecimal.ZERO)) {
            return this.getOpenAmount();
        }
        return this.getOpenAmount().add(this.getPendingInterestAmount());
    }

    public BigDecimal getOpenAmountWithInterestsAtDate(LocalDate date) {
        if (this.isAnnulled()) {
            return BigDecimal.ZERO;
        }
        if (TreasuryConstants.isEqual(this.getOpenAmount(), BigDecimal.ZERO)) {
            return this.getOpenAmount();
        }
        return this.getOpenAmount().add(this.getPendingInterestAmount(date));
    }

    public void clearInterestRate() {
        Object object = advice$clearInterestRate.perform((Callable)new DebitEntry$callable$clearInterestRate(this));
    }

    static /* synthetic */ void advised$clearInterestRate(DebitEntry this_) {
        if (this_.getInterestRate() != null) {
            this_.getInterestRate().delete();
        }
    }

    public String getERPIntegrationMetadata() {
        String degreeCode = this.getDegreeCode();
        String executionYear = this.getExecutionYearName();
        return "{\"" + (Object)((Object)TreasuryEvent.TreasuryEventKeys.DEGREE_CODE) + "\":\"" + degreeCode + "\",\"" + (Object)((Object)TreasuryEvent.TreasuryEventKeys.EXECUTION_YEAR) + "\":\"" + executionYear + "\"}";
    }

    public String getExecutionYearName() {
        String executionYear = "";
        if (this.getTreasuryEvent() != null && !Strings.isNullOrEmpty((String)this.getTreasuryEvent().getExecutionYearName())) {
            executionYear = this.getTreasuryEvent().getExecutionYearName();
        } else if (this.getPropertiesMap() != null) {
            if (this.getPropertiesMap().containsKey((Object)TreasuryEvent.TreasuryEventKeys.EXECUTION_YEAR)) {
                executionYear = (String)this.getPropertiesMap().get((Object)TreasuryEvent.TreasuryEventKeys.EXECUTION_YEAR);
            } else if (this.getPropertiesMap().containsKey(TreasuryEvent.TreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent())) {
                executionYear = (String)this.getPropertiesMap().get(TreasuryEvent.TreasuryEventKeys.EXECUTION_YEAR.getDescriptionI18N().getContent());
            }
        }
        return executionYear;
    }

    public String getDegreeCode() {
        String degreeCode = "";
        if (this.getTreasuryEvent() != null && !Strings.isNullOrEmpty((String)this.getTreasuryEvent().getDegreeCode())) {
            degreeCode = this.getTreasuryEvent().getDegreeCode();
        } else if (this.getPropertiesMap() != null) {
            if (this.getPropertiesMap().containsKey((Object)TreasuryEvent.TreasuryEventKeys.DEGREE_CODE)) {
                degreeCode = (String)this.getPropertiesMap().get((Object)TreasuryEvent.TreasuryEventKeys.DEGREE_CODE);
            } else if (this.getPropertiesMap().containsKey(TreasuryEvent.TreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent())) {
                degreeCode = (String)this.getPropertiesMap().get(TreasuryEvent.TreasuryEventKeys.DEGREE_CODE.getDescriptionI18N().getContent());
            }
        }
        return degreeCode;
    }

    public DebitNote getDebitNote() {
        return (DebitNote)((Object)this.getFinantialDocument());
    }

    public Set<SibsPaymentRequest> getSibsPaymentRequests() {
        return this.getSibsPaymentRequestsSet();
    }

    public Set<SibsPaymentRequest> getSibsPaymentRequestsSet() {
        return this.getPaymentRequestsSet().stream().filter(r -> r instanceof SibsPaymentRequest).map(SibsPaymentRequest.class::cast).collect(Collectors.toSet());
    }

    public void annulDebitEntry(String string) {
        Object object = advice$annulDebitEntry.perform((Callable)new DebitEntry$callable$annulDebitEntry(this, string));
    }

    static /* synthetic */ void advised$annulDebitEntry(DebitEntry this_, String reason) {
        if (this_.isAnnulled()) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.annul.is.already.annuled", new String[0]);
        }
        if (this_.getFinantialDocument() != null) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.annul.with.finantial.document", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)reason)) {
            throw new TreasuryDomainException("error.DebitEntry.annul.debit.entry.requires.reason", new String[0]);
        }
        if (TreasuryDebtProcessMainService.isFinantialDocumentEntryAnnullmentActionBlocked((FinantialDocumentEntry)((Object)this_))) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.annul.or.credit.due.to.existing.active.debt.process", new String[0]);
        }
        DebitNote debitNote = DebitNote.create(this_.getDebtAccount(), DocumentNumberSeries.findUniqueDefault(FinantialDocumentType.findForDebitNote(), this_.getDebtAccount().getFinantialInstitution()).get(), new DateTime());
        this_.setFinantialDocument((FinantialDocument)((Object)debitNote));
        debitNote.anullDebitNoteWithCreditNote(reason, false);
    }

    public void creditDebitEntry(BigDecimal bigDecimal, String string, boolean bl) {
        Object object = advice$creditDebitEntry.perform((Callable)new DebitEntry$callable$creditDebitEntry(this, bigDecimal, string, bl));
    }

    static /* synthetic */ void advised$creditDebitEntry(DebitEntry this_, BigDecimal netAmountForCredit, String reason, boolean closeWithOtherDebitEntriesOfDebitNote) {
        if (this_.isAnnulled()) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.credit.is.already.annuled", new String[0]);
        }
        if (this_.getFinantialDocument() == null || this_.getFinantialDocument().isPreparing()) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.credit.without.or.preparing.finantial.document", new String[0]);
        }
        if (Strings.isNullOrEmpty((String)reason)) {
            throw new TreasuryDomainException("error.DebitEntry.credit.debit.entry.requires.reason", new String[0]);
        }
        if (TreasuryDebtProcessMainService.isFinantialDocumentEntryAnnullmentActionBlocked((FinantialDocumentEntry)((Object)this_))) {
            throw new TreasuryDomainException("error.DebitEntry.cannot.annul.or.credit.due.to.existing.active.debt.process", new String[0]);
        }
        if (!TreasuryConstants.isPositive(netAmountForCredit)) {
            throw new TreasuryDomainException("error.DebitEntry.credit.debit.entry.amountToCreditWithVat.must.be.positive", new String[0]);
        }
        if (!TreasuryConstants.isLessOrEqualThan(netAmountForCredit, this_.getAvailableNetAmountForCredit())) {
            throw new TreasuryDomainException("error.DebitEntry.credit.debit.entry.amountToCreditWithVat.must.be.less.or.equal.than.amountAvailableForCredit", new String[0]);
        }
        DateTime now = new DateTime();
        CreditEntry creditEntry = this_.createCreditEntry(now, this_.getDescription(), null, null, netAmountForCredit, null, null);
        this_.closeCreditEntryIfPossible(reason, now, creditEntry);
        if (closeWithOtherDebitEntriesOfDebitNote) {
            Supplier<Boolean> openCreditEntriesExistsFunc = () -> this.getCreditEntriesSet().stream().filter(c -> TreasuryConstants.isPositive(c.getOpenAmount())).count() > 0L;
            Supplier<Boolean> openDebitEntriesExistsFunc = () -> this.getDebitNote().getDebitEntriesSet().stream().filter(d -> TreasuryConstants.isPositive(d.getOpenAmount())).count() > 0L;
            while (openCreditEntriesExistsFunc.get().booleanValue() && openDebitEntriesExistsFunc.get().booleanValue()) {
                CreditEntry openCreditEntry = this_.getCreditEntriesSet().stream().filter(c -> TreasuryConstants.isPositive(c.getOpenAmount())).findFirst().get();
                DebitEntry openDebitEntry = this_.getDebitNote().getDebitEntriesSet().stream().filter(d -> TreasuryConstants.isPositive(d.getOpenAmount())).filter(d -> TreasuryConstants.isGreaterOrEqualThan(d.getOpenAmount(), openCreditEntry.getOpenAmount())).findFirst().orElse(null);
                if (openDebitEntry == null) {
                    openDebitEntry = this_.getDebitNote().getDebitEntriesSet().stream().filter(d -> TreasuryConstants.isPositive(d.getOpenAmount())).findFirst().orElse(null);
                }
                openDebitEntry.closeCreditEntryIfPossible(reason, now, openCreditEntry);
            }
        }
    }

    public void removeFromDocument() {
        Object object = advice$removeFromDocument.perform((Callable)new DebitEntry$callable$removeFromDocument(this));
    }

    static /* synthetic */ void advised$removeFromDocument(DebitEntry this_) {
        if (this_.getFinantialDocument() == null || !this_.getFinantialDocument().isPreparing()) {
            throw new TreasuryDomainException("error.DebitEntry.removeFromDocument.invalid.state", new String[0]);
        }
        this_.setFinantialDocument(null);
    }

    public boolean isInOpenPaymentPlan() {
        return this.getOpenPaymentPlan() != null;
    }

    public PaymentPlan getOpenPaymentPlan() {
        if (this.getEmolumentPaymentPlan() != null && this.getEmolumentPaymentPlan().getState().isOpen()) {
            return this.getEmolumentPaymentPlan();
        }
        return this.getInstallmentEntrySet().stream().filter(i -> i.getInstallment().getPaymentPlan().getState().isOpen()).map(inst -> inst.getInstallment().getPaymentPlan()).findFirst().orElse(null);
    }

    public List<InstallmentEntry> getSortedOpenInstallmentEntries() {
        return this.getInstallmentEntrySet().stream().filter(i -> i.getInstallment().getPaymentPlan().getState().isOpen()).sorted(InstallmentEntry.COMPARE_BY_DEBIT_ENTRY_COMPARATOR).collect(Collectors.toList());
    }

    @Deprecated
    public void addForwardPayments(ForwardPayment forwardPayments) {
        super.addForwardPayments(forwardPayments);
    }

    @Deprecated
    public void removeForwardPayments(ForwardPayment forwardPayments) {
        super.removeForwardPayments(forwardPayments);
    }

    @Deprecated
    public Set<ForwardPayment> getForwardPaymentsSet() {
        return super.getForwardPaymentsSet();
    }

    public void updateDueDate(LocalDate newDueDate) {
        this.setDueDate(newDueDate);
        this.checkRules();
    }

    static {
        advice$createInterestRateDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markAcademicalActBlockingSuspension = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$markBlockAcademicActsOnDebt = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$annulOnEvent = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$revertEventAnnuled = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$clearInterestRate = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$annulDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$creditDebitEntry = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        advice$removeFromDocument = AtomicContextFactory.getInstance().newAdvice((Annotation)new AtomicInstance(Atomic.TxMode.SPECULATIVE_READ, true));
        COMPARE_BY_OPEN_AMOUNT_WITH_VAT = (o1, o2) -> {
            int c = o1.getAmountWithVat().compareTo(o2.getAmountWithVat());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
        COMPARE_BY_DUE_DATE = (o1, o2) -> {
            int c = o1.getDueDate().compareTo((ReadablePartial)o2.getDueDate());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
        COMPARE_BY_EVENT_ANNULED_AND_BY_DATE = (o1, o2) -> {
            if (!o1.isEventAnnuled() && o2.isEventAnnuled()) {
                return -1;
            }
            if (o1.isEventAnnuled() && !o2.isEventAnnuled()) {
                return 1;
            }
            int c = o1.getEntryDateTime().compareTo((ReadableInstant)o2.getEntryDateTime());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
        COMPARE_BY_EVENT_ANNULED_AND_DUE_DATE = (o1, o2) -> {
            if (!o1.isEventAnnuled() && o2.isEventAnnuled()) {
                return 1;
            }
            if (o1.isEventAnnuled() && !o2.isEventAnnuled()) {
                return -1;
            }
            int c = o1.getDueDate().compareTo((ReadablePartial)o2.getDueDate());
            return c != 0 ? c : o1.getExternalId().compareTo(o2.getExternalId());
        };
        COMPARE_DEBIT_ENTRY_IN_SAME_PAYMENT_PLAN = (m1, m2) -> {
            boolean m2IsEmolument;
            boolean m1IsInterest = m1.getDebitEntry() != null;
            boolean m1IsEmolument = m1.getEmolumentPaymentPlan() != null && m1.getEmolumentPaymentPlan().getState().isOpen();
            boolean m2IsInterest = m2.getDebitEntry() != null;
            boolean bl = m2IsEmolument = m2.getEmolumentPaymentPlan() != null && m2.getEmolumentPaymentPlan().getState().isOpen();
            if (m1IsInterest && m2IsInterest) {
                return m1.getDebitEntry().getDueDate().compareTo((ReadablePartial)m2.getDebitEntry().getDueDate()) * 100 + m1.getDueDate().compareTo((ReadablePartial)m2.getDueDate()) * 10 + m1.getExternalId().compareTo(m2.getExternalId());
            }
            if (m1IsInterest && !m2IsInterest) {
                return -1;
            }
            if (m1IsEmolument && m2IsInterest) {
                return 1;
            }
            if (m1IsEmolument && m2IsEmolument) {
                return m1.getDueDate().compareTo((ReadablePartial)m2.getDueDate()) * 10 + m1.getExternalId().compareTo(m2.getExternalId());
            }
            if (m1IsEmolument && !m2IsInterest && !m2IsEmolument) {
                return -1;
            }
            if (m2IsInterest || m2IsEmolument) {
                return 1;
            }
            return m1.getDueDate().compareTo((ReadablePartial)m2.getDueDate()) * 100 + m1.getDescription().compareTo(m2.getDescription()) * 10 + m1.getExternalId().compareTo(m2.getExternalId());
        };
        COMPARE_BY_EXTERNAL_ID = (o1, o2) -> o1.getExternalId().compareTo(o2.getExternalId());
    }
}

